/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.util;

import app.qwertz.qwertzcore.QWERTZcore;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class ChatManager
implements Listener {
    private final QWERTZcore plugin;

    public ChatManager(QWERTZcore plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!this.plugin.getConfigManager().getChat() && !event.getPlayer().hasPermission("qwertzcore.chat.bypass")) {
            event.setCancelled(true);
            this.plugin.getMessageManager().sendMessage(event.getPlayer(), "chatting.disabled");
            this.plugin.getSoundManager().playSound(event.getPlayer());
            return;
        }
        if (this.plugin.getConfigManager().getChatFormatting()) {
            event.setCancelled(true);
            Player player = event.getPlayer();
            String prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getRankManager().getPrefix(player));
            String suffix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getRankManager().getSuffix(player));
            String message = event.getMessage();
            if (this.plugin.getConfigManager().getColoredChat() && player.hasPermission("qwertzcore.chat.color")) {
                message = QWERTZcore.translateHexColorCodes(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
            }
            HashMap<String, String> localMap = new HashMap<String, String>();
            localMap.put("%name%", player.getName());
            localMap.put("%prefix%", prefix);
            localMap.put("%suffix%", suffix);
            String withoutMsg = this.translateEmojis(QWERTZcore.translateHexColorCodes(this.plugin.getMessageManager().prepareMessage(this.plugin.getMessageManager().getMessage("chatting.chat"), localMap)), player);
            Bukkit.broadcastMessage((String)withoutMsg.replace("%message%", message));
        }
    }

    public String translateEmojis(String message, Player player) {
        if (player.hasPermission("qwertzcore.player.emojis") && ((Boolean)this.plugin.getConfigManager().get("emojis")).booleanValue()) {
            List<String> emojis = this.plugin.getMessageManager().getStringList("emojis.emojis");
            for (String emoji : emojis) {
                String[] parts = emoji.split("\\|");
                message = message.replace(parts[0], parts.length > 1 ? parts[1] : parts[0]);
            }
        }
        return message;
    }
}

