/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.util;

import app.qwertz.qwertzcore.QWERTZcore;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class DatabaseManager {
    private final QWERTZcore plugin;
    private final File databaseFile;
    private Map<String, Object> database;
    private Map<String, String> specialBlocks;
    private final Gson gson;

    public DatabaseManager(QWERTZcore plugin) {
        this.plugin = plugin;
        this.databaseFile = new File(plugin.getDataFolder(), "database.json");
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.specialBlocks = new HashMap<String, String>();
        this.loadDatabase();
    }

    public void initializeSpecialBlocks() {
        this.loadSpecialBlocks();
    }

    private void loadDatabase() {
        if (!this.databaseFile.exists()) {
            this.database = new HashMap<String, Object>();
            this.database.put("players", new HashMap());
            this.database.put("specialBlocks", new HashMap());
            this.saveDatabase();
        } else {
            try (FileReader reader = new FileReader(this.databaseFile);){
                Type type = new TypeToken<Map<String, Object>>(){}.getType();
                this.database = (Map)this.gson.fromJson((Reader)reader, type);
                if (this.database == null) {
                    this.database = new HashMap<String, Object>();
                    this.database.put("players", new HashMap());
                    this.database.put("specialBlocks", new HashMap());
                }
                HashMap<String, PlayerData> players = new HashMap<String, PlayerData>();
                Map playersData = (Map)this.database.get("players");
                if (playersData != null) {
                    for (Map.Entry entry : playersData.entrySet()) {
                        players.put((String)entry.getKey(), (PlayerData)this.gson.fromJson(this.gson.toJson(entry.getValue()), PlayerData.class));
                    }
                }
                this.database.put("players", players);
                if (!this.database.containsKey("specialBlocks")) {
                    this.database.put("specialBlocks", new HashMap());
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not load database: " + e.getMessage());
                this.database = new HashMap<String, Object>();
                this.database.put("players", new HashMap());
                this.database.put("specialBlocks", new HashMap());
            }
        }
    }

    private void saveDatabase() {
        try (FileWriter writer = new FileWriter(this.databaseFile);){
            this.gson.toJson(this.database, (Appendable)writer);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save database: " + e.getMessage());
        }
    }

    public int getWins(UUID playerUUID) {
        PlayerData playerData = this.getPlayerData(playerUUID);
        return playerData.getWins();
    }

    public void addWin(UUID playerUUID) {
        PlayerData playerData = this.getPlayerData(playerUUID);
        playerData.addWin();
        this.saveDatabase();
    }

    public void removeWin(UUID playerUUID) {
        PlayerData playerData = this.getPlayerData(playerUUID);
        playerData.removeWin();
        this.saveDatabase();
    }

    public int getReviveTokens(UUID playerUUID) {
        PlayerData playerData = this.getPlayerData(playerUUID);
        return playerData.getReviveTokens();
    }

    public void addReviveToken(UUID playerUUID) {
        PlayerData playerData = this.getPlayerData(playerUUID);
        playerData.addReviveToken();
        this.saveDatabase();
    }

    public void setReviveTokens(UUID playerUUID, long amount) {
        PlayerData playerData = this.getPlayerData(playerUUID);
        playerData.setReviveTokens((int)amount);
        this.saveDatabase();
    }

    public void removeReviveToken(UUID playerUUID) {
        PlayerData playerData = this.getPlayerData(playerUUID);
        playerData.removeReviveToken();
        this.saveDatabase();
    }

    public void setReviveRequestCooldown(UUID playerUUID, long cooldownEndTime) {
        PlayerData playerData = this.getPlayerData(playerUUID);
        playerData.setReviveRequestCooldown(cooldownEndTime);
        this.saveDatabase();
    }

    public long getReviveRequestCooldown(UUID playerUUID) {
        PlayerData playerData = this.getPlayerData(playerUUID);
        return playerData.getReviveRequestCooldown();
    }

    public boolean isMessageToggleEnabled(UUID playerUUID) {
        PlayerData playerData = this.getPlayerData(playerUUID);
        return playerData.isMessageToggleEnabled();
    }

    public void setMessageToggleEnabled(UUID playerUUID, boolean enabled) {
        PlayerData playerData = this.getPlayerData(playerUUID);
        playerData.setMessageToggleEnabled(enabled);
        this.saveDatabase();
    }

    private PlayerData getPlayerData(UUID playerUUID) {
        String uuidString = playerUUID.toString();
        Map players = (Map)this.database.get("players");
        return players.computeIfAbsent(uuidString, k -> new PlayerData());
    }

    private void loadSpecialBlocks() {
        Map<String, String> loadedBlocks = this.getSpecialBlocks();
        if (loadedBlocks != null && !loadedBlocks.isEmpty()) {
            this.specialBlocks.clear();
            this.specialBlocks.putAll(loadedBlocks);
        }
    }

    public void saveSpecialBlocks(Map<String, String> blocks) {
        this.database.put("specialBlocks", blocks);
        this.saveDatabase();
    }

    public Map<String, String> getSpecialBlocks() {
        return new HashMap<String, String>((Map)this.database.get("specialBlocks"));
    }

    private static class PlayerData {
        private int wins = 0;
        private int reviveTokens = 0;
        private long reviveRequestCooldown = 0L;
        private boolean messageToggleEnabled = true;

        public int getWins() {
            return this.wins;
        }

        public void addWin() {
            ++this.wins;
        }

        public void removeWin() {
            --this.wins;
        }

        public int getReviveTokens() {
            return this.reviveTokens;
        }

        public void addReviveToken() {
            ++this.reviveTokens;
        }

        public void setReviveTokens(int reviveTokens) {
            this.reviveTokens = reviveTokens;
        }

        public void removeReviveToken() {
            this.reviveTokens = Math.max(0, this.reviveTokens - 1);
        }

        public long getReviveRequestCooldown() {
            return this.reviveRequestCooldown;
        }

        public void setReviveRequestCooldown(long cooldownEndTime) {
            this.reviveRequestCooldown = cooldownEndTime;
        }

        public boolean isMessageToggleEnabled() {
            return this.messageToggleEnabled;
        }

        public void setMessageToggleEnabled(boolean messageToggleEnabled) {
            this.messageToggleEnabled = messageToggleEnabled;
        }
    }
}

