/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.util;

import app.qwertz.qwertzcore.QWERTZcore;
import app.qwertz.qwertzcore.commands.HideCommand;
import app.qwertz.qwertzcore.util.UpdateChecker;
import java.util.HashMap;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerEventListener
implements Listener {
    private final QWERTZcore plugin;
    private final HideCommand hideCommand;
    private final UpdateChecker updateChecker;

    public PlayerEventListener(QWERTZcore plugin, HideCommand hideCommand, UpdateChecker updateChecker) {
        this.plugin = plugin;
        this.hideCommand = hideCommand;
        this.updateChecker = updateChecker;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getRejoinManager().isRejoining(player)) {
            this.plugin.getRejoinManager().handlePlayerRejoin(player);
            this.plugin.getVanishManager().hideVanishedPlayers(player);
            this.plugin.getScoreboardManager().setScoreboard(player);
            this.plugin.getTablistManager().updateTablist(player);
            return;
        }
        this.plugin.getVanishManager().hideVanishedPlayers(player);
        if (((Boolean)this.plugin.getConfigManager().get("checkForUpdates")).booleanValue()) {
            this.updateChecker.notifyPlayer(player);
        }
        this.hideCommand.handlePlayerJoin(player);
        this.plugin.getEventManager().addNewPlayer(player);
        if (this.plugin.getConfigManager().getTpOnJoin()) {
            player.teleport(this.plugin.getConfigManager().getSpawnLocation());
        }
        this.plugin.getScoreboardManager().setScoreboard(player);
        this.plugin.getTablistManager().updateTablist(player);
        if (this.plugin.getConfigManager().get("suppressVanilla").equals(true)) {
            int fakeCount = this.plugin.getVanishManager().getNonVanishedPlayerCount() - 1;
            int newCount = fakeCount + 1;
            HashMap<String, String> localMap = new HashMap<String, String>();
            localMap.put("%name%", player.getName());
            localMap.put("%count%", String.valueOf(fakeCount));
            localMap.put("%newCount%", String.valueOf(newCount));
            this.plugin.getMessageManager().broadcastMessage("chatting.join-msg", localMap);
            event.setJoinMessage(null);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.plugin.getRejoinManager().recordPlayerLeave(player);
        this.plugin.getEventManager().removePlayer(player);
        this.plugin.getVanishManager().removeVanishedPlayer(player);
        this.plugin.getScoreboardManager().removeScoreboard(player);
        if (this.plugin.getConfigManager().get("suppressVanilla").equals(true)) {
            int fakeCount = this.plugin.getVanishManager().getNonVanishedPlayerCount();
            int newCount = fakeCount - 1;
            HashMap<String, String> localMap = new HashMap<String, String>();
            localMap.put("%name%", player.getName());
            localMap.put("%count%", String.valueOf(fakeCount));
            localMap.put("%newCount%", String.valueOf(newCount));
            this.plugin.getMessageManager().broadcastMessage("chatting.leave-msg", localMap);
            event.setQuitMessage(null);
        }
    }
}

