/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.util;

import app.qwertz.qwertzcore.QWERTZcore;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class SoundManager {
    private final QWERTZcore plugin;

    public SoundManager(QWERTZcore plugin) {
        this.plugin = plugin;
    }

    public void broadcastConfigSound() {
        if (this.plugin.getConfigManager().playSounds()) {
            for (Player loop : Bukkit.getOnlinePlayers()) {
                loop.playSound((Entity)loop, Sound.valueOf((String)this.getConfigSound()), this.getSoundVolume(), this.getSoundPitch());
            }
        }
    }

    public void playSoundToSender(CommandSender sender) {
        if (this.plugin.getConfigManager().playSounds()) {
            try {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    player.playSound((Entity)player, Sound.valueOf((String)this.getConfigSound()), this.getSoundVolume(), this.getSoundPitch());
                }
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("The sound (or pitch/volume) in the config of QWERTZ Core is invalid. Please change it/them or the sounds won't play.");
            }
        }
    }

    public void playSound(Player player) {
        if (this.plugin.getConfigManager().playSounds()) {
            try {
                player.playSound((Entity)player, Sound.valueOf((String)this.getConfigSound()), this.getSoundVolume(), this.getSoundPitch());
            }
            catch (IllegalArgumentException e) {
                System.out.println("The sound (or pitch/volume) in the config of QWERTZ Core is invalid. Please change it/them or the sounds won't play.");
            }
        }
    }

    public String getConfigSound() {
        return this.plugin.getConfigManager().getConfigSound();
    }

    public float getSoundVolume() {
        return (float)this.plugin.getConfigManager().getSoundVolume();
    }

    public float getSoundPitch() {
        return (float)this.plugin.getConfigManager().getSoundPitch();
    }

    public boolean playSounds() {
        return this.plugin.getConfigManager().playSounds();
    }
}

