/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.util;

import app.qwertz.qwertzcore.QWERTZcore;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class UpdateChecker {
    private final QWERTZcore plugin;
    private String latestVersion;
    private String downloadUrl;
    private boolean updateAvailable = false;

    public UpdateChecker(QWERTZcore plugin) {
        this.plugin = plugin;
        this.checkForUpdates();
    }

    public void checkForUpdates() {
        try {
            InputStreamReader reader;
            JsonArray versions;
            String currentVersion = "3.1";
            URL url = new URL("https://api.modrinth.com/v2/project/qwertz-core/version");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            if (connection.getResponseCode() == 200 && (versions = JsonParser.parseReader((Reader)(reader = new InputStreamReader(connection.getInputStream()))).getAsJsonArray()).size() > 0) {
                JsonObject latestVersionObj = versions.get(0).getAsJsonObject();
                this.latestVersion = latestVersionObj.get("version_number").getAsString();
                this.downloadUrl = latestVersionObj.get("files").getAsJsonArray().get(0).getAsJsonObject().get("url").getAsString();
                if (this.isNewerVersion(this.latestVersion, currentVersion)) {
                    this.updateAvailable = true;
                    this.plugin.getLogger().info("A new version of QWERTZcore is available: " + this.latestVersion);
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to check for updates: " + e.getMessage());
        }
    }

    private boolean isNewerVersion(String latestVersion, String currentVersion) {
        String[] latest = latestVersion.split("\\.");
        String[] current = currentVersion.split("\\.");
        for (int i = 0; i < Math.min(latest.length, current.length); ++i) {
            int c;
            int l = Integer.parseInt(latest[i]);
            if (l > (c = Integer.parseInt(current[i]))) {
                return true;
            }
            if (l >= c) continue;
            return false;
        }
        return latest.length > current.length;
    }

    public void notifyPlayer(Player player) {
        if (this.updateAvailable) {
            player.sendMessage(QWERTZcore.CORE_ICON + "\u00a76 A new version of " + String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "QWERTZ Core \u00a76is available: " + String.valueOf(ChatColor.AQUA) + this.latestVersion);
            player.sendMessage(QWERTZcore.CORE_ICON + "\u00a76 Download it from: " + String.valueOf(ChatColor.AQUA) + String.valueOf(ChatColor.UNDERLINE) + "https://modrinth.com/plugin/qwertz-core/version/" + this.latestVersion);
        }
    }
}

