/*
 * Decompiled with CFR 0.152.
 */
package meldexun.nothirium.mc.renderer.chunk;

import java.util.function.Function;
import javax.annotation.Nullable;
import meldexun.nothirium.mc.util.LightUtil;
import meldexun.nothirium.mc.util.WorldUtil;
import meldexun.nothirium.util.SectionPos;
import meldexun.nothirium.util.cache.ArrayCache;
import meldexun.nothirium.util.cache.Cache2D;
import meldexun.nothirium.util.cache.Cache3D;
import meldexun.nothirium.util.cache.IntArrayCache;
import meldexun.nothirium.util.cache.IntCache3D;
import meldexun.nothirium.util.function.ObjInt2IntFunction;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class SectionRenderCache
implements IBlockAccess {
    private static final ArrayCache<IBlockState> BLOCK = new ArrayCache<Object>(5832, IBlockState[]::new, null);
    private static final IntArrayCache LIGHT = new IntArrayCache(5832, -1);
    private static final ArrayCache<Biome> BIOME = new ArrayCache<Object>(2304, Biome[]::new, null);
    protected final World world;
    protected final SectionPos sectionPos;
    protected final Cache2D<Chunk> chunkCache;
    protected final Cache3D<ExtendedBlockStorage> sectionCache;
    protected Cache3D<IBlockState> blockCache;
    protected IntCache3D lightCache;
    protected Cache2D<Biome> biomeCache;
    protected final Function<BlockPos, IBlockState> calculateBlockStateRef = this::calculateBlockState;
    protected int minBlockLight;
    protected final ObjInt2IntFunction<BlockPos> calculateCombinedLightRef = (pos, value) -> value == -1 ? this.calculateCombinedLight((BlockPos)pos, this.minBlockLight) : value;
    protected final Function<BlockPos, Biome> calculateBiomeRef = this::calculateBiome;

    public SectionRenderCache(World world, SectionPos sectionPos) {
        this.world = world;
        this.sectionPos = sectionPos;
        int minChunkX = sectionPos.getX() - 1;
        int minChunkY = sectionPos.getY() - 1;
        int minChunkZ = sectionPos.getZ() - 1;
        int maxChunkX = sectionPos.getX() + 1;
        int maxChunkY = sectionPos.getY() + 1;
        int maxChunkZ = sectionPos.getZ() + 1;
        this.chunkCache = new Cache2D<Object>(minChunkX, minChunkZ, maxChunkX, maxChunkZ, null, Chunk[]::new);
        this.sectionCache = new Cache3D<Object>(minChunkX, minChunkY, minChunkZ, maxChunkX, maxChunkY, maxChunkZ, null, ExtendedBlockStorage[]::new);
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                this.chunkCache.computeIfAbsent(x, z, (arg_0, arg_1) -> ((World)world).func_72964_e(arg_0, arg_1));
                for (int y = minChunkY; y <= maxChunkY; ++y) {
                    this.sectionCache.computeIfAbsent(x, y, z, WorldUtil::getSection);
                }
            }
        }
    }

    public void initCaches() {
        int minX = this.sectionPos.getBlockX();
        int minY = this.sectionPos.getBlockY();
        int minZ = this.sectionPos.getBlockZ();
        int maxX = this.sectionPos.getBlockX() + 15;
        int maxY = this.sectionPos.getBlockY() + 15;
        int maxZ = this.sectionPos.getBlockZ() + 15;
        this.blockCache = new Cache3D<IBlockState>(minX - 1, minY - 1, minZ - 1, maxX + 1, maxY + 1, maxZ + 1, Blocks.field_150350_a.func_176223_P(), BLOCK.get());
        this.lightCache = new IntCache3D(minX - 1, minY - 1, minZ - 1, maxX + 1, maxY + 1, maxZ + 1, 0, LIGHT.get());
        this.biomeCache = new Cache2D<Biome>(minX - 16, minZ - 16, maxX + 16, maxZ + 16, Biomes.field_76772_c, BIOME.get());
    }

    public void freeCaches() {
        BLOCK.free((IBlockState[])this.blockCache.getData());
        LIGHT.free(this.lightCache.getData());
        BIOME.free((Biome[])this.biomeCache.getData());
    }

    @Nullable
    private Chunk getChunk(BlockPos pos) {
        return this.chunkCache.get(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    @Nullable
    private ExtendedBlockStorage getSection(BlockPos pos) {
        return this.sectionCache.get(pos.func_177958_n() >> 4, pos.func_177956_o() >> 4, pos.func_177952_p() >> 4);
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        Chunk chunk = this.getChunk(pos);
        return chunk == null ? null : chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
    }

    public int func_175626_b(BlockPos pos, int minBlockLight) {
        this.minBlockLight = minBlockLight;
        return this.lightCache.compute(pos, this.calculateCombinedLightRef);
    }

    private int calculateCombinedLight(BlockPos pos, int minBlockLight) {
        int light = LightUtil.pack(0, minBlockLight);
        IBlockState state = this.func_180495_p(pos);
        if (state.func_185916_f()) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            light = this.getLight((BlockPos)mutable.func_181079_c(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p()), light);
            light = this.getLight((BlockPos)mutable.func_181079_c(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()), light);
            light = this.getLight((BlockPos)mutable.func_181079_c(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1), light);
            light = this.getLight((BlockPos)mutable.func_181079_c(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1), light);
            light = this.getLight((BlockPos)mutable.func_181079_c(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p()), light);
            light = this.getLight((BlockPos)mutable.func_181079_c(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p()), light);
        } else {
            light = this.getLight(pos, light);
        }
        return light;
    }

    private int getLight(BlockPos pos, int skyBlock) {
        return this.getLight(pos, LightUtil.sky(skyBlock), LightUtil.block(skyBlock));
    }

    private int getLight(BlockPos pos, int sky, int block) {
        Chunk chunk;
        ExtendedBlockStorage section = this.getSection(pos);
        if (section != null) {
            if (this.world.field_73011_w.func_191066_m() && sky < 15) {
                sky = Math.max(sky, LightUtil.getSkyLight(section, pos));
            }
            if (block < 15) {
                block = Math.max(block, LightUtil.getBlockLight(section, pos));
            }
        } else if (this.world.field_73011_w.func_191066_m() && sky < EnumSkyBlock.SKY.field_77198_c && (chunk = this.getChunk(pos)) != null && chunk.func_177444_d(pos)) {
            sky = EnumSkyBlock.SKY.field_77198_c;
        }
        return LightUtil.pack(sky, block);
    }

    public IBlockState func_180495_p(BlockPos pos) {
        return this.blockCache.computeIfAbsent(pos, this.calculateBlockStateRef);
    }

    private IBlockState calculateBlockState(BlockPos pos) {
        ExtendedBlockStorage section = this.getSection(pos);
        return section == null ? Blocks.field_150350_a.func_176223_P() : section.func_177485_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF);
    }

    public boolean func_175623_d(BlockPos pos) {
        IBlockState state = this.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)this, pos);
    }

    public Biome func_180494_b(BlockPos pos) {
        return this.biomeCache.computeIfAbsent(pos, this.calculateBiomeRef);
    }

    private Biome calculateBiome(BlockPos pos) {
        Chunk chunk = this.getChunk(pos);
        return chunk == null ? Biomes.field_76772_c : chunk.func_177411_a(pos, this.getWorld().func_72959_q());
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        return this.func_180495_p(pos).func_185893_b((IBlockAccess)this, pos, direction);
    }

    public WorldType func_175624_G() {
        return this.world.func_175624_G();
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        if (!this.blockCache.inBounds(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) {
            return _default;
        }
        return this.func_180495_p(pos).isSideSolid((IBlockAccess)this, pos, side);
    }

    public World getWorld() {
        return this.world;
    }
}

