/*
 * Decompiled with CFR 0.152.
 */
package meldexun.nothirium.mc.vertex;

import java.nio.ByteOrder;
import meldexun.memoryutil.UnsafeUtil;
import meldexun.nothirium.mc.vertex.ExtendedBufferBuilder;
import meldexun.nothirium.mc.vertex.VertexConsumer;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import sun.misc.Unsafe;

public class ColorUploader {
    private static final VertexConsumer FLOAT = new VertexConsumer(){

        @Override
        public void color(ExtendedBufferBuilder buffer, int red, int green, int blue, int alpha) {
            Unsafe unsafe = UnsafeUtil.UNSAFE;
            long address = buffer.getAddress() + (long)buffer.getOffset();
            unsafe.putFloat(address, (float)red / 255.0f);
            unsafe.putFloat(address + 4L, (float)green / 255.0f);
            unsafe.putFloat(address + 8L, (float)blue / 255.0f);
            unsafe.putFloat(address + 12L, (float)alpha / 255.0f);
        }
    };
    private static final VertexConsumer INT = new VertexConsumer(){

        @Override
        public void color(ExtendedBufferBuilder buffer, int red, int green, int blue, int alpha) {
            Unsafe unsafe = UnsafeUtil.UNSAFE;
            long address = buffer.getAddress() + (long)buffer.getOffset();
            unsafe.putFloat(address, red);
            unsafe.putFloat(address + 4L, green);
            unsafe.putFloat(address + 8L, blue);
            unsafe.putFloat(address + 12L, alpha);
        }
    };
    private static final VertexConsumer SHORT = new VertexConsumer(){

        @Override
        public void color(ExtendedBufferBuilder buffer, int red, int green, int blue, int alpha) {
            Unsafe unsafe = UnsafeUtil.UNSAFE;
            long address = buffer.getAddress() + (long)buffer.getOffset();
            unsafe.putShort(address, (short)red);
            unsafe.putShort(address + 2L, (short)green);
            unsafe.putShort(address + 4L, (short)blue);
            unsafe.putShort(address + 6L, (short)alpha);
        }
    };
    private static final VertexConsumer BYTE = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? new VertexConsumer(){

        @Override
        public void color(ExtendedBufferBuilder buffer, int red, int green, int blue, int alpha) {
            Unsafe unsafe = UnsafeUtil.UNSAFE;
            long address = buffer.getAddress() + (long)buffer.getOffset();
            unsafe.putByte(address, (byte)red);
            unsafe.putByte(address + 1L, (byte)green);
            unsafe.putByte(address + 2L, (byte)blue);
            unsafe.putByte(address + 3L, (byte)alpha);
        }
    } : new VertexConsumer(){

        @Override
        public void color(ExtendedBufferBuilder buffer, int red, int green, int blue, int alpha) {
            Unsafe unsafe = UnsafeUtil.UNSAFE;
            long address = buffer.getAddress() + (long)buffer.getOffset();
            unsafe.putByte(address, (byte)alpha);
            unsafe.putByte(address + 1L, (byte)blue);
            unsafe.putByte(address + 2L, (byte)green);
            unsafe.putByte(address + 3L, (byte)red);
        }
    };

    public static VertexConsumer fromType(VertexFormatElement.EnumType type) {
        switch (type) {
            case FLOAT: {
                return FLOAT;
            }
            case UINT: 
            case INT: {
                return INT;
            }
            case USHORT: 
            case SHORT: {
                return SHORT;
            }
            case UBYTE: 
            case BYTE: {
                return BYTE;
            }
        }
        return null;
    }
}

