/*
 * Decompiled with CFR 0.152.
 */
package meldexun.nothirium.renderer.chunk;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import meldexun.nothirium.api.renderer.chunk.ChunkRenderPass;
import meldexun.nothirium.api.renderer.chunk.IChunkRenderer;
import meldexun.nothirium.api.renderer.chunk.IRenderChunkDispatcher;
import meldexun.nothirium.api.renderer.chunk.IRenderChunkProvider;
import meldexun.nothirium.mc.renderer.ChunkRenderManager;
import meldexun.nothirium.mc.util.FogUtil;
import meldexun.nothirium.renderer.chunk.AbstractRenderChunk;
import meldexun.nothirium.util.Direction;
import meldexun.nothirium.util.collection.Enum2ObjMap;
import meldexun.nothirium.util.math.MathUtil;
import meldexun.renderlib.util.Frustum;

public abstract class AbstractChunkRenderer<T extends AbstractRenderChunk>
implements IChunkRenderer<T> {
    private final Queue<T> chunkQueue = new ArrayDeque<T>();
    private double lastTransparencyResortX;
    private double lastTransparencyResortY;
    private double lastTransparencyResortZ;
    private int renderedChunks;
    protected final Enum2ObjMap<ChunkRenderPass, List<T>> chunks = new Enum2ObjMap<ChunkRenderPass, List>(ChunkRenderPass.class, ArrayList::new);

    protected AbstractChunkRenderer() {
    }

    @Override
    public int renderedChunks() {
        return this.renderedChunks;
    }

    @Override
    public int renderedChunks(ChunkRenderPass pass) {
        return this.chunks.get(pass).size();
    }

    @Override
    public void setup(IRenderChunkProvider<T> renderChunkProvider, double cameraX, double cameraY, double cameraZ, Frustum frustum, int frame) {
        AbstractRenderChunk renderChunk;
        this.resortTransparency(cameraX, cameraY, cameraZ, frustum);
        int chunkX = MathUtil.floor(cameraX) >> 4;
        int chunkY = MathUtil.floor(cameraY) >> 4;
        int chunkZ = MathUtil.floor(cameraZ) >> 4;
        this.renderedChunks = 0;
        this.chunks.forEach(List::clear);
        AbstractRenderChunk rootRenderChunk = (AbstractRenderChunk)renderChunkProvider.getRenderChunkAt(chunkX, chunkY, chunkZ);
        rootRenderChunk.visibleDirections = 63;
        this.chunkQueue.add(rootRenderChunk);
        double fogEndSqr = FogUtil.calculateFogEndSqr();
        boolean spectator = this.isSpectator();
        while ((renderChunk = (AbstractRenderChunk)this.chunkQueue.poll()) != null) {
            renderChunk.lastTimeRecorded = frame;
            renderChunk.compileAsync(this, (IRenderChunkDispatcher)ChunkRenderManager.getTaskDispatcher());
            this.addToRenderLists(renderChunk);
            for (Direction direction : Direction.ALL) {
                AbstractRenderChunk neighbor = renderChunkProvider.getNeighbor(renderChunk, direction);
                if (neighbor == null || neighbor.lastTimeRecorded == frame || direction.opposite().isFaceCulled(neighbor, cameraX, cameraY, cameraZ) || !spectator && !renderChunk.isVisibleFromAnyOrigin(direction)) continue;
                if (neighbor.lastTimeEnqueued != frame) {
                    neighbor.lastTimeEnqueued = frame;
                    if (neighbor.isFogCulled(cameraX, cameraY, cameraZ, fogEndSqr) || neighbor.isFrustumCulled(frustum)) {
                        neighbor.lastTimeRecorded = frame;
                        continue;
                    }
                    neighbor.resetOrigins();
                    this.chunkQueue.add(neighbor);
                }
                neighbor.setOrigin(direction.opposite());
            }
        }
    }

    private void resortTransparency(double cameraX, double cameraY, double cameraZ, Frustum frustum) {
        double dx = cameraX - this.lastTransparencyResortX;
        double dy = cameraY - this.lastTransparencyResortY;
        double dz = cameraZ - this.lastTransparencyResortZ;
        if (dx * dx + dy * dy + dz * dz > 1.0) {
            this.lastTransparencyResortX = cameraX;
            this.lastTransparencyResortY = cameraY;
            this.lastTransparencyResortZ = cameraZ;
            Object provider = ChunkRenderManager.getProvider();
            Object taskDispatcher = ChunkRenderManager.getTaskDispatcher();
            int chunkX = MathUtil.floor(cameraX) >> 4;
            int chunkY = MathUtil.floor(cameraY) >> 4;
            int chunkZ = MathUtil.floor(cameraZ) >> 4;
            int r = 2;
            for (int x = -r; x <= r; ++x) {
                for (int y = -r; y <= r; ++y) {
                    for (int z = -r; z <= r; ++z) {
                        AbstractRenderChunk renderChunk = (AbstractRenderChunk)provider.getRenderChunkAt(chunkX + x, chunkY + y, chunkZ + z);
                        if (renderChunk == null || renderChunk.isFrustumCulled(frustum)) continue;
                        renderChunk.resortTransparency(this, (IRenderChunkDispatcher)taskDispatcher);
                    }
                }
            }
        }
    }

    private void addToRenderLists(T renderChunk) {
        if (((AbstractRenderChunk)renderChunk).isEmpty()) {
            return;
        }
        ++this.renderedChunks;
        this.chunks.forEach((pass, list) -> {
            if (renderChunk.getVBOPart((ChunkRenderPass)((Object)pass)) != null) {
                list.add(renderChunk);
            }
        });
    }

    protected abstract boolean isSpectator();
}

