/*
 * Decompiled with CFR 0.152.
 */
package meldexun.nothirium.util;

import meldexun.nothirium.api.renderer.chunk.IRenderChunk;
import meldexun.nothirium.util.Axis;

public enum Direction {
    DOWN(0, Axis.Y, 0, -1, 0){

        @Override
        public boolean isFaceCulled(IRenderChunk renderChunk, double cameraX, double cameraY, double cameraZ) {
            if (renderChunk.getSectionY() >= 16) {
                return true;
            }
            return cameraY > (double)renderChunk.getY();
        }
    }
    ,
    UP(1, Axis.Y, 0, 1, 0){

        @Override
        public boolean isFaceCulled(IRenderChunk renderChunk, double cameraX, double cameraY, double cameraZ) {
            if (renderChunk.getSectionY() < 0) {
                return true;
            }
            return cameraY < (double)(renderChunk.getY() + 16);
        }
    }
    ,
    NORTH(2, Axis.Z, 0, 0, -1){

        @Override
        public boolean isFaceCulled(IRenderChunk renderChunk, double cameraX, double cameraY, double cameraZ) {
            return cameraZ > (double)renderChunk.getZ();
        }
    }
    ,
    SOUTH(3, Axis.Z, 0, 0, 1){

        @Override
        public boolean isFaceCulled(IRenderChunk renderChunk, double cameraX, double cameraY, double cameraZ) {
            return cameraZ < (double)(renderChunk.getZ() + 16);
        }
    }
    ,
    WEST(4, Axis.X, -1, 0, 0){

        @Override
        public boolean isFaceCulled(IRenderChunk renderChunk, double cameraX, double cameraY, double cameraZ) {
            return cameraX > (double)renderChunk.getX();
        }
    }
    ,
    EAST(5, Axis.X, 1, 0, 0){

        @Override
        public boolean isFaceCulled(IRenderChunk renderChunk, double cameraX, double cameraY, double cameraZ) {
            return cameraX < (double)(renderChunk.getX() + 16);
        }
    };

    public static final Direction[] ALL;
    public static final Direction[] HORIZONTAL;
    public static final Direction[] VERTICAL;
    private final int index;
    private final Axis axis;
    private Direction opposite;
    private final int x;
    private final int y;
    private final int z;

    private Direction(int index, Axis axis, int x, int y, int z) {
        this.index = index;
        this.axis = axis;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int getIndex() {
        return this.index;
    }

    public Direction opposite() {
        return this.opposite;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public static Direction get(int index) {
        return ALL[index];
    }

    public static Direction get(float x, float y, float z) {
        float x1 = Math.abs(x);
        float y1 = Math.abs(y);
        float z1 = Math.abs(z);
        if (x1 >= y1 && x1 >= z1) {
            return x < 0.0f ? WEST : EAST;
        }
        if (y1 >= z1) {
            return y < 0.0f ? DOWN : UP;
        }
        return z < 0.0f ? NORTH : SOUTH;
    }

    public abstract boolean isFaceCulled(IRenderChunk var1, double var2, double var4, double var6);

    static {
        Direction.WEST.opposite = EAST;
        Direction.EAST.opposite = WEST;
        Direction.DOWN.opposite = UP;
        Direction.UP.opposite = DOWN;
        Direction.NORTH.opposite = SOUTH;
        Direction.SOUTH.opposite = NORTH;
        Axis.X.positive = EAST;
        Axis.X.negative = WEST;
        Axis.Y.positive = UP;
        Axis.Y.negative = DOWN;
        Axis.Z.positive = SOUTH;
        Axis.Z.negative = NORTH;
        ALL = Direction.values();
        HORIZONTAL = new Direction[]{NORTH, SOUTH, WEST, EAST};
        VERTICAL = new Direction[]{DOWN, UP};
    }
}

