/*
 * Decompiled with CFR 0.152.
 */
package meldexun.nothirium.util;

import it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectSortedMap;
import java.util.function.Consumer;
import meldexun.nothirium.util.SectorizedList;
import meldexun.reflectionutil.ReflectionField;
import meldexun.reflectionutil.ReflectionMethod;

public interface FreeSectorManager {
    public int largestSector();

    public SectorizedList.Sector get(int var1);

    public void add(SectorizedList.Sector var1);

    public void remove(SectorizedList.Sector var1);

    default public void siftUp(SectorizedList.Sector sector, Consumer<SectorizedList.Sector> c) {
        this.remove(sector);
        c.accept(sector);
        this.add(sector);
    }

    default public void siftDown(SectorizedList.Sector sector, Consumer<SectorizedList.Sector> c) {
        this.remove(sector);
        c.accept(sector);
        this.add(sector);
    }

    public static class RB
    extends Map<Object2ObjectRBTreeMap<SectorizedList.Sector, SectorizedList.Sector>> {
        private static final ReflectionField<?> TREE = new ReflectionField(Object2ObjectRBTreeMap.class, "tree", "tree");
        private static final ReflectionMethod<?> LEFT = new ReflectionMethod(Object2ObjectRBTreeMap.class.getName() + "$Entry", "left", "left", new Class[0]);
        private static final ReflectionMethod<?> RIGHT = new ReflectionMethod(Object2ObjectRBTreeMap.class.getName() + "$Entry", "right", "right", new Class[0]);

        public RB() {
            super(new Object2ObjectRBTreeMap());
        }

        @Override
        public SectorizedList.Sector get(int minSectorSize) {
            if (this.largestSector() < minSectorSize) {
                return null;
            }
            SectorizedList.Sector q = null;
            Object p = TREE.get((Object)this.map);
            while (p != null) {
                SectorizedList.Sector s = (SectorizedList.Sector)((Object2ObjectMap.Entry)p).getKey();
                if (s.getSectorCount() < minSectorSize) {
                    p = RIGHT.invoke(p, new Object[0]);
                    continue;
                }
                if (s.getSectorCount() > minSectorSize) {
                    q = s;
                    p = LEFT.invoke(p, new Object[0]);
                    continue;
                }
                return s;
            }
            return q;
        }
    }

    public static class AVL
    extends Map<Object2ObjectAVLTreeMap<SectorizedList.Sector, SectorizedList.Sector>> {
        private static final ReflectionField<?> TREE = new ReflectionField(Object2ObjectAVLTreeMap.class, "tree", "tree");
        private static final ReflectionMethod<?> LEFT = new ReflectionMethod(Object2ObjectAVLTreeMap.class.getName() + "$Entry", "left", "left", new Class[0]);
        private static final ReflectionMethod<?> RIGHT = new ReflectionMethod(Object2ObjectAVLTreeMap.class.getName() + "$Entry", "right", "right", new Class[0]);

        public AVL(Object2ObjectAVLTreeMap<SectorizedList.Sector, SectorizedList.Sector> map) {
            super(map);
        }

        @Override
        public SectorizedList.Sector get(int minSectorSize) {
            if (this.largestSector() < minSectorSize) {
                return null;
            }
            SectorizedList.Sector q = null;
            Object p = TREE.get((Object)this.map);
            while (p != null) {
                SectorizedList.Sector s = (SectorizedList.Sector)((Object2ObjectMap.Entry)p).getKey();
                if (s.getSectorCount() < minSectorSize) {
                    p = RIGHT.invoke(p, new Object[0]);
                    continue;
                }
                if (s.getSectorCount() > minSectorSize) {
                    q = s;
                    p = LEFT.invoke(p, new Object[0]);
                    continue;
                }
                return s;
            }
            return q;
        }
    }

    public static abstract class Map<T extends Object2ObjectSortedMap<SectorizedList.Sector, SectorizedList.Sector>>
    implements FreeSectorManager {
        protected final T map;

        public Map(T map) {
            this.map = map;
        }

        @Override
        public void add(SectorizedList.Sector sector) {
            this.map.put((Object)sector, (Object)sector);
        }

        @Override
        public int largestSector() {
            return this.map.isEmpty() ? 0 : ((SectorizedList.Sector)this.map.lastKey()).getSectorCount();
        }

        @Override
        public void remove(SectorizedList.Sector sector) {
            this.map.remove((Object)sector);
        }
    }
}

