/*
 * Decompiled with CFR 0.152.
 */
package meldexun.nothirium.util.collection;

import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import meldexun.nothirium.util.collection.IMultiObject;
import meldexun.nothirium.util.function.IntObjConsumer;

public class MultiObject<T>
implements IMultiObject<T> {
    protected final int size;
    protected final Object[] values;
    protected int index;
    private T value;

    public MultiObject(int size) {
        this.size = size;
        this.values = new Object[size];
    }

    public MultiObject(int size, IntFunction<T> mapper) {
        this(size);
        this.fill(mapper);
    }

    public MultiObject(int size, Supplier<T> mapper) {
        this(size);
        this.fill(mapper);
    }

    @Override
    public void update() {
        this.index = (this.index + 1) % this.size;
        this.value = this.values[this.index];
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public T get(int index) {
        return (T)this.values[index];
    }

    @Override
    public void set(T t) {
        this.values[this.index] = t;
        this.value = t;
    }

    @Override
    public void set(int index, T t) {
        this.values[index] = t;
        if (index == this.index) {
            this.value = t;
        }
    }

    @Override
    public Stream<T> stream() {
        return StreamSupport.stream(Spliterators.spliterator(this.values, 1040), false);
    }

    @Override
    public void forEach(IntObjConsumer<T> action) {
        for (int i = 0; i < this.values.length; ++i) {
            action.accept(i, this.values[i]);
        }
    }

    @Override
    public void forEach(Consumer<T> action) {
        for (Object t : this.values) {
            action.accept(t);
        }
    }

    @Override
    public void fill(IntFunction<T> mapper) {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = mapper.apply(i);
        }
    }

    @Override
    public void fill(Supplier<T> mapper) {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = mapper.get();
        }
    }
}

