/*
 * Decompiled with CFR 0.152.
 */
package com.simple_tools.datas;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class stWorldJson {
    public static void run(MinecraftServer server, class_3218 world) {
        try {
            String path = stWorldJson.get_path(world);
            stSettings loader = stWorldJson.read(path);
            if (!loader.settings_created) {
                loader.block_placer_max_diameter = 15;
                loader.block_placer_min_diameter = 3;
                loader.block_searcher_max_diameter = 15;
                loader.block_searcher_min_diameter = 3;
                loader.block_searcher_show_position = false;
                loader.slime_block_placer_max_diameter = 5;
                loader.slime_block_placer_min_diameter = 1;
                loader.nether_portal_frame_generator_max_height = 23;
                loader.nether_portal_frame_generator_min_height = 5;
                loader.nether_portal_frame_generator_max_width = 23;
                loader.nether_portal_frame_generator_min_width = 4;
                loader.player_stealer_enabled = true;
                loader.settings_created = true;
                stWorldJson.save(loader, path);
            }
        }
        catch (IllegalStateException e) {
            stWorldJson.delete(world);
            stWorldJson.run(server, world);
        }
    }

    public static void save(stSettings obj, String file_name) {
        try (FileWriter writer = new FileWriter(file_name);){
            new Gson().toJson((Object)obj, (Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static stSettings read(String file_name) {
        stSettings stSettings2;
        File file = new File(file_name);
        if (!file.exists()) {
            stSettings defaults = new stSettings();
            defaults.block_placer_max_diameter = 15;
            defaults.settings_created = false;
            return defaults;
        }
        FileReader reader = new FileReader(file_name);
        try {
            stSettings2 = (stSettings)new Gson().fromJson((Reader)reader, stSettings.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        reader.close();
        return stSettings2;
    }

    public static String get_path(class_3218 world) {
        Path worldPath = world.method_8503().method_27050(class_5218.field_24188);
        return worldPath.resolve("st_settings.json").toString();
    }

    public static boolean delete(class_3218 world) {
        try {
            Path path = Path.of(stWorldJson.get_path(world), new String[0]);
            return Files.deleteIfExists(path);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static class stSettings {
        public int block_placer_max_diameter;
        public int block_placer_min_diameter;
        public int block_searcher_max_diameter;
        public int block_searcher_min_diameter;
        public boolean block_searcher_show_position;
        public int slime_block_placer_max_diameter;
        public int slime_block_placer_min_diameter;
        public int nether_portal_frame_generator_max_height;
        public int nether_portal_frame_generator_min_height;
        public int nether_portal_frame_generator_max_width;
        public int nether_portal_frame_generator_min_width;
        public boolean player_stealer_enabled;
        public boolean settings_created;
    }
}

