/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.mekae2.data;

import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.ItemDefinition;
import appeng.recipes.game.StorageCellDisassemblyRecipe;
import appeng.recipes.game.StorageCellUpgradeRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import me.ramidzkh.mekae2.AMItems;
import me.ramidzkh.mekae2.AppliedMekanistics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredItem;

public class RecipeProvider
extends net.minecraft.data.recipes.RecipeProvider {
    public RecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(output, lookupProvider);
    }

    protected void buildRecipes(RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, () -> AMItems.CHEMICAL_CELL_HOUSING.get()).pattern("QRQ").pattern("R R").pattern("OOO").define(Character.valueOf('Q'), (ItemLike)AEBlocks.QUARTZ_GLASS).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('O'), ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ingots/osmium"))).unlockedBy("has_dusts/redstone", RecipeProvider.has((TagKey)Tags.Items.DUSTS_REDSTONE)).save(output, AppliedMekanistics.id("chemical_cell_housing"));
        Item housing = (Item)AMItems.CHEMICAL_CELL_HOUSING.get();
        for (AMItems.Tier tier : AMItems.Tier.values()) {
            ItemDefinition cellComponent = switch (tier) {
                default -> throw new MatchException(null, null);
                case AMItems.Tier._1K -> AEItems.CELL_COMPONENT_1K;
                case AMItems.Tier._4K -> AEItems.CELL_COMPONENT_4K;
                case AMItems.Tier._16K -> AEItems.CELL_COMPONENT_16K;
                case AMItems.Tier._64K -> AEItems.CELL_COMPONENT_64K;
                case AMItems.Tier._256K -> AEItems.CELL_COMPONENT_256K;
            };
            String tierName = tier.toString().toLowerCase(Locale.ROOT);
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, () -> AMItems.get(tier).get()).requires((ItemLike)housing).requires((ItemLike)cellComponent).unlockedBy("has_cell_component" + tierName, RecipeProvider.has((ItemLike)cellComponent)).unlockedBy("has_chemical_housing", RecipeProvider.has((ItemLike)housing)).save(output);
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, () -> AMItems.getPortableCell(tier).get()).requires((ItemLike)AEBlocks.ME_CHEST).requires((ItemLike)cellComponent).requires((ItemLike)AEBlocks.ENERGY_CELL).requires((ItemLike)housing).unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)housing).getPath(), RecipeProvider.has((ItemLike)housing)).unlockedBy("has_energy_cell", RecipeProvider.has((ItemLike)AEBlocks.ENERGY_CELL)).save(output);
        }
        this.storageCellUpgradeRecipes(output, List.of(new CellUpgradeTier("1k", AMItems.CHEMICAL_CELL_1K, (ItemLike)AEItems.CELL_COMPONENT_1K), new CellUpgradeTier("4k", AMItems.CHEMICAL_CELL_4K, (ItemLike)AEItems.CELL_COMPONENT_4K), new CellUpgradeTier("16k", AMItems.CHEMICAL_CELL_16K, (ItemLike)AEItems.CELL_COMPONENT_16K), new CellUpgradeTier("64k", AMItems.CHEMICAL_CELL_64K, (ItemLike)AEItems.CELL_COMPONENT_64K), new CellUpgradeTier("256k", AMItems.CHEMICAL_CELL_256K, (ItemLike)AEItems.CELL_COMPONENT_256K)), List.of(AMItems.CHEMICAL_CELL_HOUSING));
        this.storageCellUpgradeRecipes(output, List.of(new CellUpgradeTier("1k", AMItems.PORTABLE_CHEMICAL_CELL_1K, (ItemLike)AEItems.CELL_COMPONENT_1K), new CellUpgradeTier("4k", AMItems.PORTABLE_CHEMICAL_CELL_4K, (ItemLike)AEItems.CELL_COMPONENT_4K), new CellUpgradeTier("16k", AMItems.PORTABLE_CHEMICAL_CELL_16K, (ItemLike)AEItems.CELL_COMPONENT_16K), new CellUpgradeTier("64k", AMItems.PORTABLE_CHEMICAL_CELL_64K, (ItemLike)AEItems.CELL_COMPONENT_64K), new CellUpgradeTier("256k", AMItems.PORTABLE_CHEMICAL_CELL_256K, (ItemLike)AEItems.CELL_COMPONENT_256K)), List.of(AEBlocks.ME_CHEST, AEBlocks.ENERGY_CELL, AMItems.CHEMICAL_CELL_HOUSING));
    }

    private void storageCellUpgradeRecipes(RecipeOutput output, List<CellUpgradeTier> tiers, List<ItemLike> additionalDisassemblyItems) {
        for (int i = 0; i < tiers.size(); ++i) {
            CellUpgradeTier fromTier = tiers.get(i);
            Item inputCell = fromTier.cell().asItem();
            ResourceLocation inputId = fromTier.cell().getId();
            Item resultComponent = fromTier.component().asItem();
            this.cellDisassembly(output, additionalDisassemblyItems, fromTier);
            for (int j = i + 1; j < tiers.size(); ++j) {
                CellUpgradeTier toTier = tiers.get(j);
                Item resultCell = toTier.cell().asItem();
                Item inputComponent = toTier.component().asItem();
                ResourceLocation recipeId = inputId.withPath(path -> "upgrade/" + path + "_to_" + toTier.suffix);
                output.accept(recipeId, (Recipe)new StorageCellUpgradeRecipe(inputCell, inputComponent, resultCell, resultComponent), null);
            }
        }
    }

    private void cellDisassembly(RecipeOutput consumer, List<ItemLike> additionalReturn, CellUpgradeTier tier) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        for (ItemLike itemLike : additionalReturn) {
            results.add(itemLike.asItem().getDefaultInstance());
        }
        results.add(tier.component.asItem().getDefaultInstance());
        consumer.accept(tier.cell.getId().withPrefix("cell_upgrade/"), (Recipe)new StorageCellDisassemblyRecipe(tier.cell.asItem(), results), null);
    }

    record CellUpgradeTier(String suffix, DeferredItem<Item> cell, ItemLike component) {
    }
}

