/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.visualizingFeatures;

import carpet.CarpetServer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import mypals.ml.features.visualizingFeatures.AbstractVisualizingManager;
import mypals.ml.features.visualizingFeatures.EntityHelper;
import mypals.ml.utils.adapter.NBTDataManager;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_268;
import net.minecraft.class_2680;
import net.minecraft.class_2995;
import net.minecraft.class_3218;
import net.minecraft.class_8113;

public class RandomTickVisualizing
extends AbstractVisualizingManager<class_2338, class_8113.class_8115> {
    public static ConcurrentHashMap<class_2338, Map.Entry<class_8113.class_8115, Long>> visualizers = new ConcurrentHashMap();
    public static int SURVIVE_TIME = 20;
    public static int RANGE = 20;

    public void setVisualizer(class_1937 world, class_2338 pos) {
        boolean playersNearBy = false;
        for (class_1657 player : CarpetServer.minecraft_server.method_3760().field_14351) {
            if (!(player.method_19538().method_1022(pos.method_46558()) < (double)RANGE)) continue;
            playersNearBy = true;
            break;
        }
        if (!playersNearBy) {
            return;
        }
        this.setVisualizer((class_3218)world, pos, pos.method_46558(), null);
    }

    private static void addMarkerToTeam(class_3218 world, String teamName, class_8113.class_8115 marker) {
        class_2995 scoreboard = world.method_14170();
        class_268 team = scoreboard.method_1153(teamName);
        if (team == null) {
            team = scoreboard.method_1171(teamName);
            team.method_1141(class_124.field_1061);
        }
        String entityName = marker.method_5845();
        scoreboard.method_1172(entityName, team);
    }

    @Override
    public void updateVisualizer() {
        if (!CarpetServer.minecraft_server.method_54833().method_54751()) {
            return;
        }
        visualizers.forEach((pos, entry) -> {
            class_8113.class_8115 object = (class_8113.class_8115)entry.getKey();
            long time = (Long)entry.getValue();
            if (time < object.method_37908().method_8510()) {
                this.removeVisualizer(pos);
                visualizers.remove(pos);
            }
            class_2487 nbt = NBTDataManager.readFromEntity((class_1297)entry.getKey(), new class_2487());
            float scale = EntityHelper.mapSize((int)(time - CarpetServer.minecraft_server.method_30002().method_8510()), SURVIVE_TIME, 0.9f);
            nbt = EntityHelper.scaleEntity(nbt, scale);
            NBTDataManager.writeToEntity((class_1297)entry.getKey(), nbt);
            ((class_8113.class_8115)entry.getKey()).method_23327(pos.method_46558().method_10216() - (double)(scale / 2.0f), pos.method_46558().method_10214() - (double)(scale / 2.0f), pos.method_46558().method_10215() - (double)(scale / 2.0f));
        });
    }

    @Override
    protected void storeVisualizer(class_2338 key, class_8113.class_8115 entity) {
        visualizers.put(key, Map.entry(entity, RandomTickVisualizing.getDeleteTick(SURVIVE_TIME, (class_3218)entity.method_37908())));
    }

    @Override
    protected void updateVisualizerEntity(class_8113.class_8115 marker, Object data) {
        class_2487 nbt = NBTDataManager.readFromEntity((class_1297)marker, new class_2487());
        float scale = 0.9f;
        nbt = EntityHelper.scaleEntity(nbt, scale);
        NBTDataManager.writeToEntity((class_1297)marker, nbt);
        class_2338 blockPos = class_2338.method_49638((class_2374)marker.method_19538());
        marker.method_23327(blockPos.method_46558().method_10216() - (double)(scale / 2.0f), blockPos.method_46558().method_10214() - (double)(scale / 2.0f), blockPos.method_46558().method_10215() - (double)(scale / 2.0f));
        marker.field_6012 = 0;
    }

    @Override
    protected class_8113.class_8115 createVisualizerEntity(class_3218 world, class_243 pos, Object data) {
        class_8113.class_8115 entity = new class_8113.class_8115(class_1299.field_42460, (class_1937)world);
        entity.method_5875(true);
        class_2487 nbt = NBTDataManager.readFromEntity((class_1297)entity, new class_2487());
        nbt.method_10566("block_state", (class_2520)class_2512.method_10686((class_2680)class_2246.field_10272.method_9564()));
        float scale = 0.9f;
        nbt = EntityHelper.scaleEntity(nbt, scale);
        nbt.method_10569("glow_color_override", 0xFFAAAA);
        NBTDataManager.writeToEntity((class_1297)entity, nbt);
        entity.method_5648(true);
        entity.method_5684(true);
        entity.method_5834(true);
        entity.field_5960 = true;
        entity.method_36456(0.0f);
        entity.method_23327(pos.method_10216() - (double)(scale / 2.0f), pos.method_10214() - (double)(scale / 2.0f), pos.method_10215() - (double)(scale / 2.0f));
        entity.method_5780(this.getVisualizerTag());
        entity.method_5780("DoNotTick");
        if (!world.method_8608()) {
            RandomTickVisualizing.addMarkerToTeam(world, "randomTickVisualizerTeam", entity);
        }
        world.method_8649((class_1297)entity);
        return entity;
    }

    @Override
    protected void removeVisualizerEntity(class_2338 key) {
        Map.Entry<class_8113.class_8115, Long> entry = visualizers.get(key);
        if (entry != null) {
            entry.getKey().method_31472();
            visualizers.remove(key);
        }
    }

    @Override
    protected void clearAllVisualizers() {
        visualizers.clear();
    }

    @Override
    protected class_8113.class_8115 getVisualizer(class_2338 key) {
        return visualizers.get(key) == null ? null : visualizers.get(key).getKey();
    }

    @Override
    public String getVisualizerTag() {
        return "randomTickVisualize";
    }
}

