/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import carpet.CarpetSettings;
import carpet.api.settings.CarpetRule;
import carpet.logging.LoggerRegistry;
import carpet.patches.EntityPlayerMPFake;
import com.mojang.brigadier.CommandDispatcher;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import mypals.ml.commands.YetAnotherCarpetAdditionCommands;
import mypals.ml.features.fakePlayerControl.FakePlayerControlManager;
import mypals.ml.features.hopperCounterDataCollector.HopperCounterDataManager;
import mypals.ml.features.log2Chat.LogAppender;
import mypals.ml.features.selectiveFreeze.SelectiveFreezeManager;
import mypals.ml.features.subscribeRules.RuleSubscribeManager;
import mypals.ml.features.tickStepCounter.StepManager;
import mypals.ml.features.visualizingFeatures.AbstractVisualizingManager;
import mypals.ml.features.visualizingFeatures.BlockEntityOrderVisualizing;
import mypals.ml.features.visualizingFeatures.BlockEventVisualizing;
import mypals.ml.features.visualizingFeatures.BlockUpdateVisualizing;
import mypals.ml.features.visualizingFeatures.FoliageAttachmentVisualizing;
import mypals.ml.features.visualizingFeatures.GameEventVisualizing;
import mypals.ml.features.visualizingFeatures.HopperCooldownVisualizing;
import mypals.ml.features.visualizingFeatures.MobAIVisualizer;
import mypals.ml.features.visualizingFeatures.POIVisualizing;
import mypals.ml.features.visualizingFeatures.RandomTickVisualizing;
import mypals.ml.features.visualizingFeatures.ScheduledTickVisualizing;
import mypals.ml.features.visualizingFeatures.TreeGrowthObstacleVisualzing;
import mypals.ml.features.waypoint.WaypointManager;
import mypals.ml.network.OptionalFreezePayload;
import mypals.ml.network.RuleData;
import mypals.ml.network.client.RequestCountersPayload;
import mypals.ml.network.client.RequestRulesPayload;
import mypals.ml.network.server.CountersPacketPayload;
import mypals.ml.network.server.RulesPacketPayload;
import mypals.ml.settings.YetAnotherCarpetAdditionRules;
import mypals.ml.translations.YACALanguageUtil;
import mypals.ml.translations.YetAnotherCarpetAdditionTranslations;
import mypals.ml.utils.POIManage;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4158;
import net.minecraft.class_5218;
import net.minecraft.class_7157;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YetAnotherCarpetAdditionServer
implements ModInitializer,
CarpetExtension {
    public static final String MOD_NAME = "YetAnotherCarpetAddition";
    public static final String MOD_ID = "YetAnotherCarpetAddition".toLowerCase();
    public static SelectiveFreezeManager selectiveFreezeManager = new SelectiveFreezeManager();
    public static final List<AbstractVisualizingManager> allVisualizers = new ArrayList<AbstractVisualizingManager>();
    public static GameEventVisualizing gameEventVisualizing = new GameEventVisualizing();
    public static HopperCooldownVisualizing hopperCooldownVisualizing = new HopperCooldownVisualizing();
    public static BlockEventVisualizing blockEventVisualizing = new BlockEventVisualizing();
    public static RandomTickVisualizing randomTickVisualizing = new RandomTickVisualizing();
    public static ScheduledTickVisualizing scheduledTickVisualizing = new ScheduledTickVisualizing();
    public static BlockUpdateVisualizing blockUpdateVisualizing = new BlockUpdateVisualizing();
    public static BlockEntityOrderVisualizing blockEntityOrderVisualizing = new BlockEntityOrderVisualizing();
    public static POIVisualizing poiVisualizing = new POIVisualizing();
    public static MobAIVisualizer mobAIVisualizer = new MobAIVisualizer();
    public static TreeGrowthObstacleVisualzing treeGrowthObstacleVisualzing = new TreeGrowthObstacleVisualzing();
    public static FoliageAttachmentVisualizing foliageAttachment = new FoliageAttachmentVisualizing();
    public static final String MOD_VERSION = "V1.0.0";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)MOD_ID);
    public static final Set<String> VisualizerTags = new HashSet<String>();
    public static class_3218 serverWorld = null;

    public String version() {
        return MOD_VERSION;
    }

    public String modID() {
        return MOD_ID;
    }

    public static void loadExtension() {
        CarpetServer.manageExtension((CarpetExtension)new YetAnotherCarpetAdditionServer());
    }

    public static boolean isInteger(String str) {
        if (str == null || str.trim().isEmpty()) {
            return false;
        }
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void setUpLogger() {
        org.apache.logging.log4j.Logger rootLogger = LogManager.getRootLogger();
        LogAppender chatAppender = new LogAppender("ChatAppender", null, (Layout<? extends Serializable>)PatternLayout.createDefaultLayout(), true, Property.EMPTY_ARRAY);
        chatAppender.start();
        ((org.apache.logging.log4j.core.Logger)rootLogger).addAppender((Appender)chatAppender);
    }

    public void onInitialize() {
        this.setUpLogger();
        YetAnotherCarpetAdditionServer.loadExtension();
        StepManager.reset();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            WaypointManager.init(server);
            RuleSubscribeManager.init(server);
        });
        ServerWorldEvents.LOAD.register((server, world) -> {
            serverWorld = world;
            try {
                HopperCounterDataManager.initCounterManager();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            FakePlayerControlManager.tickBinds(world);
            if (YetAnotherCarpetAdditionRules.POIVisualize) {
                world.method_8503().method_3760().field_14351.forEach(player -> POIManage.getPOIsWithinRange(player, world, POIVisualizing.RANGE).forEach(poi -> {
                    class_4158 type = (class_4158)poi.method_19142().comp_349();
                    class_243 pos = poi.method_19141().method_46558();
                    poiVisualizing.setVisualizer(player.method_51469(), poi.method_19141(), pos, poi);
                }));
            }
            if (!Objects.equals(YetAnotherCarpetAdditionRules.hopperCounterDataRecorder, "off") && YetAnotherCarpetAdditionServer.isInteger(YetAnotherCarpetAdditionRules.hopperCounterDataRecorder) && CarpetSettings.hopperCounters) {
                HopperCounterDataManager.tick();
            }
            allVisualizers.forEach(AbstractVisualizingManager::updateVisualizer);
        });
        PayloadTypeRegistry.playS2C().register(OptionalFreezePayload.ID, OptionalFreezePayload.CODEC);
        PayloadTypeRegistry.playC2S().register(RequestRulesPayload.ID, RequestRulesPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(RulesPacketPayload.ID, RulesPacketPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(RequestCountersPayload.ID, RequestCountersPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(CountersPacketPayload.ID, CountersPacketPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(RequestRulesPayload.ID, (payload, context) -> context.server().execute(() -> {
            String lang = payload.lang();
            class_3222 player = context.player();
            RulesPacketPayload rulesPacketPayload = new RulesPacketPayload(this.getRules(player.method_51469(), lang), this.getDefaults());
            ServerPlayNetworking.send((class_3222)player, (class_8710)rulesPacketPayload);
        }));
        ServerPlayNetworking.registerGlobalReceiver(RequestCountersPayload.ID, (payload, context) -> context.server().execute(() -> {
            class_3222 player = context.player();
            CountersPacketPayload countersPacketPayload = null;
            try {
                countersPacketPayload = new CountersPacketPayload(HopperCounterDataManager.getCounterLogger().readCounters());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ServerPlayNetworking.send((class_3222)player, (class_8710)countersPacketPayload);
        }));
    }

    private Path getConfigFile() {
        return CarpetServer.minecraft_server.method_27050(class_5218.field_24188).resolve(CarpetServer.settingsManager.identifier() + ".conf");
    }

    private List<String> readSettingsFromConf(Path path) {
        ArrayList<String> arrayList;
        block9: {
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                String line = "";
                ArrayList<String> result = new ArrayList<String>();
                while ((line = reader.readLine()) != null) {
                    String[] fields = (line = line.replaceAll("[\\r\\n]", "")).split("\\s+", 2);
                    if (fields.length <= 1 || result.isEmpty() && fields[0].startsWith("#") || fields[1].startsWith("#")) continue;
                    result.add(fields[0]);
                }
                arrayList = result;
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return new ArrayList<String>();
                }
            }
            reader.close();
        }
        return arrayList;
    }

    public String getDefaults() {
        StringBuilder defaults = new StringBuilder();
        this.readSettingsFromConf(this.getConfigFile()).forEach(c -> defaults.append((String)c).append(";"));
        return defaults.toString();
    }

    public List<RuleData> getRules(class_3218 serverWorld, String lang) {
        ArrayList<RuleData> rules = new ArrayList<RuleData>();
        CarpetServer.settingsManager.getCarpetRules().forEach(rule -> {
            if (rule instanceof CarpetRule) {
                rules.add(new RuleData(YACALanguageUtil.getTranslation(lang, "carpet.rule." + rule.name() + ".name", rule.name()), rule.type(), rule.defaultValue().toString(), rule.value().toString(), YACALanguageUtil.getTranslation(lang, "carpet.rule." + rule.name() + ".desc", null), rule.suggestions().stream().toList(), rule.categories().stream().toList()));
            }
        });
        return rules;
    }

    public void registerLoggers() {
        LoggerRegistry.registerLoggers();
    }

    public void onGameStarted() {
        LOGGER.info("YetAnotherCarpetAddition loaded.");
        CarpetServer.settingsManager.parseSettingsClass(YetAnotherCarpetAdditionRules.class);
    }

    public void onServerLoaded(MinecraftServer server) {
        if (Objects.equals(CarpetSettings.commandPlayer, "false")) {
            FakePlayerControlManager.binds.forEach((player, data) -> FakePlayerControlManager.unbindPlayer(player, (EntityPlayerMPFake)data.getValue()));
        }
    }

    public void onServerClosed(MinecraftServer server) {
        allVisualizers.forEach(visualizer -> visualizer.clearVisualizers(server));
    }

    public void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext) {
        YetAnotherCarpetAdditionCommands.register(dispatcher, commandBuildContext, class_2170.class_5364.field_25420);
    }

    public Map<String, String> canHasTranslations(String lang) {
        return YetAnotherCarpetAdditionTranslations.getTranslations(lang);
    }

    static {
        allVisualizers.add(gameEventVisualizing);
        allVisualizers.add(hopperCooldownVisualizing);
        allVisualizers.add(randomTickVisualizing);
        allVisualizers.add(blockEventVisualizing);
        allVisualizers.add(scheduledTickVisualizing);
        allVisualizers.add(blockUpdateVisualizing);
        allVisualizers.add(blockEntityOrderVisualizing);
        allVisualizers.add(poiVisualizing);
        allVisualizers.add(mobAIVisualizer);
        allVisualizers.add(treeGrowthObstacleVisualzing);
        allVisualizers.add(foliageAttachment);
        for (AbstractVisualizingManager visualizer : allVisualizers) {
            VisualizerTags.add(visualizer.getVisualizerTag());
        }
    }
}

