/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.hopperCounterDataCollector;

import carpet.CarpetServer;
import carpet.helpers.HopperCounter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mypals.ml.YetAnotherCarpetAdditionServer;
import mypals.ml.features.hopperCounterDataCollector.CounterLogger;
import mypals.ml.settings.YetAnotherCarpetAdditionRules;
import net.minecraft.class_1767;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5218;

public class HopperCounterDataManager {
    private static Map<String, HopperCounter> allCounters = new HashMap<String, HopperCounter>();
    private static CounterLogger counterLogger;
    private static int tickCounter;
    private static final int MAX_ROWS = 100;

    public static void initCounterManager() throws IOException {
        allCounters.clear();
        for (class_1767 color : class_1767.values()) {
            allCounters.put(color.method_7792(), HopperCounter.getCounter((class_1767)color));
        }
        class_3218 overworld = CarpetServer.minecraft_server.method_30002();
        Path worldSavePath = overworld.method_8503().method_27050(class_5218.field_24188).normalize();
        Path countersDir = worldSavePath.resolve("counters");
        String csvFilePath = countersDir.resolve("counters.csv").toString();
        if (counterLogger == null) {
            counterLogger = new CounterLogger(csvFilePath, allCounters.keySet().stream().toList());
        }
    }

    public static CounterLogger getCounterLogger() {
        return counterLogger;
    }

    public static void tick() {
        if (++tickCounter >= Integer.parseInt(YetAnotherCarpetAdditionRules.hopperCounterDataRecorder)) {
            tickCounter = 0;
            class_3218 overworld = CarpetServer.minecraft_server.method_30002();
            Path worldSavePath = overworld.method_8503().method_27050(class_5218.field_24188).normalize();
            Path countersDir = worldSavePath.resolve("counters");
            Path csvFilePath = countersDir.resolve("counters.csv");
            try {
                Files.createDirectories(countersDir, new FileAttribute[0]);
                if (counterLogger == null) {
                    counterLogger = new CounterLogger(csvFilePath.toString(), allCounters.keySet().stream().toList());
                }
                HopperCounterDataManager.trimCsvIfNeeded(csvFilePath);
                HashMap<String, String> counters = new HashMap<String, String>();
                allCounters.forEach((name, counter) -> {
                    if (counter != null) {
                        String counterValue = counter.getTotalItems() + "^^^";
                        for (class_2561 text : counter.format(CarpetServer.minecraft_server, false, false)) {
                            counterValue = counterValue + text.getString() + "@@";
                        }
                        counters.put((String)name, counterValue);
                    }
                });
                counterLogger.logCounters(counters);
                YetAnotherCarpetAdditionServer.LOGGER.info("Logged counters to {}", (Object)csvFilePath);
            }
            catch (IOException e) {
                YetAnotherCarpetAdditionServer.LOGGER.error("Failed to log counters", (Throwable)e);
            }
        }
    }

    private static void trimCsvIfNeeded(Path csvFilePath) throws IOException {
        if (!Files.exists(csvFilePath, new LinkOption[0])) {
            return;
        }
        List<String> lines = Files.readAllLines(csvFilePath);
        if (lines.size() <= 101) {
            return;
        }
        List<String> newLines = lines.subList(0, 1);
        newLines.addAll(lines.subList(lines.size() - 100 + 1, lines.size()));
        Files.write(csvFilePath, newLines.stream().collect(Collectors.joining(System.lineSeparator())).getBytes(), new OpenOption[0]);
    }

    static {
        tickCounter = 0;
    }
}

