/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.visualizingFeatures;

import mypals.ml.features.visualizingFeatures.EntityHelper;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public abstract class AbstractVisualizingManager<T, E> {
    protected abstract void storeVisualizer(T var1, E var2);

    protected abstract void updateVisualizerEntity(E var1, Object var2);

    protected abstract E createVisualizerEntity(class_3218 var1, class_243 var2, Object var3);

    protected abstract void removeVisualizerEntity(T var1);

    protected static long getDeleteTick(int duration, class_3218 world) {
        return world.method_8510() + (long)duration;
    }

    public void setVisualizer(class_3218 world, T key, class_243 pos, Object data) {
        E marker = this.getVisualizer(key);
        if (marker != null) {
            this.updateVisualizerEntity(marker, data);
        } else {
            marker = this.createVisualizerEntity(world, pos, data);
            this.storeVisualizer(key, marker);
        }
    }

    public void removeVisualizer(T key) {
        this.removeVisualizerEntity(key);
    }

    protected abstract void clearAllVisualizers();

    public void clearVisualizers(MinecraftServer server) {
        EntityHelper.clearVisualizersInServer(server, this.getVisualizerTag());
    }

    protected abstract E getVisualizer(T var1);

    public abstract String getVisualizerTag();

    protected class_2487 configureCommonNbt(class_2487 nbt) {
        nbt.method_10582("billboard", "center");
        nbt.method_10567("see_through", (byte)1);
        return nbt;
    }

    public abstract void updateVisualizer();
}

