/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.visualizingFeatures;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import mypals.ml.features.visualizingFeatures.AbstractVisualizingManager;
import mypals.ml.features.visualizingFeatures.MobGoals;
import mypals.ml.utils.adapter.NBTDataManager;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1355;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_8113;

public class MobAIVisualizer
extends AbstractVisualizingManager<class_1297, Map.Entry<MobAIData, class_8113.class_8123>> {
    private static final Map<class_1297, Map.Entry<MobAIData, class_8113.class_8123>> visualizers = new HashMap<class_1297, Map.Entry<MobAIData, class_8113.class_8123>>();

    @Override
    protected void storeVisualizer(class_1297 key, Map.Entry<MobAIData, class_8113.class_8123> data) {
        visualizers.put(key, data);
    }

    @Override
    protected void updateVisualizerEntity(Map.Entry<MobAIData, class_8113.class_8123> marker, Object data) {
        class_8113.class_8123 display = marker.getValue();
        MobAIData mobAIData = marker.getKey();
        class_1308 keyEntity = marker.getKey().entity;
        if (keyEntity == null || keyEntity.method_31481() || !keyEntity.method_5805() || display == null || display.method_31481()) {
            display.method_31472();
            visualizers.remove(keyEntity);
            return;
        }
        this.displayTargetAndGoals(mobAIData, display);
        display.method_23327(keyEntity.method_23317(), keyEntity.method_23318() + (double)keyEntity.method_17682() + 0.5, keyEntity.method_23321());
    }

    @Override
    protected Map.Entry<MobAIData, class_8113.class_8123> createVisualizerEntity(class_3218 world, class_243 pos, Object data) {
        if (data instanceof MobAIData) {
            MobAIData mobAIData = (MobAIData)data;
            class_8113.class_8123 display = new class_8113.class_8123(class_1299.field_42457, (class_1937)world);
            display.method_5875(true);
            display.method_5684(true);
            display.method_23327(pos.method_10216(), pos.method_10214() + (double)0.1f, pos.method_10215());
            display.method_5780(this.getVisualizerTag());
            display.method_5780("DoNotTick");
            world.method_8649((class_1297)display);
            display.method_5804((class_1297)mobAIData.entity);
            this.displayTargetAndGoals(mobAIData, display);
            return Map.entry(mobAIData, display);
        }
        return null;
    }

    @Override
    protected void removeVisualizerEntity(class_1297 key) {
        class_8113.class_8123 entity = visualizers.get(key).getValue();
        if (entity != null) {
            entity.method_31472();
            visualizers.remove(key);
        }
    }

    @Override
    protected void clearAllVisualizers() {
        visualizers.clear();
    }

    @Override
    protected Map.Entry<MobAIData, class_8113.class_8123> getVisualizer(class_1297 key) {
        return visualizers.get(key) == null ? null : visualizers.get(key);
    }

    @Override
    public String getVisualizerTag() {
        return "mobAIVisualize";
    }

    @Override
    public void updateVisualizer() {
        for (Map.Entry<class_1297, Map.Entry<MobAIData, class_8113.class_8123>> entry : visualizers.entrySet()) {
            class_8113.class_8123 display = entry.getValue().getValue();
            MobAIData mobAIData = entry.getValue().getKey();
            class_1297 keyEntity = entry.getKey();
            if (keyEntity == null || keyEntity.method_31481() || !keyEntity.method_5805() || display == null || display.method_31481()) {
                display.method_31472();
                visualizers.remove(keyEntity);
                return;
            }
            this.displayTargetAndGoals(mobAIData, display);
        }
    }

    private void displayTargetAndGoals(MobAIData data, class_8113.class_8123 display) {
        JsonObject textJson = new JsonObject();
        textJson.addProperty("text", "");
        JsonArray extra = new JsonArray();
        JsonObject goalSelectorHeader = new JsonObject();
        goalSelectorHeader.addProperty("text", "GoalSelector:\n");
        goalSelectorHeader.addProperty("color", "white");
        extra.add((JsonElement)goalSelectorHeader);
        data.goalSelector.method_35115().forEach(goal -> {
            if (goal.method_19058() != null) {
                String goalName = MobGoals.getGoalName(goal.method_19058().getClass());
                String translatedName = class_2561.method_43471((String)goalName).getString();
                String color = goal.method_19056() ? "gold" : "gray";
                JsonObject goalPart = new JsonObject();
                goalPart.addProperty("text", "- " + translatedName + "\n");
                goalPart.addProperty("color", color);
                extra.add((JsonElement)goalPart);
            }
        });
        JsonObject targetSelectorHeader = new JsonObject();
        targetSelectorHeader.addProperty("text", "TargetSelector:\n");
        targetSelectorHeader.addProperty("color", "white");
        extra.add((JsonElement)targetSelectorHeader);
        data.targetSelector.method_35115().forEach(goal -> {
            if (goal.method_19058() != null) {
                String goalName = MobGoals.getGoalName(goal.method_19058().getClass());
                String translatedName = class_2561.method_43471((String)goalName).getString();
                String color = goal.method_19056() ? "gold" : "gray";
                JsonObject goalPart = new JsonObject();
                goalPart.addProperty("text", "- " + translatedName + "\n");
                goalPart.addProperty("color", color);
                extra.add((JsonElement)goalPart);
            }
        });
        textJson.add("extra", (JsonElement)extra);
        class_2487 nbt = NBTDataManager.readFromEntity((class_1297)display, new class_2487());
        nbt.method_10582("text", textJson.toString());
        nbt = this.configureCommonNbt(nbt);
        NBTDataManager.writeToEntity((class_1297)display, nbt);
    }

    public static class MobAIData {
        public class_1355 goalSelector;
        public class_1355 targetSelector;
        public class_1308 entity;

        public MobAIData(class_1308 entity, class_1355 goalSelector, class_1355 targetSelector) {
            this.entity = entity;
            this.goalSelector = goalSelector;
            this.targetSelector = targetSelector;
        }
    }
}

