/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.Screen.RulesEditScreen;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import mypals.ml.Screen.RulesEditScreen.CategoryEntry;
import mypals.ml.Screen.RulesEditScreen.ConstantScrollableWidget;
import mypals.ml.Screen.RulesEditScreen.RuleWidget;
import mypals.ml.YetAnotherCarpetAdditionClient;
import mypals.ml.YetAnotherCarpetAdditionServer;
import mypals.ml.network.RuleData;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_279;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import net.minecraft.class_757;
import net.minecraft.class_9922;
import net.minecraft.class_9960;

public class RulesEditScreen
extends class_437
implements class_4069 {
    private static final class_2561 CONFIGURE_TEXT = class_2561.method_43471((String)"gui.screen.configure");
    private static final class_2960 CONFIGURE_TEXTURE = class_2960.method_60655((String)YetAnotherCarpetAdditionServer.MOD_ID, (String)"textures/gui/configure.png");
    public String currentCategory;
    public String lastCategoryBeforeSearching;
    private static CopyOnWriteArrayList<RuleWidget> rulesInCurrentCategory = new CopyOnWriteArrayList();
    private static List<CategoryEntry> categoriesInScreen = new ArrayList<CategoryEntry>();
    public ConstantScrollableWidget rulesScrollableWidget;
    public ConstantScrollableWidget categoriesScrollableWidget;
    public List<class_2561> currentToolTips;
    public class_342 searchFieldWidget;
    public boolean searching;
    private static Pattern searchRulePattern = Pattern.compile("(?<=[a-z])(?=[A-Z])|(?<=[A-Z])(?=[A-Z][a-z])");

    public RulesEditScreen(class_2561 title) {
        super(title);
        this.lastCategoryBeforeSearching = this.currentCategory = "unknown";
        this.currentToolTips = new ArrayList<class_2561>();
        this.searching = false;
    }

    public void setCurrentCategory(String category) {
        this.currentCategory = category;
        if (!Objects.equals(this.currentCategory, "searching")) {
            this.lastCategoryBeforeSearching = category;
        }
        categoriesInScreen.clear();
        YetAnotherCarpetAdditionClient.chachedCategories.forEach(c -> categoriesInScreen.add(new CategoryEntry((String)c)));
        rulesInCurrentCategory.clear();
        YetAnotherCarpetAdditionClient.chachedRules.stream().filter(r -> r.categories.contains(this.currentCategory)).sorted(Comparator.comparing(rule -> {
            String englishName = rule.name.split("```", 2)[0].trim();
            return englishName.isEmpty() ? "" : englishName.toLowerCase().substring(0, 1);
        })).toList().forEach(r -> rulesInCurrentCategory.add(new RuleWidget((RuleData)r, this)));
        if (Objects.equals(this.currentCategory, "default")) {
            rulesInCurrentCategory.clear();
            YetAnotherCarpetAdditionClient.chachedRules.stream().filter(r -> {
                String orgName = r.name.split("```").length > 1 ? r.name.split("```")[1] : r.name.split("```")[0];
                return YetAnotherCarpetAdditionClient.defaultRules.contains(orgName);
            }).sorted(Comparator.comparing(rule -> {
                String englishName = rule.name.split("```", 2)[0].trim();
                return englishName.isEmpty() ? "" : englishName.toLowerCase().substring(0, 1);
            })).toList().forEach(r -> rulesInCurrentCategory.add(new RuleWidget((RuleData)r, this)));
        }
        if (Objects.equals(this.currentCategory, "favorite")) {
            rulesInCurrentCategory.clear();
            YetAnotherCarpetAdditionClient.chachedRules.stream().filter(r -> {
                String orgName = r.name.split("```").length > 1 ? r.name.split("```")[1] : r.name.split("```")[0];
                return YetAnotherCarpetAdditionClient.favoriteRules.contains(orgName);
            }).sorted(Comparator.comparing(rule -> {
                String englishName = rule.name.split("```", 2)[0].trim();
                return englishName.isEmpty() ? "" : englishName.toLowerCase().substring(0, 1);
            })).toList().forEach(r -> rulesInCurrentCategory.add(new RuleWidget((RuleData)r, this)));
        }
        if (this.rulesScrollableWidget != null) {
            this.rulesScrollableWidget.setScrollY(0.0);
        }
    }

    public static List<String> splitRuleName(String ruleName) {
        String otherLangPart;
        ArrayList<String> parts = new ArrayList<String>();
        if (ruleName == null || ruleName.isEmpty()) {
            return parts;
        }
        String[] sections = ruleName.split("```", 2);
        String englishPart = sections[0].trim();
        String string = otherLangPart = sections.length > 1 ? sections[1].trim() : "";
        if (!englishPart.isEmpty()) {
            String[] words;
            for (String word : words = searchRulePattern.split(englishPart)) {
                if (word.isEmpty()) continue;
                parts.add(word.toLowerCase());
            }
        }
        if (!otherLangPart.isEmpty()) {
            parts.add(otherLangPart);
        }
        return parts;
    }

    public static boolean matchesRule(List<String> parts, String input) {
        if (input == null || input.isEmpty() || parts == null || parts.isEmpty()) {
            return false;
        }
        String lowerInput = input.toLowerCase();
        for (String part : parts) {
            String lowerPart = part.toLowerCase();
            if (lowerPart.equals(lowerInput) || lowerPart.contains(lowerInput)) {
                return true;
            }
            if (!part.contains(input)) continue;
            return true;
        }
        return false;
    }

    protected void method_25426() {
        this.setCurrentCategory(YetAnotherCarpetAdditionClient.chachedCategories.get(2));
        this.searchFieldWidget = new class_342(this, class_310.method_1551().field_1772, 15, 10, this.field_22789 - this.field_22789 / 3 - 7, 15, CONFIGURE_TEXT){

            public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
                if (this.method_1885()) {
                    context.method_51739(class_1921.method_51785(), this.method_46426(), this.method_46427() - 1, this.field_22758 + 1, this.field_22759 + 1 + 9, 0xAAAAAAA);
                    context.method_51739(class_1921.method_51785(), this.method_46426(), this.method_46427() + this.field_22759 - 4, this.field_22758 + 1, this.method_46427() + this.field_22759 - 5, -1342177281);
                    super.method_48579(context, mouseX, mouseY, delta);
                }
            }
        };
        this.method_37063((class_364)this.searchFieldWidget);
        this.searchFieldWidget.method_1858(false);
        this.searchFieldWidget.method_1863(newText -> {
            if (newText.isEmpty()) {
                this.searching = false;
                this.setCurrentCategory(this.lastCategoryBeforeSearching);
            } else {
                this.searching = true;
                this.setCurrentCategory("searching");
                rulesInCurrentCategory.clear();
                YetAnotherCarpetAdditionClient.chachedRules.stream().filter(r -> {
                    List<String> splitRuleName = RulesEditScreen.splitRuleName(r.name);
                    splitRuleName.addAll(r.categories);
                    return RulesEditScreen.matchesRule(splitRuleName, newText);
                }).sorted(Comparator.comparing(rule -> {
                    String englishName = rule.name.split("```", 2)[0].trim();
                    return englishName.isEmpty() ? "" : englishName.toLowerCase().substring(0, 1);
                })).toList().forEach(r -> rulesInCurrentCategory.add(new RuleWidget((RuleData)r, this)));
            }
        });
        this.searchFieldWidget.method_1880(100);
        this.rulesScrollableWidget = new ConstantScrollableWidget(0, 30, this.field_22789 - this.field_22789 / 3, this.field_22790 - 30, class_5244.field_39003){
            int boxWidth;
            int boxHeight;
            int spacing;
            {
                this.boxWidth = this.field_22758 - 10;
                this.boxHeight = 30;
                this.spacing = 5;
            }

            @Override
            protected int getContentsHeight() {
                return (this.boxHeight + this.spacing) * rulesInCurrentCategory.size() - this.spacing;
            }

            @Override
            protected double getDeltaYPerScroll() {
                return 10.0;
            }

            @Override
            protected void renderContents(class_332 context, int mouseX, int mouseY, float delta) {
                int index = 0;
                double adjustedMouseY = (double)mouseY + this.getScrollY();
                RulesEditScreen.this.currentToolTips = new ArrayList<class_2561>();
                for (RuleWidget entry : rulesInCurrentCategory) {
                    int x = 5;
                    int y = this.method_46427() + this.boxHeight / 4 + (this.boxHeight + this.spacing) * index;
                    entry.setPosition(x, y);
                    boolean isMouseOver = mouseX >= x && mouseX <= x + this.boxWidth && adjustedMouseY >= (double)y && adjustedMouseY <= (double)(y + this.boxHeight) && mouseY >= this.method_46427();
                    List<class_2561> tooltips = entry.renderContents(context, mouseX, mouseY, delta, isMouseOver, index, this.spacing, this.boxHeight, this.boxWidth);
                    RulesEditScreen.this.currentToolTips = RulesEditScreen.this.currentToolTips.isEmpty() && tooltips != null ? tooltips : RulesEditScreen.this.currentToolTips;
                    ++index;
                }
            }

            @Override
            public boolean method_25402(double mouseX, double mouseY, int button) {
                int index = 0;
                double adjustedMouseY = mouseY + this.getScrollY();
                for (RuleWidget entry : rulesInCurrentCategory) {
                    int x = 5;
                    int y = this.method_46427() + this.boxHeight / 4 + (this.boxHeight + this.spacing) * index;
                    entry.onClicked(mouseX, mouseY, mouseX >= (double)x && mouseX <= (double)(x + this.boxWidth) && adjustedMouseY >= (double)y && adjustedMouseY <= (double)(y + this.boxHeight), button);
                    ++index;
                }
                return super.method_25402(mouseX, mouseY, button);
            }

            public boolean method_25400(char chr, int modifiers) {
                for (RuleWidget entry : rulesInCurrentCategory) {
                    if (!entry.valueWidget.method_25370()) continue;
                    entry.valueWidget.method_25400(chr, modifiers);
                    return true;
                }
                return super.method_25400(chr, modifiers);
            }

            @Override
            public boolean method_25404(int keyCode, int scanCode, int modifiers) {
                for (RuleWidget entry : rulesInCurrentCategory) {
                    if (!entry.valueWidget.method_25370()) continue;
                    entry.valueWidget.method_25404(keyCode, scanCode, modifiers);
                    return true;
                }
                return super.method_25404(keyCode, scanCode, modifiers);
            }

            protected void method_47399(class_6382 builder) {
            }

            @Override
            protected void drawBox(class_332 context, int x, int y, int width, int height) {
                context.method_25294(this.method_46426(), y, this.method_46426() + this.boxWidth + 10, this.method_55443(), 0x19000000);
            }
        };
        this.method_37063(this.rulesScrollableWidget);
        this.categoriesScrollableWidget = new ConstantScrollableWidget(this.field_22789 - this.field_22789 / 3 + 30, 30, 120, this.field_22790 - 30, class_5244.field_39003){
            int boxWidth;
            int boxHeight;
            int spacing;
            {
                this.boxWidth = this.field_22758 - 10;
                this.boxHeight = 20;
                this.spacing = 5;
            }

            @Override
            protected int getContentsHeight() {
                return (this.boxHeight + this.spacing) * categoriesInScreen.size() - this.spacing;
            }

            @Override
            protected double getDeltaYPerScroll() {
                return 10.0;
            }

            @Override
            protected void renderContents(class_332 context, int mouseX, int mouseY, float delta) {
                int index = 0;
                double adjustedMouseY = (double)mouseY + this.getScrollY();
                for (CategoryEntry categoryEntry : categoriesInScreen) {
                    int x = this.method_46426() + 5;
                    int y = this.method_46427() + this.boxHeight / 4 + (this.boxHeight + this.spacing) * index;
                    boolean isMouseOver = mouseX >= x && mouseX <= x + this.boxWidth && adjustedMouseY >= (double)y && adjustedMouseY <= (double)(y + this.boxHeight);
                    context.method_25296(x, y, x + this.boxWidth, y + this.boxHeight, categoryEntry.selected != false ? 788923910 : 0x50060606, categoryEntry.selected != false ? 0x50060606 : 0x20060606);
                    context.method_51433(class_310.method_1551().field_1772, categoryEntry.name, x + 5, y + 5, -1, true);
                    context.method_25294(x, y + this.boxHeight - 2, x + this.boxWidth, y + this.boxHeight, isMouseOver ? Color.WHITE.getRGB() : Color.GRAY.getRGB());
                    ++index;
                }
            }

            @Override
            public boolean method_25402(double mouseX, double mouseY, int button) {
                int index = 0;
                double adjustedMouseY = mouseY + this.getScrollY();
                for (CategoryEntry entry : categoriesInScreen) {
                    int x = this.method_46426() + 5;
                    int y = this.method_46427() + this.boxHeight / 4 + (this.boxHeight + this.spacing) * index;
                    if (mouseX >= (double)x && mouseX <= (double)(x + this.boxWidth) && adjustedMouseY >= (double)y && adjustedMouseY <= (double)(y + this.boxHeight)) {
                        RulesEditScreen.this.setCurrentCategory(entry.getName());
                        entry.setSelected(true);
                        categoriesInScreen.get(index).setSelected(true);
                        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                        return true;
                    }
                    entry.setSelected(false);
                    ++index;
                }
                return super.method_25402(mouseX, mouseY, button);
            }

            protected void method_47399(class_6382 builder) {
            }

            @Override
            protected void drawBox(class_332 context, int x, int y, int width, int height) {
                context.method_25294(this.method_46426(), y, this.method_46426() + this.boxWidth + 10, this.method_55443(), 0xF060606);
            }
        };
        this.method_37063(this.categoriesScrollableWidget);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_25290(class_1921::method_62277, this.searching ? class_2960.method_60655((String)YetAnotherCarpetAdditionServer.MOD_ID, (String)"ui/search_s.png") : class_2960.method_60655((String)YetAnotherCarpetAdditionServer.MOD_ID, (String)"ui/search.png"), 2, 10, 0.0f, 0.0f, 10, 11, 10, 11);
        if (this.currentToolTips != null && !this.currentToolTips.isEmpty()) {
            context.method_51434(class_310.method_1551().field_1772, this.currentToolTips, mouseX, mouseY);
        }
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        RulesEditScreen.method_57737((class_332)context, (class_2960)field_49511, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.field_22789, (int)this.field_22790);
        class_757 gameRenderer = class_310.method_1551().field_1773;
        if (FabricLoader.getInstance().isModLoaded("blur") || FabricLoader.getInstance().isModLoaded("modernui")) {
            super.method_25420(context, mouseX, mouseY, delta);
        } else {
            class_2960 BLUR_SHADER = class_2960.method_60656((String)"blur");
            class_279 blur = this.field_22787.method_62887().method_62941(BLUR_SHADER, class_9960.field_53902);
            if (blur != null) {
                blur.method_57799("Radius", 20.0f);
                blur.method_1258(this.field_22787.method_1522(), (class_9922)gameRenderer.field_53066);
            }
            this.field_22787.method_1522().method_1235(false);
        }
        context.method_51433(class_310.method_1551().field_1772, this.currentCategory, this.field_22789 - this.field_22789 / 3 + 20, 17, -1, true);
    }
}

