/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.subscribeRules;

import carpet.CarpetServer;
import carpet.api.settings.CarpetRule;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class RuleSubscribeManager {
    public static File configFile;
    private static int MAX_SUBSCRIBES;
    public static Map<String, CarpetRule<?>> subscribed;

    public static void init(MinecraftServer server) {
        File worldDir = server.method_27050(class_5218.field_24188).toFile();
        File configDir = new File(worldDir, "YACA");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        configFile = new File(configDir, "subs.json");
        RuleSubscribeManager.loadSub();
        if (subscribed == null) {
            subscribed = new HashMap();
        }
    }

    public static void loadSub() {
        try {
            if (configFile.exists()) {
                FileReader reader = new FileReader(configFile);
                Type type = new TypeToken<Set<String>>(){}.getType();
                Set names = (Set)new Gson().fromJson((Reader)reader, type);
                Map<String, CarpetRule> ruleMap = CarpetServer.settingsManager.getCarpetRules().stream().filter(rule -> rule != null && rule.name() != null).collect(Collectors.toMap(CarpetRule::name, rule -> rule, (r1, r2) -> r1));
                for (String name : names) {
                    CarpetRule rule2 = ruleMap.get(name);
                    if (rule2 == null) continue;
                    subscribed.put(name, rule2);
                }
                reader.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        RuleSubscribeManager.saveSub();
    }

    public static void saveSub() {
        try {
            FileWriter writer = new FileWriter(configFile);
            new GsonBuilder().setPrettyPrinting().create().toJson(subscribed.keySet(), (Appendable)writer);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void subscribeRule(String name, class_2168 source) {
        if (subscribed.containsKey(name)) {
            source.method_9226(() -> class_2561.method_30163((String)("Unsubscribed to rule: " + name)), true);
            subscribed.remove(name);
        } else {
            CarpetServer.settingsManager.getCarpetRules().stream().forEach(carpetRule -> {
                if (carpetRule.name().equals(name)) {
                    if (subscribed.size() >= MAX_SUBSCRIBES) {
                        source.method_9213(class_2561.method_30163((String)"You have reached the maximum number of subscribed rules."));
                        return;
                    }
                    subscribed.put(name, (CarpetRule<?>)carpetRule);
                    source.method_9226(() -> class_2561.method_30163((String)("Subscribed to rule: " + name)), true);
                }
            });
        }
        RuleSubscribeManager.saveSub();
    }

    static {
        MAX_SUBSCRIBES = 10;
        subscribed = new HashMap();
    }
}

