/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.settings;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;

public class YACAConfigManager {
    private static final Path CONFIG_DIR = FabricLoader.getInstance().getConfigDir();
    private static final Path YACA_DIR = CONFIG_DIR.resolve("YACA");
    private static final Path FAVORITE_RULES_FILE = YACA_DIR.resolve("favoriteRules.conf");

    public static void initializeConfig() {
        try {
            if (!Files.exists(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            if (!Files.exists(YACA_DIR, new LinkOption[0])) {
                Files.createDirectories(YACA_DIR, new FileAttribute[0]);
            }
            if (!Files.exists(FAVORITE_RULES_FILE, new LinkOption[0])) {
                Files.createFile(FAVORITE_RULES_FILE, new FileAttribute[0]);
                Files.writeString(FAVORITE_RULES_FILE, (CharSequence)"# YACA Favorite Rules Configuration\n", new OpenOption[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Path getFavoriteRulesConfigPath() {
        return FAVORITE_RULES_FILE;
    }

    public static List<String> readFavoriteRules() {
        try {
            if (Files.exists(FAVORITE_RULES_FILE, new LinkOption[0])) {
                return Files.readAllLines(FAVORITE_RULES_FILE).stream().filter(line -> !line.trim().isEmpty() && !line.trim().startsWith("#")).collect(Collectors.toList());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ArrayList<String>();
    }

    public static void writeFavoriteRules(List<String> rules) {
        try {
            if (!Files.exists(YACA_DIR, new LinkOption[0])) {
                Files.createDirectories(YACA_DIR, new FileAttribute[0]);
            }
            ArrayList<String> content = new ArrayList<String>();
            content.add("# YACA Favorite Rules Configuration\n");
            if (rules != null) {
                content.addAll(rules);
            }
            Files.write(FAVORITE_RULES_FILE, content, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addFavoriteRule(String rule) {
        if (rule == null || rule.trim().isEmpty()) {
            return;
        }
        List<String> rules = YACAConfigManager.readFavoriteRules();
        if (!rules.contains(rule)) {
            rules.add(rule);
            YACAConfigManager.writeFavoriteRules(rules);
        }
    }

    public static void removeFavoriteRule(String rule) {
        if (rule == null || rule.trim().isEmpty()) {
            return;
        }
        List<String> rules = YACAConfigManager.readFavoriteRules();
        rules.removeIf(r -> r.equalsIgnoreCase(rule));
        YACAConfigManager.writeFavoriteRules(rules);
    }
}

