/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.commands;

import carpet.CarpetSettings;
import carpet.patches.EntityPlayerMPFake;
import carpet.utils.CommandHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import mypals.ml.features.fakePlayerControl.FakePlayerControlManager;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class BindPlayerCommand {
    private static final SimpleCommandExceptionType NOT_REAL_PLAYER = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"The first argument must be a real player, not a fake player."));
    private static final SimpleCommandExceptionType NOT_FAKE_PLAYER = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"The second argument must be a fake player."));
    private static final SimpleCommandExceptionType PLAYER_NOT_FOUND = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Player not found."));

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"bindToFake").requires(source -> CommandHelper.canUseCommand((class_2168)source, (Object)CarpetSettings.commandPlayer))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"player2", (ArgumentType)class_2186.method_9305()).executes(context -> BindPlayerCommand.execute((CommandContext<class_2168>)context, class_2186.method_9315((CommandContext)context, (String)"player"), class_2186.method_9315((CommandContext)context, (String)"player2"))))));
    }

    private static int execute(CommandContext<class_2168> context, class_3222 player, class_3222 fakePlayer) throws CommandSyntaxException {
        if (player == null || fakePlayer == null) {
            throw PLAYER_NOT_FOUND.create();
        }
        if (player instanceof EntityPlayerMPFake) {
            throw NOT_REAL_PLAYER.create();
        }
        if (!(fakePlayer instanceof EntityPlayerMPFake)) {
            throw NOT_FAKE_PLAYER.create();
        }
        boolean suc = FakePlayerControlManager.tryBind(player, (EntityPlayerMPFake)fakePlayer);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Successfully " + (suc ? "bound " : "unbound ") + player.method_5820() + " to " + fakePlayer.method_5820())), true);
        return 1;
    }
}

