/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.hopperCounterDataCollector;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CounterLogger {
    private final String filename;
    private final List<String> counterNames;

    public CounterLogger(String filename, List<String> counterNames) throws IOException {
        this.filename = filename;
        this.counterNames = counterNames;
        File file = new File(filename);
        File parentDir = file.getParentFile();
        if (!parentDir.exists()) {
            Files.createDirectories(parentDir.toPath(), new FileAttribute[0]);
        }
    }

    public void logCounters(Map<String, String> counters) throws IOException {
        boolean fileExists = new File(this.filename).exists();
        try (FileWriter fw = new FileWriter(this.filename, true);
             BufferedWriter bw = new BufferedWriter(fw);
             PrintWriter out = new PrintWriter(bw);){
            if (!fileExists) {
                String header = "timestamp|=|" + String.join((CharSequence)"|=|", this.counterNames);
                out.println(header);
            }
            String timestamp = Instant.now().toString();
            ArrayList<String> values = new ArrayList<String>();
            values.add(timestamp);
            for (String name : this.counterNames) {
                values.add(counters.getOrDefault(name, "ERROR|:|").toString());
            }
            out.println(String.join((CharSequence)"|=|", values));
        }
    }

    public Map<String, Map<String, String>> readCounters() throws IOException {
        LinkedHashMap<String, Map<String, String>> records = new LinkedHashMap<String, Map<String, String>>();
        File file = new File(this.filename);
        if (!file.exists()) {
            return records;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            String headerLine = br.readLine();
            if (headerLine == null) {
                LinkedHashMap<String, Map<String, String>> linkedHashMap = records;
                return linkedHashMap;
            }
            String[] headers = headerLine.split("\\|=\\|");
            List<String> headerList = Arrays.asList(headers);
            if (!headerList.get(0).equals("timestamp")) {
                throw new IOException("Invalid CSV format: missing timestamp column");
            }
            while ((line = br.readLine()) != null) {
                String[] values = line.split("\\|=\\|");
                if (values.length < 1) continue;
                String timestamp = values[0];
                HashMap<String, String> counters = new HashMap<String, String>();
                for (int i = 1; i < headers.length && i < values.length; ++i) {
                    counters.put(headers[i], values[i]);
                }
                records.put(timestamp, counters);
            }
        }
        return records;
    }

    public void clearCounters() throws IOException {
        try (FileWriter fw = new FileWriter(this.filename);
             BufferedWriter bw = new BufferedWriter(fw);
             PrintWriter out = new PrintWriter(bw);){
            String header = "timestamp|=|" + String.join((CharSequence)"|=|", this.counterNames);
            out.println(header);
        }
    }
}

