/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.visualizingFeatures;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import mypals.ml.features.visualizingFeatures.AbstractVisualizingManager;
import mypals.ml.utils.adapter.NBTDataManager;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_8113;

public class ScheduledTickVisualizing
extends AbstractVisualizingManager<class_2338, ScheduledTickObject> {
    private static final ConcurrentHashMap<class_2338, Map.Entry<ScheduledTickObject, Long>> visualizers = new ConcurrentHashMap();
    private static final int SURVIVE_TIME = 100;

    @Override
    protected void storeVisualizer(class_2338 key, ScheduledTickObject entity) {
        visualizers.put(key, Map.entry(entity, ScheduledTickVisualizing.getDeleteTick(100, (class_3218)entity.tickMarker.method_37908())));
    }

    @Override
    protected void updateVisualizerEntity(ScheduledTickObject marker, Object data) {
        if (data instanceof Object[]) {
            Object[] tickData = (Object[])data;
            if (marker.tickMarker != null && !marker.tickMarker.method_31481()) {
                long triggerTick = (Long)tickData[0];
                int priority = (Integer)tickData[1];
                long subTickOrder = (Long)tickData[2];
                long time = marker.tickMarker.method_37908().method_8510();
                int trigger = (int)(triggerTick - time) - 1;
                JsonObject textJson = new JsonObject();
                textJson.addProperty("text", "");
                JsonArray extra = new JsonArray();
                JsonObject triggerPart = new JsonObject();
                triggerPart.addProperty("text", "T:" + trigger);
                triggerPart.addProperty("color", "red");
                extra.add((JsonElement)triggerPart);
                JsonObject priorityPart = new JsonObject();
                priorityPart.addProperty("text", "\nP:" + priority);
                priorityPart.addProperty("color", "green");
                extra.add((JsonElement)priorityPart);
                JsonObject subTickPart = new JsonObject();
                subTickPart.addProperty("text", "\nS:" + subTickOrder);
                subTickPart.addProperty("color", "blue");
                extra.add((JsonElement)subTickPart);
                textJson.add("extra", (JsonElement)extra);
                class_2487 nbt = NBTDataManager.readFromEntity((class_1297)marker.tickMarker, new class_2487());
                nbt.method_10582("text", textJson.toString());
                NBTDataManager.writeToEntity((class_1297)marker.tickMarker, nbt);
            }
        }
    }

    @Override
    protected ScheduledTickObject createVisualizerEntity(class_3218 world, class_243 pos, Object data) {
        if (data instanceof Object[]) {
            Object[] tickData = (Object[])data;
            long triggerTick = (Long)tickData[0];
            int priority = (Integer)tickData[1];
            long subTickOrder = (Long)tickData[2];
            String type = (String)tickData[3];
            boolean isFluid = (Boolean)tickData[4];
            class_2338 blockPos = class_2338.method_49638((class_2374)pos);
            return new ScheduledTickObject(world, blockPos, triggerTick, priority, subTickOrder, type, isFluid, this.getVisualizerTag());
        }
        return null;
    }

    @Override
    protected void removeVisualizerEntity(class_2338 key) {
        Map.Entry<ScheduledTickObject, Long> entry = visualizers.get(key);
        if (entry != null) {
            entry.getKey().removeVisualizer();
            visualizers.remove(key);
        }
    }

    @Override
    protected ScheduledTickObject getVisualizer(class_2338 key) {
        Map.Entry<ScheduledTickObject, Long> entry = visualizers.get(key);
        return entry == null ? null : entry.getKey();
    }

    @Override
    public String getVisualizerTag() {
        return "scheduledTickVisualize";
    }

    @Override
    protected void clearAllVisualizers() {
        visualizers.values().forEach(entry -> ((ScheduledTickObject)entry.getKey()).removeVisualizer());
        visualizers.clear();
    }

    @Override
    public void updateVisualizer() {
    }

    public void setVisualizer(class_3218 world, class_2338 pos, long triggerTick, int priority, long subTickOrder, String content, boolean isFluid) {
        Object[] data = new Object[]{triggerTick, priority, subTickOrder, content, isFluid};
        this.setVisualizer(world, pos, pos.method_46558(), data);
    }

    public static class ScheduledTickObject {
        public long triggerTick;
        public int priority;
        public long subTickOrder;
        public String type;
        public class_8113.class_8123 tickMarker;
        public String tag;

        public ScheduledTickObject(class_3218 world, class_2338 pos, long triggerTick, int priority, long subTickOrder, String type, boolean isFluid, String tag) {
            this.triggerTick = triggerTick;
            this.priority = priority;
            this.subTickOrder = subTickOrder;
            this.type = type;
            this.tag = tag;
            this.setVisualizer(world, pos, triggerTick, priority, subTickOrder);
        }

        public void setVisualizer(class_3218 world, class_2338 pos, long triggerTick, int priority, long subTickOrder) {
            long time = world.method_8510();
            int trigger = (int)(triggerTick - time) - 1;
            if (this.tickMarker != null && !this.tickMarker.method_31481()) {
                JsonObject textJson = new JsonObject();
                textJson.addProperty("text", "");
                JsonArray extra = new JsonArray();
                JsonObject triggerPart = new JsonObject();
                triggerPart.addProperty("text", "T:" + trigger);
                triggerPart.addProperty("color", "red");
                extra.add((JsonElement)triggerPart);
                JsonObject priorityPart = new JsonObject();
                priorityPart.addProperty("text", "\nP:" + priority);
                priorityPart.addProperty("color", "green");
                extra.add((JsonElement)priorityPart);
                JsonObject subTickPart = new JsonObject();
                subTickPart.addProperty("text", "\nS:" + subTickOrder);
                subTickPart.addProperty("color", "blue");
                extra.add((JsonElement)subTickPart);
                class_2487 nbt = NBTDataManager.readFromEntity((class_1297)this.tickMarker, new class_2487());
                nbt.method_10582("text", textJson.toString());
                NBTDataManager.writeToEntity((class_1297)this.tickMarker, nbt);
            } else {
                this.tickMarker = this.summonText(world, pos.method_46558().method_1031(0.0, -0.4, 0.0), trigger, priority, subTickOrder);
            }
        }

        public void removeVisualizer() {
            if (this.tickMarker != null) {
                this.tickMarker.method_31472();
            }
        }

        private class_8113.class_8123 summonText(class_3218 world, class_243 pos, int trigger, int priority, long subTickOrder) {
            class_8113.class_8123 entity = new class_8113.class_8123(class_1299.field_42457, (class_1937)world);
            entity.method_5648(true);
            entity.method_5875(true);
            entity.method_5684(true);
            JsonObject textJson = new JsonObject();
            textJson.addProperty("text", "");
            JsonArray extra = new JsonArray();
            JsonObject triggerPart = new JsonObject();
            triggerPart.addProperty("text", "T:" + trigger);
            triggerPart.addProperty("color", "red");
            extra.add((JsonElement)triggerPart);
            JsonObject priorityPart = new JsonObject();
            priorityPart.addProperty("text", "\nP:" + priority);
            priorityPart.addProperty("color", "green");
            extra.add((JsonElement)priorityPart);
            JsonObject subTickPart = new JsonObject();
            subTickPart.addProperty("text", "\nS:" + subTickOrder);
            subTickPart.addProperty("color", "blue");
            extra.add((JsonElement)subTickPart);
            textJson.add("extra", (JsonElement)extra);
            class_2487 nbt = NBTDataManager.readFromEntity((class_1297)entity, new class_2487());
            nbt.method_10582("billboard", "center");
            nbt.method_10582("text", textJson.toString());
            nbt.method_10567("see_through", (byte)1);
            NBTDataManager.writeToEntity((class_1297)entity, nbt);
            entity.method_23327(pos.method_10216(), pos.method_10214(), pos.method_10215());
            entity.method_5780(this.tag);
            entity.method_5780("DoNotTick");
            world.method_8649((class_1297)entity);
            return entity;
        }
    }
}

