/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.waypoint;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class WaypointManager {
    public static File configFile;
    public static Set<Waypoint> waypoints;

    public static void init(MinecraftServer server) {
        File worldDir = server.method_27050(class_5218.field_24188).toFile();
        File configDir = new File(worldDir, "YACA");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        configFile = new File(configDir, "waypoints.json");
        WaypointManager.loadWaypoint();
    }

    private static void loadWaypoint() {
        try {
            if (configFile.exists()) {
                FileReader reader = new FileReader(configFile);
                Type type = new TypeToken<Set<Waypoint>>(){}.getType();
                waypoints = (Set)new Gson().fromJson((Reader)reader, type);
                reader.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveWaypoint() {
        try {
            FileWriter writer = new FileWriter(configFile);
            new GsonBuilder().setPrettyPrinting().create().toJson(waypoints, (Appendable)writer);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Waypoint getWaypoint(String name) {
        for (Waypoint waypoint : waypoints) {
            if (!waypoint.name.equals(name)) continue;
            return waypoint;
        }
        return null;
    }

    public static boolean addWaypoint(String name, class_2338 pos, String dimension) {
        for (Waypoint waypoint : waypoints) {
            if (!waypoint.name.equals(name)) continue;
            return false;
        }
        waypoints.add(new Waypoint(name, dimension, pos));
        WaypointManager.saveWaypoint();
        return true;
    }

    public static boolean delWaypoint(String name) {
        if (waypoints.removeIf(warning -> warning.name.equals(name))) {
            WaypointManager.saveWaypoint();
            return true;
        }
        return false;
    }

    static {
        waypoints = new HashSet<Waypoint>();
    }

    public static class Waypoint {
        public String name;
        public class_2338 pos;
        public String dimension;

        public Waypoint(String name, String dimension, class_2338 pos) {
            this.name = name;
            this.dimension = dimension;
            this.pos = pos;
        }
    }
}

