/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.visualizingFeatures;

import carpet.CarpetServer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import mypals.ml.features.visualizingFeatures.AbstractVisualizingManager;
import mypals.ml.features.visualizingFeatures.EntityHelper;
import mypals.ml.settings.YetAnotherCarpetAdditionRules;
import mypals.ml.utils.adapter.NBTDataManager;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_268;
import net.minecraft.class_2680;
import net.minecraft.class_2995;
import net.minecraft.class_3218;
import net.minecraft.class_8113;

public class BlockEventVisualizing
extends AbstractVisualizingManager<class_2338, BlockEventObject> {
    private static final ConcurrentHashMap<class_2338, Map.Entry<BlockEventObject, Long>> visualizers = new ConcurrentHashMap();
    private static final int SURVIVE_TIME = 50;

    @Override
    protected void storeVisualizer(class_2338 key, BlockEventObject blockEventObject) {
        visualizers.put(key, Map.entry(blockEventObject, BlockEventVisualizing.getDeleteTick(50, (class_3218)blockEventObject.tickMarker.method_73183())));
    }

    @Override
    protected void updateVisualizerEntity(BlockEventObject marker, Object data) {
        if (data instanceof Integer) {
            Integer order = (Integer)data;
            if (marker.tickMarker != null && !marker.tickMarker.method_31481()) {
                class_2487 nbt2 = NBTDataManager.readFromEntity((class_1297)marker.typeMarker, new class_2487());
                nbt2 = EntityHelper.scaleEntity(nbt2, 0.9f);
                float offset = 0.050000012f;
                marker.typeMarker.method_23327(marker.typeMarker.method_23317() + (double)offset, marker.typeMarker.method_23318() + (double)offset, marker.typeMarker.method_23321() + (double)offset);
                NBTDataManager.writeToEntity((class_1297)marker.typeMarker, nbt2);
                class_2487 nbt = NBTDataManager.readFromEntity((class_1297)marker.tickMarker, new class_2487());
                JsonObject orderPart = new JsonObject();
                JsonObject textJson = new JsonObject();
                if (marker.tickMarker.method_73183().method_8510() != marker.summonTime.longValue()) {
                    textJson.addProperty("text", "");
                    JsonArray extra = new JsonArray();
                    orderPart.addProperty("text", "[" + String.valueOf(order) + "]");
                    orderPart.addProperty("color", "green");
                    extra.add((JsonElement)orderPart);
                    textJson.add("extra", (JsonElement)extra);
                } else {
                    String existingText = nbt.method_68564("text", "");
                    JsonArray extraArray = new JsonArray();
                    JsonObject orderLine = new JsonObject();
                    orderLine.addProperty("text", "\n[" + order + "]");
                    orderLine.addProperty("color", "green");
                    try {
                        JsonElement parsed = JsonParser.parseString((String)existingText);
                        if (parsed.isJsonObject()) {
                            String baseText;
                            JsonObject existingJson = parsed.getAsJsonObject();
                            if (existingJson.has("extra") && existingJson.get("extra").isJsonArray()) {
                                JsonArray originalExtras = existingJson.getAsJsonArray("extra");
                                for (JsonElement e : originalExtras) {
                                    extraArray.add(e);
                                }
                            }
                            if (existingJson.has("text") && !(baseText = existingJson.get("text").getAsString()).isEmpty()) {
                                JsonObject base = new JsonObject();
                                base.addProperty("text", baseText);
                                extraArray.add((JsonElement)base);
                            }
                            extraArray.add((JsonElement)orderLine);
                        } else {
                            JsonObject fallback = new JsonObject();
                            fallback.addProperty("text", existingText);
                            extraArray.add((JsonElement)fallback);
                            extraArray.add((JsonElement)orderLine);
                        }
                    }
                    catch (Exception e) {
                        JsonObject fallback = new JsonObject();
                        fallback.addProperty("text", existingText);
                        extraArray.add((JsonElement)fallback);
                        extraArray.add((JsonElement)orderLine);
                    }
                    textJson = new JsonObject();
                    textJson.addProperty("text", "");
                    textJson.add("extra", (JsonElement)extraArray);
                }
                nbt.method_10582("text", textJson.toString());
                marker.tickMarker.field_6012 = 0;
                marker.typeMarker.field_6012 = 0;
                NBTDataManager.writeToEntity((class_1297)marker.tickMarker, nbt);
                visualizers.put(marker.tickMarker.method_24515(), Map.entry(marker, BlockEventVisualizing.getDeleteTick(50, (class_3218)marker.tickMarker.method_73183())));
            }
        }
    }

    @Override
    protected BlockEventObject createVisualizerEntity(class_3218 world, class_243 pos, Object data) {
        if (data instanceof Integer) {
            Integer order = (Integer)data;
            class_2338 blockPos = class_2338.method_49638((class_2374)pos);
            return new BlockEventObject(world, blockPos, order, this.getVisualizerTag());
        }
        return null;
    }

    @Override
    protected void removeVisualizerEntity(class_2338 key) {
        Map.Entry<BlockEventObject, Long> entry = visualizers.get(key);
        if (entry != null) {
            entry.getKey().removeVisualizer();
            visualizers.remove(key);
        }
    }

    @Override
    protected BlockEventObject getVisualizer(class_2338 key) {
        Map.Entry<BlockEventObject, Long> entry = visualizers.get(key);
        return entry == null ? null : entry.getKey();
    }

    @Override
    public String getVisualizerTag() {
        return "blockEventVisualize";
    }

    @Override
    protected void clearAllVisualizers() {
        visualizers.values().forEach(entry -> ((BlockEventObject)entry.getKey()).removeVisualizer());
        visualizers.clear();
    }

    @Override
    public void updateVisualizer() {
        if (!YetAnotherCarpetAdditionRules.blockEventVisualize || !CarpetServer.minecraft_server.method_54833().method_54751()) {
            return;
        }
        visualizers.forEach((pos, entry) -> {
            BlockEventObject object = (BlockEventObject)entry.getKey();
            long deleteTick = (Long)entry.getValue();
            if (deleteTick < object.tickMarker.method_73183().method_8510()) {
                object.removeVisualizer();
                visualizers.remove(pos);
            }
            class_2487 nbt = NBTDataManager.readFromEntity((class_1297)((BlockEventObject)entry.getKey()).typeMarker, new class_2487());
            float scale = EntityHelper.mapSize((int)(deleteTick - CarpetServer.minecraft_server.method_30002().method_8510()), 50, 0.9f);
            nbt = EntityHelper.scaleEntity(nbt, scale);
            NBTDataManager.writeToEntity((class_1297)((BlockEventObject)entry.getKey()).typeMarker, nbt);
            ((BlockEventObject)entry.getKey()).typeMarker.method_23327(pos.method_46558().method_10216() - (double)(scale / 2.0f), pos.method_46558().method_10214() - (double)(scale / 2.0f), pos.method_46558().method_10215() - (double)(scale / 2.0f));
        });
    }

    @Override
    public void setVisualizer(class_3218 world, class_2338 key, class_243 pos, Object data) {
        super.setVisualizer(world, key, pos, data);
    }

    private static void addMarkerToTeam(class_3218 world, String teamName, class_8113.class_8115 marker) {
        class_2995 scoreboard = world.method_14170();
        class_268 team = scoreboard.method_1153(teamName);
        if (team == null) {
            team = scoreboard.method_1171(teamName);
            team.method_1141(class_124.field_1060);
        }
        String entityName = marker.method_5845();
        scoreboard.method_1172(entityName, team);
    }

    public static class BlockEventObject {
        public String tag;
        public class_8113.class_8123 tickMarker;
        public class_8113.class_8115 typeMarker;
        public Long summonTime;

        public BlockEventObject(class_3218 world, class_2338 pos, int order, String tag) {
            this.tag = tag;
            this.setVisualizer(world, pos, order);
            this.summonTime = world.method_8510();
        }

        public void setVisualizer(class_3218 world, class_2338 pos, int order) {
            if (this.tickMarker != null && !this.tickMarker.method_31481()) {
                JsonObject textJson = new JsonObject();
                textJson.addProperty("text", "");
                JsonArray extra = new JsonArray();
                JsonObject orderPart = new JsonObject();
                orderPart.addProperty("text", String.valueOf(order));
                orderPart.addProperty("color", "green");
                extra.add((JsonElement)orderPart);
                textJson.add("extra", (JsonElement)extra);
                class_2487 nbt = NBTDataManager.readFromEntity((class_1297)this.tickMarker, new class_2487());
                nbt.method_10582("text", textJson.toString());
                NBTDataManager.writeToEntity((class_1297)this.tickMarker, nbt);
            } else {
                this.tickMarker = this.summonText(world, pos.method_46558().method_1031(0.0, -0.4, 0.0), String.valueOf(order));
            }
            if (this.typeMarker == null || this.typeMarker.method_31481()) {
                this.typeMarker = this.summonMarker((class_1937)world, pos);
            }
        }

        public void removeVisualizer() {
            if (this.tickMarker != null) {
                this.tickMarker.method_31472();
            }
            if (this.typeMarker != null) {
                this.typeMarker.method_31472();
            }
        }

        private class_8113.class_8123 summonText(class_3218 world, class_243 pos, String order) {
            class_8113.class_8123 entity = new class_8113.class_8123(class_1299.field_42457, (class_1937)world);
            entity.method_5648(true);
            entity.method_5875(true);
            entity.method_5684(true);
            JsonObject textJson = new JsonObject();
            textJson.addProperty("text", "");
            JsonArray extra = new JsonArray();
            JsonObject orderPart = new JsonObject();
            orderPart.addProperty("text", "[" + String.valueOf(order) + "]");
            orderPart.addProperty("color", "green");
            extra.add((JsonElement)orderPart);
            textJson.add("extra", (JsonElement)extra);
            class_2487 nbt = NBTDataManager.readFromEntity((class_1297)entity, new class_2487());
            nbt.method_10582("billboard", "center");
            nbt.method_10582("text", textJson.toString());
            nbt.method_10567("see_through", (byte)1);
            NBTDataManager.writeToEntity((class_1297)entity, nbt);
            entity.method_23327(pos.method_10216(), pos.method_10214() + 0.2, pos.method_10215());
            entity.method_5780(this.tag);
            entity.method_5780("DoNotTick");
            world.method_8649((class_1297)entity);
            return entity;
        }

        private class_8113.class_8115 summonMarker(class_1937 world, class_2338 pos) {
            class_8113.class_8115 entity = new class_8113.class_8115(class_1299.field_42460, world);
            float scale = 0.9f;
            class_2487 nbt = NBTDataManager.readFromEntity((class_1297)entity, new class_2487());
            nbt.method_10566("block_state", (class_2520)class_2512.method_10686((class_2680)class_2246.field_10357.method_9564()));
            nbt = EntityHelper.scaleEntity(nbt, scale);
            nbt.method_10569("glow_color_override", 0xAAFFAA);
            NBTDataManager.writeToEntity((class_1297)entity, nbt);
            entity.field_5960 = true;
            entity.method_5834(true);
            entity.method_5648(true);
            entity.method_5684(true);
            float offset = (1.0f - scale) / 2.0f;
            entity.method_23327((double)((float)pos.method_10263() + offset), (double)((float)pos.method_10264() + offset), (double)((float)pos.method_10260() + offset));
            entity.method_5780(this.tag);
            entity.method_5780("DoNotTick");
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                BlockEventVisualizing.addMarkerToTeam(serverWorld, "blockEventTeam", entity);
            }
            world.method_8649((class_1297)entity);
            return entity;
        }
    }
}

