/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.visualizingFeatures;

import carpet.CarpetServer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import mypals.ml.features.visualizingFeatures.AbstractVisualizingManager;
import mypals.ml.features.visualizingFeatures.EntityHelper;
import mypals.ml.utils.adapter.NBTDataManager;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_268;
import net.minecraft.class_2680;
import net.minecraft.class_2995;
import net.minecraft.class_3218;
import net.minecraft.class_8113;
import net.minecraft.server.MinecraftServer;

public class BlockUpdateVisualizing
extends AbstractVisualizingManager<class_2338, BlockUpdateObject> {
    private static final ConcurrentHashMap<class_2338, Map.Entry<BlockUpdateObject, Long>> visualizers = new ConcurrentHashMap();
    private static final int SURVIVE_TIME = 20;
    private static final int RANGE = 40;

    @Override
    protected void storeVisualizer(class_2338 key, BlockUpdateObject entity) {
        visualizers.put(key, Map.entry(entity, BlockUpdateVisualizing.getDeleteTick(20, (class_3218)entity.posMarker.method_73183())));
    }

    @Override
    protected void updateVisualizerEntity(BlockUpdateObject marker, Object data) {
        if (marker.posMarker != null && !marker.posMarker.method_31481() && !marker.posMarker.method_73183().method_8608()) {
            marker.posMarker.field_6012 = 0;
            class_2487 nbt = NBTDataManager.readFromEntity((class_1297)marker.posMarker, new class_2487());
            float scale = 0.9f;
            nbt = EntityHelper.scaleEntity(nbt, scale);
            NBTDataManager.writeToEntity((class_1297)marker.posMarker, nbt);
            class_2338 pos = class_2338.method_49638((class_2374)marker.posMarker.method_73189());
            marker.posMarker.method_23327(pos.method_46558().method_10216() - (double)(scale / 2.0f), pos.method_46558().method_10214() - (double)(scale / 2.0f), pos.method_46558().method_10215() - (double)(scale / 2.0f));
            visualizers.put(pos, Map.entry(marker, BlockUpdateVisualizing.getDeleteTick(20, (class_3218)marker.posMarker.method_73183())));
        }
    }

    @Override
    protected BlockUpdateObject createVisualizerEntity(class_3218 world, class_243 pos, Object data) {
        if (data instanceof UpdateType) {
            UpdateType updateType = (UpdateType)((Object)data);
            class_2338 blockPos = class_2338.method_49638((class_2374)pos);
            return new BlockUpdateObject(world, blockPos, updateType, updateType.tagName);
        }
        return null;
    }

    @Override
    protected void removeVisualizerEntity(class_2338 key) {
        Map.Entry<BlockUpdateObject, Long> entry = visualizers.get(key);
        if (entry != null) {
            entry.getKey().removeVisualizer();
            visualizers.remove(key);
        }
    }

    @Override
    protected BlockUpdateObject getVisualizer(class_2338 key) {
        Map.Entry<BlockUpdateObject, Long> entry = visualizers.get(key);
        return entry == null ? null : entry.getKey();
    }

    @Override
    public String getVisualizerTag() {
        return "blockUpdateVisualize";
    }

    @Override
    public void clearVisualizers(MinecraftServer server) {
        for (class_3218 world : server.method_3738()) {
            EntityHelper.clearWorldVisualizers(world, "NCVisualizer");
            EntityHelper.clearWorldVisualizers(world, "PPVisualizer");
            EntityHelper.clearWorldVisualizers(world, "CPVisualizer");
        }
    }

    @Override
    protected void clearAllVisualizers() {
        visualizers.values().forEach(entry -> ((BlockUpdateObject)entry.getKey()).removeVisualizer());
        visualizers.clear();
    }

    @Override
    public void updateVisualizer() {
        if (!CarpetServer.minecraft_server.method_54833().method_54751()) {
            return;
        }
        visualizers.forEach((pos, entry) -> {
            BlockUpdateObject object = (BlockUpdateObject)entry.getKey();
            long deleteTick = (Long)entry.getValue();
            if (deleteTick < object.posMarker.method_73183().method_8510()) {
                object.removeVisualizer();
                visualizers.remove(pos);
            }
            class_2487 nbt = NBTDataManager.readFromEntity((class_1297)object.posMarker, new class_2487());
            float scale = EntityHelper.mapSize((int)(deleteTick - CarpetServer.minecraft_server.method_30002().method_8510()), 20, 0.9f);
            nbt = EntityHelper.scaleEntity(nbt, scale);
            NBTDataManager.writeToEntity((class_1297)object.posMarker, nbt);
            object.posMarker.method_23327(pos.method_46558().method_10216() - (double)(scale / 2.0f), pos.method_46558().method_10214() - (double)(scale / 2.0f), pos.method_46558().method_10215() - (double)(scale / 2.0f));
        });
    }

    public void setVisualizer(class_3218 world, class_2338 pos, UpdateType updateType) {
        boolean playersNearBy = false;
        for (class_1657 player : CarpetServer.minecraft_server.method_3760().method_14571()) {
            if (!(player.method_73189().method_1022(pos.method_46558()) < 40.0)) continue;
            playersNearBy = true;
            break;
        }
        if (!playersNearBy) {
            return;
        }
        this.setVisualizer(world, pos, pos.method_46558(), (Object)updateType);
    }

    public void clearVisualizers(class_2168 source, UpdateType updateType) {
        visualizers.entrySet().removeIf(entry -> {
            if (((BlockUpdateObject)((Map.Entry)entry.getValue()).getKey()).updateType == updateType) {
                ((BlockUpdateObject)((Map.Entry)entry.getValue()).getKey()).removeVisualizer();
                return true;
            }
            return false;
        });
        EntityHelper.clearVisualizersInServer(source.method_9211(), updateType.tagName);
    }

    public List<class_2338> getVisualizersByType(UpdateType updateType) {
        return visualizers.entrySet().stream().filter(entry -> ((BlockUpdateObject)((Map.Entry)entry.getValue()).getKey()).updateType == updateType).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private static void addMarkerToTeam(class_3218 world, String teamName, class_8113.class_8115 marker) {
        class_2995 scoreboard = world.method_14170();
        class_268 team = scoreboard.method_1153(teamName);
        if (team == null) {
            team = scoreboard.method_1171(teamName);
            UpdateType updateType = BlockUpdateVisualizing.getUpdateTypeByTag(teamName);
            if (updateType != null) {
                team.method_1141(updateType.teamColor);
            } else {
                team.method_1141(class_124.field_1068);
            }
        }
        String entityName = marker.method_5845();
        scoreboard.method_1172(entityName, team);
    }

    private static UpdateType getUpdateTypeByTag(String tagName) {
        for (UpdateType type : UpdateType.values()) {
            if (!type.tagName.equals(tagName)) continue;
            return type;
        }
        return null;
    }

    public static class BlockUpdateObject {
        public final class_8113.class_8115 posMarker;
        public final UpdateType updateType;
        public final String tag;

        public BlockUpdateObject(class_3218 world, class_2338 pos, UpdateType updateType, String tag) {
            this.updateType = updateType;
            this.tag = tag;
            this.posMarker = this.summonMarker(world, pos);
        }

        private class_8113.class_8115 summonMarker(class_3218 world, class_2338 pos) {
            class_8113.class_8115 entity = new class_8113.class_8115(class_1299.field_42460, (class_1937)world);
            float scale = 0.9f;
            class_2487 nbt = NBTDataManager.readFromEntity((class_1297)entity, new class_2487());
            nbt.method_10566("block_state", (class_2520)class_2512.method_10686((class_2680)this.updateType.defaultState));
            nbt = EntityHelper.scaleEntity(nbt, scale);
            nbt.method_10569("glow_color_override", this.updateType.color);
            NBTDataManager.writeToEntity((class_1297)entity, nbt);
            entity.method_5648(true);
            entity.method_5684(true);
            entity.method_5834(true);
            entity.field_5960 = true;
            entity.method_36456(0.0f);
            entity.method_23327(pos.method_46558().method_10216() - (double)(scale / 2.0f), pos.method_46558().method_10214() - (double)(scale / 2.0f), pos.method_46558().method_10215() - (double)(scale / 2.0f));
            entity.method_5780(this.tag);
            entity.method_5780("blockUpdateVisualize");
            entity.method_5780("DoNotTick");
            BlockUpdateVisualizing.addMarkerToTeam(world, this.updateType.tagName, entity);
            world.method_8649((class_1297)entity);
            return entity;
        }

        public void removeVisualizer() {
            if (this.posMarker != null && !this.posMarker.method_31481()) {
                this.posMarker.method_31472();
            }
        }
    }

    public static enum UpdateType {
        NC("NCVisualizer", 0xFF4F00, class_124.field_1061, class_2246.field_10272.method_9564()),
        PP("PPVisualizer", 65535, class_124.field_1075, class_2246.field_10248.method_9564()),
        CP("CPVisualizer", 0xFFFFED, class_124.field_1054, class_2246.field_10049.method_9564());

        public final String tagName;
        public final int color;
        public final class_124 teamColor;
        public final class_2680 defaultState;

        private UpdateType(String tagName, int color, class_124 teamColor, class_2680 defaultState) {
            this.tagName = tagName;
            this.color = color;
            this.teamColor = teamColor;
            this.defaultState = defaultState;
        }
    }
}

