/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.visualizingFeatures;

import carpet.CarpetServer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import mypals.ml.features.visualizingFeatures.AbstractVisualizingManager;
import mypals.ml.features.visualizingFeatures.EntityHelper;
import mypals.ml.utils.adapter.NBTDataManager;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_268;
import net.minecraft.class_2680;
import net.minecraft.class_2995;
import net.minecraft.class_3218;
import net.minecraft.class_8113;

public class GameEventVisualizing
extends AbstractVisualizingManager<class_243, GameEventObject> {
    private static final ConcurrentHashMap<class_243, Map.Entry<GameEventObject, Long>> visualizers = new ConcurrentHashMap();
    private static final int SURVIVE_TIME = 30;

    @Override
    protected void clearAllVisualizers() {
        visualizers.clear();
    }

    @Override
    protected void updateVisualizerEntity(GameEventObject entity, Object data) {
    }

    @Override
    protected void storeVisualizer(class_243 key, GameEventObject entity) {
        visualizers.put(key, Map.entry(entity, GameEventVisualizing.getDeleteTick(30, (class_3218)entity.textMarker.method_73183())));
    }

    @Override
    protected GameEventObject createVisualizerEntity(class_3218 world, class_243 pos, Object data) {
        if (data instanceof String[]) {
            String[] eventData = (String[])data;
            String emitter = eventData[0];
            String type = eventData[1];
            GameEventObject object = new GameEventObject(world, pos, emitter, type, this.getVisualizerTag());
            return object;
        }
        return null;
    }

    @Override
    protected void removeVisualizerEntity(class_243 key) {
        Map.Entry<GameEventObject, Long> entry = visualizers.get(key);
        if (entry != null) {
            entry.getKey().removeVisualizer();
            visualizers.remove(key);
        }
    }

    @Override
    protected GameEventObject getVisualizer(class_243 key) {
        Map.Entry<GameEventObject, Long> entry = visualizers.get(key);
        return entry == null ? null : entry.getKey();
    }

    @Override
    public String getVisualizerTag() {
        return "gameEventVisualize";
    }

    @Override
    public void updateVisualizer() {
        if (!CarpetServer.minecraft_server.method_54833().method_54751()) {
            return;
        }
        visualizers.forEach((pos, entry) -> {
            GameEventObject object = (GameEventObject)entry.getKey();
            long time = (Long)entry.getValue();
            if (time < object.textMarker.method_73183().method_8510()) {
                object.removeVisualizer();
                visualizers.remove(pos);
            }
        });
    }

    private static void addMarkerToTeam(class_3218 world, String teamName, class_8113.class_8115 marker) {
        class_2995 scoreboard = world.method_14170();
        class_268 team = scoreboard.method_1153(teamName);
        if (team == null) {
            team = scoreboard.method_1171(teamName);
            team.method_1141(class_124.field_1075);
        }
        String entityName = marker.method_5845();
        scoreboard.method_1172(entityName, team);
    }

    public static class GameEventObject {
        public String type;
        public String tag;
        public class_8113.class_8123 textMarker;
        public class_8113.class_8115 posMarker;

        public GameEventObject(class_3218 world, class_243 pos, String emitter, String type, String tag) {
            this.tag = tag;
            this.setVisualizer(world, pos, emitter, type);
        }

        public void setVisualizer(class_3218 world, class_243 pos, String trigger, String type) {
            if (this.textMarker != null && !this.textMarker.method_31481()) {
                class_2499 nbtList = new class_2499();
                HashMap<String, class_2519> triggerPart = new HashMap<String, class_2519>();
                triggerPart.put("text", class_2519.method_23256((String)String.valueOf(trigger)));
                triggerPart.put("color", class_2519.method_23256((String)"blue"));
                class_2487 textComponent = new class_2487(triggerPart);
                nbtList.add((Object)textComponent);
                HashMap<String, class_2519> typePart = new HashMap<String, class_2519>();
                typePart.put("text", class_2519.method_23256((String)("\n" + type)));
                typePart.put("color", class_2519.method_23256((String)"blue"));
                textComponent = new class_2487(typePart);
                nbtList.add((Object)textComponent);
                class_2487 nbt = NBTDataManager.readFromEntity((class_1297)this.textMarker, new class_2487());
                nbt.method_10566("text", (class_2520)nbtList);
                NBTDataManager.writeToEntity((class_1297)this.textMarker, nbt);
            } else {
                this.textMarker = this.summonText(world, pos, trigger, type);
            }
            if (this.posMarker == null) {
                this.posMarker = this.summonMarker((class_1937)world, pos);
            }
        }

        public void removeVisualizer() {
            if (this.textMarker != null) {
                this.textMarker.method_31472();
            }
            if (this.posMarker != null) {
                this.posMarker.method_31472();
            }
        }

        private class_8113.class_8123 summonText(class_3218 world, class_243 pos, String trigger, String type) {
            class_8113.class_8123 entity = new class_8113.class_8123(class_1299.field_42457, (class_1937)world);
            entity.method_5648(true);
            entity.method_5875(true);
            entity.method_5684(true);
            class_2499 nbtList = new class_2499();
            HashMap<String, class_2519> triggerPart = new HashMap<String, class_2519>();
            triggerPart.put("text", class_2519.method_23256((String)trigger));
            triggerPart.put("color", class_2519.method_23256((String)"blue"));
            class_2487 textComponent = new class_2487(triggerPart);
            nbtList.add((Object)textComponent);
            HashMap<String, class_2519> typePart = new HashMap<String, class_2519>();
            typePart.put("text", class_2519.method_23256((String)("\n" + type)));
            typePart.put("color", class_2519.method_23256((String)"blue"));
            textComponent = new class_2487(typePart);
            nbtList.add((Object)textComponent);
            class_2487 nbt = NBTDataManager.readFromEntity((class_1297)entity, new class_2487());
            nbt.method_10582("billboard", "center");
            nbt.method_10566("text", (class_2520)nbtList);
            nbt.method_10567("see_through", (byte)1);
            NBTDataManager.writeToEntity((class_1297)entity, nbt);
            entity.method_23327(pos.method_10216(), pos.method_10214(), pos.method_10215());
            entity.method_5780(this.tag);
            entity.method_5780("DoNotTick");
            world.method_8649((class_1297)entity);
            return entity;
        }

        private class_8113.class_8115 summonMarker(class_1937 world, class_243 pos) {
            class_8113.class_8115 entity = new class_8113.class_8115(class_1299.field_42460, world);
            float scale = 0.3f;
            class_2487 nbt = NBTDataManager.readFromEntity((class_1297)entity, new class_2487());
            nbt.method_10566("block_state", (class_2520)class_2512.method_10686((class_2680)class_2246.field_9982.method_9564()));
            nbt = EntityHelper.scaleEntity(nbt, scale);
            nbt.method_10569("glow_color_override", 0xAAAAFF);
            NBTDataManager.writeToEntity((class_1297)entity, nbt);
            entity.field_5960 = true;
            entity.method_5834(true);
            entity.method_23327(pos.method_10216() - (double)(scale / 2.0f), pos.method_10214() - (double)(scale / 2.0f) - (double)0.1f, pos.method_10215() - (double)(scale / 2.0f));
            entity.method_5780(this.tag);
            entity.method_5780("DoNotTick");
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                GameEventVisualizing.addMarkerToTeam(serverWorld, "gameEventTeam", entity);
            }
            entity.method_5648(true);
            world.method_8649((class_1297)entity);
            return entity;
        }
    }
}

