/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.settings;

import carpet.api.settings.CarpetRule;
import carpet.api.settings.Validator;
import java.util.Objects;
import mypals.ml.YetAnotherCarpetAdditionServer;
import mypals.ml.features.visualizingFeatures.AbstractVisualizingManager;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class RuleValidators {

    public static class CLEAR_VISUALIZER
    extends Validator<Boolean> {
        public Boolean validate(@Nullable class_2168 serverCommandSource, CarpetRule<Boolean> carpetRule, Boolean newValue, String s) {
            if (!newValue.booleanValue()) {
                if (serverCommandSource == null) {
                    return newValue;
                }
                String visualizeName = carpetRule.name();
                for (AbstractVisualizingManager abstractVisualizingManager : YetAnotherCarpetAdditionServer.allVisualizers) {
                    if (!Objects.equals(abstractVisualizingManager.getVisualizerTag(), visualizeName)) continue;
                    abstractVisualizingManager.clearVisualizers(serverCommandSource.method_9211());
                }
            }
            return newValue;
        }
    }

    public static class GRID_WORLD_SETTINGS_VALIDATOR
    extends Validator<String> {
        static String DEFAULT_PRESET = "minecraft:white_stained_glass;minecraft:black_stained_glass;1";

        public String validate(@Nullable class_2168 source, CarpetRule<String> changingRule, String newValue, String userInput) {
            String[] parts = newValue.split(";");
            if (newValue.equals("off")) {
                return "off";
            }
            if (!class_7923.field_41175.method_10250(class_2960.method_60656((String)parts[0].replace("minecraft:", ""))) || !class_7923.field_41175.method_10250(class_2960.method_60656((String)parts[1].replace("minecraft:", "")))) {
                if (source != null) {
                    source.method_9213(class_2561.method_30163((String)("Invalid block IDs: " + parts[0] + " or " + parts[1])));
                }
                return DEFAULT_PRESET;
            }
            try {
                int value = Integer.parseInt(parts[2]);
                return parts[0].replace("minecraft:", "") + ";" + parts[1].replace("minecraft:", "") + ";" + Math.max(1, value);
            }
            catch (NumberFormatException e) {
                if (source != null) {
                    source.method_9213(class_2561.method_30163((String)("Invalid size value: " + parts[2] + " using default(1).")));
                }
                return parts[0] + ";" + parts[1] + ";1";
            }
        }
    }

    public static class MOVING_PISTON_SPEED_VALIDATOR
    extends Validator<Float> {
        public Float validate(@Nullable class_2168 source, CarpetRule<Float> changingRule, Float newValue, String userInput) {
            return Float.valueOf(Math.max(0.0f, Math.min(newValue.floatValue(), 1.0f)));
        }
    }
}

