/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.Screen.CountersViewer;

import java.awt.Color;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.class_1767;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5676;
import org.joml.Matrix3x2fStack;

public class CounterViewerScreen
extends class_437
implements class_4069 {
    private final Map<String, Map<String, String>> data;
    private final List<String> timestamps;
    private final List<String> counterNames;
    private ConcurrentHashMap<String, List<Point>> counterPoints;
    private static Map<String, Integer> COLORS = new HashMap<String, Integer>();
    private class_5676 viewModeButton;
    public static ViewMode viewMode = ViewMode.TOTAL;
    public int maxCountedValue = 0;
    public int finalMaxCount = 0;

    public CounterViewerScreen(Map<String, Map<String, String>> data) {
        super((class_2561)class_2561.method_43470((String)"Hopper Counter Data Viwer"));
        this.data = data;
        this.timestamps = new ArrayList<String>(data.keySet()).stream().sorted().collect(Collectors.toList());
        this.counterNames = data.values().stream().flatMap(map -> map.keySet().stream()).distinct().sorted().collect(Collectors.toList());
        this.counterPoints = this.computeCounterPoints();
    }

    private ConcurrentHashMap<String, List<Point>> computeCounterPoints() {
        List<Object> counterPoints;
        ConcurrentHashMap<String, List<Point>> points = new ConcurrentHashMap<String, List<Point>>();
        double maxCountedValue = 1.0;
        if (viewMode == ViewMode.TOTAL) {
            for (String counter : this.counterNames) {
                counterPoints = new ArrayList();
                for (i = 0; i < this.timestamps.size(); ++i) {
                    double value;
                    String timestamp = this.timestamps.get(i);
                    Map<String, String> map = this.data.get(timestamp);
                    String valueStr = map.getOrDefault(counter, "0");
                    try {
                        value = Integer.parseInt(valueStr);
                    }
                    catch (NumberFormatException e) {
                        value = 0.0;
                    }
                    double x = (double)i / (double)Math.max(1, this.timestamps.size() - 1);
                    double y = value / maxCountedValue;
                    counterPoints.add(new Point(x, y, valueStr, timestamp));
                }
                points.put(counter, counterPoints);
            }
        } else {
            for (String counter : this.counterNames) {
                counterPoints = new ArrayList();
                for (i = 0; i < this.timestamps.size(); ++i) {
                    double value = 0.0;
                    String currTimestamp = "";
                    if (i > 0) {
                        currTimestamp = this.timestamps.get(i);
                        String prevTimestamp = this.timestamps.get(i - 1);
                        Map<String, String> currCounters = this.data.get(currTimestamp);
                        Map<String, String> prevCounters = this.data.get(prevTimestamp);
                        try {
                            double currValue = Integer.parseInt(currCounters.getOrDefault(counter, "0").split("\\^\\^\\^")[0]);
                            double prevValue = Integer.parseInt(prevCounters.getOrDefault(counter, "0").split("\\^\\^\\^")[0]);
                            value = Math.max(0.0, currValue - prevValue);
                        }
                        catch (NumberFormatException | DateTimeParseException e) {
                            value = 0.0;
                        }
                    }
                    double x = (double)i / (double)Math.max(1, this.timestamps.size() - 1);
                    double y = maxCountedValue > 0.0 ? value / maxCountedValue : 0.0;
                    String origVal = ((Map)this.data.getOrDefault(currTimestamp, new HashMap())).getOrDefault(counter, "0^^^ERROR!@@");
                    String newVal = value + "^^^" + origVal.split("\\^\\^\\^")[1];
                    counterPoints.add(new Point(x, y, newVal, currTimestamp));
                }
                points.put(counter, counterPoints);
            }
        }
        maxCountedValue = points.values().stream().flatMap(Collection::stream).mapToDouble(p -> Math.abs(Double.parseDouble(p.value.split("\\^\\^\\^")[0]))).max().orElse(1.0);
        this.finalMaxCount = (int)maxCountedValue;
        for (String counter : points.keySet()) {
            counterPoints = points.get(counter);
            ArrayList<Point> normalizedPoints = new ArrayList<Point>();
            for (Point point : counterPoints) {
                double count = Double.parseDouble(point.value.split("\\^\\^\\^")[0]);
                double y = maxCountedValue > 0.0 ? count / maxCountedValue : 0.0;
                normalizedPoints.add(new Point(point.x, y, point.value, point.time));
            }
            points.put(counter, normalizedPoints);
        }
        return points;
    }

    protected void method_25426() {
        Arrays.stream(class_1767.values()).forEach(color -> {
            int colorValue = color.method_16357();
            COLORS.put(color.method_7792(), colorValue);
        });
        this.viewModeButton = (class_5676)this.method_37063((class_364)class_5676.method_32606(viewMode -> class_2561.method_43471((String)viewMode.getKey())).method_32624((Object[])ViewMode.values()).method_32619((Object)CounterViewerScreen.viewMode).method_32617(this.field_22789 / 2 - 100, this.field_22790 - 30, 100, 20, (class_2561)class_2561.method_43470((String)"Mode"), (button, newViewMode) -> {
            viewMode = newViewMode;
            this.counterPoints = this.computeCounterPoints();
        }));
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), button -> this.method_25419()).method_46434(this.field_22789 / 2, this.field_22790 - 30, 100, 20).method_46431());
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int i;
        super.method_25394(context, mouseX, mouseY, delta);
        Matrix3x2fStack poseStack = context.method_51448();
        int chartX = 40;
        int chartY = 50;
        int chartWidth = this.field_22789 - 100;
        int chartHeight = this.field_22790 - 100;
        int axisColor = -1;
        boolean alreadyShowingTooltip = false;
        for (i = 0; i < this.counterNames.size(); ++i) {
            String counter = this.counterNames.get(i);
            List<Point> points = this.counterPoints.get(counter);
            int color = new Color(COLORS.getOrDefault(counter, -1)).getRGB();
            for (int j = 1; j < points.size(); ++j) {
                Point p1 = points.get(j - 1);
                Point p2 = points.get(j);
                int x1 = chartX + (int)(p1.x * (double)chartWidth);
                int y1 = chartY + chartHeight - (int)(p1.y * (double)chartHeight);
                int x2 = chartX + (int)(p2.x * (double)chartWidth);
                int y2 = chartY + chartHeight - (int)(p2.y * (double)chartHeight);
                Line l = new Line(x1, y1, x2, y2, 1, color, p2.value, p2.time);
                l.render(poseStack, context);
                alreadyShowingTooltip = l.endPoint.render(1, context, color, mouseX, mouseY, alreadyShowingTooltip);
                context.method_25294(x1 - 1, y1 - 1, x1 + 1, y1 + 1, color);
            }
            context.method_51433(this.field_22793, counter, chartWidth + chartX + 5, chartHeight - 20 - i * 7, color, true);
        }
        if (!this.timestamps.isEmpty()) {
            context.method_51433(this.field_22793, this.timestamps.getFirst().substring(11, 16), chartX, chartY + chartHeight + 10, axisColor, true);
            context.method_51433(this.field_22793, this.timestamps.getLast().substring(11, 16), chartX + chartWidth, chartY + chartHeight + 10, axisColor, true);
        }
        for (i = 0; i <= 5; ++i) {
            int value = (int)((double)i / 5.0 * (double)this.finalMaxCount);
            int y = chartY + chartHeight - i * chartHeight / 5;
            context.method_51433(this.field_22793, String.valueOf(value), chartX - 30, y - 5, axisColor, false);
        }
        context.method_25294(chartX, chartY + chartHeight - 1, chartX + chartWidth, chartY + chartHeight, axisColor);
        context.method_25294(chartX, chartY, chartX + 1, chartY + chartHeight, axisColor);
        int mx = Math.min(chartX + chartWidth, Math.max(chartX, mouseX));
        int my = Math.min(chartY + chartHeight, Math.max(chartY, mouseY));
        context.method_25294(chartX, my - 1, chartX + chartWidth, my + 1, 0xFFFFFFF);
        context.method_25294(mx - 1, chartY, mx + 1, chartY + chartHeight, 0xFFFFFFF);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, -1);
    }

    public boolean method_25421() {
        return false;
    }

    public static enum ViewMode {
        GROWTH("screen.counterViewr.growth"),
        TOTAL("screen.counterViewr.total");

        private String key;

        private ViewMode(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    private static class Point {
        final double x;
        final double y;
        final String value;
        final String time;

        Point(double x, double y, String value, String time) {
            this.x = x;
            this.y = y;
            this.value = value;
            this.time = time;
        }
    }

    private static class Line {
        public final RenderPoint startPoint;
        public final RenderPoint endPoint;
        private final int color;
        private final int lineWidth;
        private float lineLength;
        private float rotationAngleInDeg;

        public Line(RenderPoint start, RenderPoint end, int lineWidth, int color) {
            this.startPoint = start;
            this.endPoint = end;
            this.lineWidth = Math.abs(lineWidth);
            this.color = color;
            this.calculateLine();
        }

        public Line(int x1, int y1, int x2, int y2, int lineWidth, int color, String data, String time) {
            this(new RenderPoint(x1, y1, data, time), new RenderPoint(x2, y2, data, time), lineWidth, color);
        }

        public void render(Matrix3x2fStack poseStack, class_332 drawContext) {
            poseStack.pushMatrix();
            poseStack.translate((float)this.startPoint.x, (float)this.startPoint.y);
            poseStack.rotate(this.rotationAngleInDeg);
            if (this.lineWidth % 2 == 0 || this.lineWidth == 1) {
                drawContext.method_25294(0, 0, (int)this.lineLength + 1, this.lineWidth, this.color);
            } else {
                drawContext.method_25294(0, -this.lineWidth / 2, (int)this.lineLength + 1, this.lineWidth / 2, this.color);
            }
            poseStack.popMatrix();
        }

        private void calculateLine() {
            int deltaX = this.endPoint.x - this.startPoint.x;
            int deltaY = this.startPoint.y - this.endPoint.y;
            this.lineLength = (float)Math.sqrt(Math.pow(deltaX, 2.0) + Math.pow(deltaY, 2.0));
            this.rotationAngleInDeg = (float)Math.toDegrees(Math.atan2(deltaY, deltaX)) * -1.0f;
        }
    }

    private static class RenderPoint {
        public final int x;
        public final int y;
        public String data;
        public String time;

        public RenderPoint(int x, int y, String data, String time) {
            this.x = x;
            this.y = y;
            this.data = data;
            this.time = time;
        }

        public boolean hovered(int mouseX, int mouseY, int size, class_332 drawContext, int color) {
            return mouseX < this.x + size + 1 && mouseY < this.y + size + 1 && mouseX > this.x - size - 1 && mouseY > this.y - size - 1;
        }

        public boolean render(int size, class_332 drawContext, int color, int mouseX, int mouseY, boolean alreadyShowingTooltip) {
            drawContext.method_25294(this.x + size + 1, this.y + size + 1, this.x - size - 1, this.y - size - 1, new Color(color).darker().getRGB());
            drawContext.method_25294(this.x + size, this.y + size, this.x - size, this.y - size, color);
            if (this.hovered(mouseX, mouseY, size, drawContext, color)) {
                if (alreadyShowingTooltip) {
                    return alreadyShowingTooltip;
                }
                ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
                ArrayList items = new ArrayList();
                tooltip.add(class_2561.method_43470((String)(class_2561.method_43471((String)viewMode.getKey()).getString() + ": " + this.data.split("\\^\\^\\^")[0])));
                tooltip.add(class_2561.method_43470((String)("Time: " + this.time.substring(11, 22))));
                Arrays.stream(this.data.split("\\^\\^\\^")[1].split("@@")).forEach(s -> {
                    if (!s.isEmpty()) {
                        tooltip.add(class_2561.method_43470((String)s.split(" t")[0]));
                    }
                });
                drawContext.method_51434(class_310.method_1551().field_1772, tooltip, mouseX, mouseY);
                return true;
            }
            return alreadyShowingTooltip;
        }
    }
}

