/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.waypoint;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.HashSet;
import java.util.Set;
import mypals.ml.features.waypoint.WaypointManager;
import mypals.ml.utils.adapter.ClickEvent;
import mypals.ml.utils.adapter.HoverEvent;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class WayPointCommand {
    private static final SuggestionProvider<class_2168> WAYPOINT_SUGGESTIONS = (context, builder) -> {
        HashSet<String> names = new HashSet<String>();
        for (WaypointManager.Waypoint waypoint : WaypointManager.waypoints) {
            names.add(waypoint.name);
        }
        return class_2172.method_9265(names, (SuggestionsBuilder)builder);
    };

    public static void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"waypoint").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"save").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            class_3218 world = player.method_51469();
            class_2338 pos = player.method_24515();
            WaypointManager.addWaypoint(name, pos, world.method_27983().method_29177().method_12832());
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Saved waypoint '" + name + "' at " + String.valueOf(pos))), false);
            return 1;
        })).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(context -> {
            class_2338 pos = class_2262.method_48299((CommandContext)context, (String)"pos");
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            class_3218 world = player.method_51469();
            WaypointManager.addWaypoint(name, pos, world.method_27983().method_29177().method_12832());
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Saved waypoint '" + name + "' at " + String.valueOf(pos))), false);
            return 1;
        }))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(WAYPOINT_SUGGESTIONS).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            if (WaypointManager.delWaypoint(name)) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Removed waypoint '" + name + "'")), false);
            } else {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Waypoint '" + name + "' does not exist.")));
            }
            return 1;
        })))).then(class_2170.method_9247((String)"tp").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(WAYPOINT_SUGGESTIONS).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            if (player != null) {
                WaypointManager.Waypoint waypoint = WaypointManager.getWaypoint(name);
                if (waypoint != null) {
                    class_2338 pos = waypoint.pos;
                    class_3218 world = player.method_5682().method_3847(class_3218.field_25179);
                    switch (waypoint.dimension) {
                        case "overworld": {
                            world = player.method_5682().method_3847(class_3218.field_25179);
                            break;
                        }
                        case "the_nether": {
                            world = player.method_5682().method_3847(class_3218.field_25180);
                            break;
                        }
                        case "the_end": {
                            world = player.method_5682().method_3847(class_3218.field_25181);
                        }
                    }
                    player.method_48105(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, Set.of(), player.method_36454(), player.method_36455(), false);
                }
            } else {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Waypoint '" + name + "' does not exist.")));
            }
            return 1;
        })))).then(class_2170.method_9247((String)"list").executes(ctx -> {
            if (WaypointManager.waypoints.isEmpty()) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"No waypoints saved."), false);
            } else {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Waypoints:").method_27692(class_124.field_1065), false);
                for (WaypointManager.Waypoint waypoint : WaypointManager.waypoints) {
                    class_5250 clickable = class_2561.method_43470((String)("\u2022 [" + waypoint.name + "]")).method_27694(style -> style.method_10977(class_124.field_1075).method_10958(ClickEvent.runCommand("/waypoint tp " + waypoint.name)).method_10949(HoverEvent.showText((class_2561)class_2561.method_43470((String)("Click to teleport to " + waypoint.name)))));
                    ((class_2168)ctx.getSource()).method_9226(() -> WayPointCommand.lambda$registerCommand$12((class_2561)clickable), false);
                }
            }
            return 1;
        })));
    }

    private static /* synthetic */ class_2561 lambda$registerCommand$12(class_2561 clickable) {
        return clickable;
    }
}

