/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.translations;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import mypals.ml.YetAnotherCarpetAdditionServer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_3518;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class YACALanguageUtil {
    private static final Gson GSON = new Gson();
    private static final Map<String, Map<String, String>> TRANSLATION_CACHE = new HashMap<String, Map<String, String>>();

    public static String getTranslation(String lang, String key, @Nullable String originalName) {
        Map<String, String> translations;
        boolean noTranslations = false;
        try {
            translations = YACALanguageUtil.getTranslations(lang);
        }
        catch (Exception e) {
            translations = YACALanguageUtil.getTranslations("en_us");
            noTranslations = true;
        }
        String translation = translations.get(key);
        if (translation != null) {
            return originalName == null ? translation : translation + "```" + originalName;
        }
        if (!lang.equals("en_us") && !noTranslations && (translation = (translations = YACALanguageUtil.getTranslations("en_us")).get(key)) != null) {
            return translation + "```";
        }
        return key.replace("carpet.rule.", "").replace(".name", "").replace(".desc", "");
    }

    private static Map<String, String> getTranslations(String lang) {
        String cacheKey = lang;
        if (TRANSLATION_CACHE.containsKey(cacheKey)) {
            return TRANSLATION_CACHE.get(cacheKey);
        }
        HashMap<String, String> translations = new HashMap<String, String>();
        String carpetPath = String.format("assets/carpet/lang/%s.json", lang);
        YACALanguageUtil.loadTranslationsFromPath("carpet", carpetPath, translations);
        for (CarpetExtension ext : CarpetServer.extensions) {
            Map extMappings = ext.canHasTranslations(lang);
            if (extMappings == null) continue;
            boolean warned = false;
            for (Map.Entry entry : extMappings.entrySet()) {
                Object key2 = (String)entry.getKey();
                if (!((String)key2).startsWith("carpet.")) {
                    if (((String)key2).startsWith("rule.")) {
                        key2 = "carpet.rule." + ((String)key2).substring(5);
                    } else if (((String)key2).startsWith("category.")) {
                        key2 = "carpet.category." + ((String)key2).substring(9);
                    }
                    if (!warned && !((String)key2).equals(entry.getKey())) {
                        YetAnotherCarpetAdditionServer.LOGGER.warn("Found outdated translation keys in extension '{}'! These won't be supported in a later Carpet version! Mapped key: {} -> {}", new Object[]{ext.getClass().getName(), entry.getKey(), key2});
                        warned = true;
                    }
                }
                translations.putIfAbsent((String)key2, (String)entry.getValue());
            }
        }
        translations.keySet().removeIf(key -> {
            if (key.startsWith("//")) {
                YetAnotherCarpetAdditionServer.LOGGER.warn("Found translation key starting with //: '{}'. This is deprecated, consider using GSON lenient mode with regular comments.", key);
                return true;
            }
            return false;
        });
        TRANSLATION_CACHE.put(cacheKey, translations);
        return translations;
    }

    private static void loadTranslationsFromPath(String namespace, String path, Map<String, String> translations) {
        block10: {
            try {
                Path resourcePath = ((ModContainer)FabricLoader.getInstance().getModContainer(namespace).orElse(null)).findPath(path).orElse(null);
                if (resourcePath != null && Files.exists(resourcePath, new LinkOption[0])) {
                    String jsonContent = Files.readString(resourcePath, StandardCharsets.UTF_8);
                    JsonObject jsonObject = (JsonObject)GSON.fromJson(jsonContent, JsonObject.class);
                    jsonObject.entrySet().forEach(entry -> {
                        if (!((String)entry.getKey()).startsWith("//")) {
                            translations.putIfAbsent((String)entry.getKey(), class_3518.method_15253((JsonObject)jsonObject, (String)((String)entry.getKey()), (String)((String)entry.getKey())));
                        }
                    });
                    break block10;
                }
                try (InputStream inputStream = YACALanguageUtil.class.getClassLoader().getResourceAsStream(path);){
                    if (inputStream != null) {
                        String jsonContent = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                        JsonObject jsonObject = (JsonObject)GSON.fromJson(jsonContent, JsonObject.class);
                        jsonObject.entrySet().forEach(entry -> {
                            if (!((String)entry.getKey()).startsWith("//")) {
                                translations.putIfAbsent((String)entry.getKey(), class_3518.method_15253((JsonObject)jsonObject, (String)((String)entry.getKey()), (String)((String)entry.getKey())));
                            }
                        });
                    }
                }
            }
            catch (IOException e) {
                YetAnotherCarpetAdditionServer.LOGGER.warn("Failed to load language file: {} for namespace: {}, error: {}", new Object[]{path, namespace, e.getMessage()});
            }
        }
    }

    public static void clearCache() {
        TRANSLATION_CACHE.clear();
    }
}

