/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.amecs;

import de.siphalor.amecs.api.AmecsKeyBinding;
import de.siphalor.amecs.api.KeyModifiers;
import de.siphalor.amecs.impl.MetaOptions;
import de.siphalor.amecs.impl.duck.IKeyBindingEntry;
import de.siphalor.amecs.keybinding.SkinLayerKeyBinding;
import de.siphalor.amecs.keybinding.ToggleAutoJumpKeyBinding;
import de.siphalor.amecs.mixin.ControlsListWidgetKeyBindingEntryAccessor;
import java.util.Arrays;
import java.util.Locale;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import net.minecraft.class_459;
import net.minecraft.class_5251;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class Amecs
implements ClientModInitializer {
    public static final KeyModifiers CURRENT_MODIFIERS = new KeyModifiers();
    public static boolean TRIGGER_KEYBINDING_ON_SCROLL = true;
    public static final String KEY_PREFIX = "amecs";
    public static final String MOD_NAME_SHORT = "Amecs";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Amecs");
    private static final String SKIN_LAYER_CATEGORY = "amecs.key.categories.skin_layers";
    @Nullable
    public static class_304 ESCAPE_KEYBINDING = null;

    public static String makeKeyID(String keyName) {
        return "key.amecs." + keyName;
    }

    public static boolean isMac() {
        return System.getProperty("os.name").toLowerCase().contains("mac");
    }

    public static void registerAutoJumpKeybind() {
        if (MetaOptions.get().autoJumpKeybind) {
            KeyBindingHelper.registerKeyBinding((class_304)new ToggleAutoJumpKeyBinding(class_2960.method_60655((String)KEY_PREFIX, (String)"toggle_auto_jump"), class_3675.class_307.field_1668, 66, "key.categories.movement", new KeyModifiers()));
        }
    }

    public static void registerSkinKeybinds() {
        if (MetaOptions.get().skinKeybinds) {
            Arrays.stream(class_1664.values()).map(playerModelPart -> new SkinLayerKeyBinding(class_2960.method_60655((String)KEY_PREFIX, (String)("toggle_" + playerModelPart.method_7429().toLowerCase(Locale.ENGLISH))), class_3675.class_307.field_1668, -1, SKIN_LAYER_CATEGORY, (class_1664)playerModelPart)).forEach(KeyBindingHelper::registerKeyBinding);
        }
    }

    public static void registerEscapeKeybind() {
        if (MetaOptions.get().escapeKeybind) {
            ESCAPE_KEYBINDING = KeyBindingHelper.registerKeyBinding((class_304)new AmecsKeyBinding(class_2960.method_60655((String)KEY_PREFIX, (String)"alternative_escape"), class_3675.class_307.field_1668, -1, "key.categories.ui", new KeyModifiers()));
        }
    }

    public static void sendToggleMessage(class_1657 playerEntity, boolean value, class_2561 option) {
        playerEntity.method_7353((class_2561)class_2561.method_43469((String)("amecs.toggled." + (value ? "on" : "off")), (Object[])new Object[]{option}), true);
    }

    public static boolean entryKeyMatches(class_459.class_462 entry, String keyFilter) {
        if (keyFilter == null) {
            return true;
        }
        return switch (keyFilter) {
            case "" -> ((IKeyBindingEntry)entry).amecs$getKeyBinding().method_1415();
            case "%" -> {
                if (((ControlsListWidgetKeyBindingEntryAccessor)entry).getEditButton().method_25369().method_10866().method_10973() == class_5251.method_27718((class_124)class_124.field_1061)) {
                    yield true;
                }
                yield false;
            }
            default -> StringUtils.containsIgnoreCase((CharSequence)((IKeyBindingEntry)entry).amecs$getKeyBinding().method_16007().getString(), (CharSequence)keyFilter);
        };
    }

    public void onInitializeClient() {
        MetaOptions.load(false);
        MetaOptions.registerCommand();
        Amecs.registerAutoJumpKeybind();
        Amecs.registerSkinKeybinds();
        Amecs.registerEscapeKeybind();
    }
}

