/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.amecs.api;

import de.siphalor.amecs.Amecs;
import de.siphalor.amecs.api.AmecsKeyBinding;
import de.siphalor.amecs.api.KeyModifiers;
import de.siphalor.amecs.impl.KeyBindingManager;
import de.siphalor.amecs.impl.duck.IKeyBinding;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_304;
import net.minecraft.class_3675;

@Environment(value=EnvType.CLIENT)
public class KeyBindingUtils {
    public static final int MOUSE_SCROLL_UP = 512;
    public static final int MOUSE_SCROLL_DOWN = 513;
    public static final int MOUSE_SCROLL_LEFT = 514;
    public static final int MOUSE_SCROLL_RIGHT = 515;
    @Deprecated
    private static double lastScrollAmountY = 0.0;
    private static Map<String, class_304> idToKeyBindingMap;

    private KeyBindingUtils() {
    }

    @Deprecated
    public static double getLastScrollAmount() {
        return lastScrollAmountY;
    }

    @Deprecated
    public static void setLastScrollAmount(double lastScrollAmountY) {
        KeyBindingUtils.lastScrollAmountY = lastScrollAmountY;
    }

    @Deprecated
    public static class_3675.class_306 getKeyFromScroll(double deltaY) {
        return class_3675.class_307.field_1672.method_1447(deltaY > 0.0 ? 512 : 513);
    }

    public static class_3675.class_306 getKeyFromVerticalScroll(double deltaY) {
        if (deltaY == 0.0) {
            return null;
        }
        return class_3675.class_307.field_1672.method_1447(deltaY > 0.0 ? 512 : 513);
    }

    public static class_3675.class_306 getKeyFromHorizontalScroll(double deltaX) {
        if (deltaX == 0.0) {
            return null;
        }
        return class_3675.class_307.field_1672.method_1447(deltaX > 0.0 ? 515 : 514);
    }

    public static Map<String, class_304> getIdToKeyBindingMap() {
        if (idToKeyBindingMap == null) {
            try {
                Method method = class_304.class.getDeclaredMethod("amecs$getIdToKeyBindingMap", new Class[0]);
                method.setAccessible(true);
                idToKeyBindingMap = (Map)method.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                Amecs.LOGGER.error("Failed to get access to key bindings", (Throwable)e);
            }
        }
        return idToKeyBindingMap;
    }

    public static boolean unregisterKeyBinding(class_304 keyBinding) {
        return KeyBindingUtils.unregisterKeyBinding(keyBinding.method_1431());
    }

    public static boolean unregisterKeyBinding(String id) {
        class_304 keyBinding = KeyBindingUtils.getIdToKeyBindingMap().remove(id);
        return KeyBindingManager.unregister(keyBinding);
    }

    public static boolean registerHiddenKeyBinding(class_304 keyBinding) {
        return KeyBindingManager.register(keyBinding);
    }

    public static KeyModifiers getBoundModifiers(class_304 keyBinding) {
        return ((IKeyBinding)keyBinding).amecs$getKeyModifiers();
    }

    public static KeyModifiers getDefaultModifiers(class_304 keyBinding) {
        if (keyBinding instanceof AmecsKeyBinding) {
            return ((AmecsKeyBinding)keyBinding).getDefaultModifiers();
        }
        return KeyModifiers.NO_MODIFIERS;
    }

    public static void resetBoundModifiers(class_304 keyBinding) {
        ((IKeyBinding)keyBinding).amecs$getKeyModifiers().unset();
        if (keyBinding instanceof AmecsKeyBinding) {
            ((AmecsKeyBinding)keyBinding).resetKeyBinding();
        }
    }
}

