/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.amecs.api;

import de.siphalor.amecs.Amecs;
import de.siphalor.amecs.impl.ModifierPrefixTextProvider;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3675;
import org.apache.commons.lang3.ArrayUtils;

@Environment(value=EnvType.CLIENT)
public enum KeyModifier {
    NONE("none", -1, new int[0]),
    ALT("alt", 0, 342, 346),
    SHIFT("shift", 2, 340, 344),
    CONTROL("control", 1, 341, 345),
    SUPER("super", 3, 343, 347);

    public static final KeyModifier[] VALUES;
    public final String stringID;
    public final String name;
    public final int id;
    public final ModifierPrefixTextProvider textProvider;
    final int[] keyCodes;

    private KeyModifier(String stringID, int id, int ... keyCodes) {
        this.stringID = stringID;
        this.id = id;
        this.textProvider = new ModifierPrefixTextProvider(this);
        this.keyCodes = keyCodes;
        boolean isMac = Amecs.isMac();
        this.name = switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "none";
            case 1 -> {
                if (isMac) {
                    yield "option";
                }
                yield "alt";
            }
            case 2 -> "shift";
            case 3 -> "control";
            case 4 -> isMac ? "command" : "super";
        };
    }

    public static KeyModifier fromKeyCode(int keyCode) {
        for (KeyModifier keyModifier : VALUES) {
            if (keyModifier == NONE || !keyModifier.matches(keyCode)) continue;
            return keyModifier;
        }
        return NONE;
    }

    public static KeyModifier fromKey(class_3675.class_306 key) {
        if (key == null || key.method_1442() != class_3675.class_307.field_1668) {
            return NONE;
        }
        return KeyModifier.fromKeyCode(key.method_1444());
    }

    public boolean matches(int keyCode) {
        return ArrayUtils.contains((int[])this.keyCodes, (int)keyCode);
    }

    public String getTranslationKey() {
        return "amecs.modifier." + this.stringID;
    }

    public static int getModifierCount() {
        return VALUES.length - 1;
    }

    static {
        VALUES = KeyModifier.values();
    }
}

