/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.amecs.gui;

import de.siphalor.amecs.Amecs;
import de.siphalor.amecs.impl.duck.IKeyBindingEntry;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_459;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import org.apache.commons.lang3.StringUtils;

@Environment(value=EnvType.CLIENT)
public class SearchFieldControlsListWidget
extends class_459.class_461 {
    protected class_310 minecraft;
    private final class_342 textFieldWidget;
    private int lastEntryCount = 0;
    private final Set<class_459.class_462> entries = new TreeSet<class_459.class_462>(Comparator.comparing(o -> ((IKeyBindingEntry)o).amecs$getKeyBinding()));

    public SearchFieldControlsListWidget(class_310 client) {
        this.minecraft = client;
        class_327 textRenderer = class_310.method_1551().field_1772;
        assert (this.minecraft.field_1755 != null);
        this.textFieldWidget = new class_342(textRenderer, this.minecraft.field_1755.field_22789 / 2 - 125, 0, 250, 20, (class_2561)class_2561.method_43473());
        this.textFieldWidget.method_1887(class_1074.method_4662((String)"amecs.search.placeholder", (Object[])new Object[0]));
        this.textFieldWidget.method_1863(searchText -> {
            int childrenCount;
            class_459 listWidget = null;
            for (Object child : client.field_1755.method_25396()) {
                if (!(child instanceof class_459)) continue;
                listWidget = (class_459)child;
                break;
            }
            assert (listWidget != null);
            if (searchText.isEmpty()) {
                this.textFieldWidget.method_1887(class_1074.method_4662((String)"amecs.search.placeholder", (Object[])new Object[0]));
            } else {
                this.textFieldWidget.method_1887("");
            }
            searchText = searchText.trim();
            listWidget.method_44382(0.0);
            List children = listWidget.method_25396();
            if (this.entries.isEmpty()) {
                for (class_459.class_461 entry : children) {
                    if (!(entry instanceof class_459.class_462)) continue;
                    this.entries.add((class_459.class_462)entry);
                }
                this.lastEntryCount = children.size();
            }
            if ((childrenCount = children.size()) != this.lastEntryCount) {
                Amecs.LOGGER.info("Controls search results changed externally - recompiling the list!");
                try {
                    Constructor c = class_459.class_462.class.getDeclaredConstructor(class_459.class, class_304.class, class_2561.class);
                    c.setAccessible(true);
                    this.entries.clear();
                    Object[] keyBindings = client.field_1690.field_1839;
                    Arrays.sort(keyBindings);
                    String lastCat = null;
                    this.lastEntryCount = 1;
                    for (Object keyBinding : keyBindings) {
                        if (!Objects.equals(lastCat, keyBinding.method_1423())) {
                            lastCat = keyBinding.method_1423();
                            class_459 class_4592 = listWidget;
                            Objects.requireNonNull(class_4592);
                            children.add(new class_459.class_460(class_4592, (class_2561)class_2561.method_43471((String)keyBinding.method_1423())));
                            ++this.lastEntryCount;
                        }
                        class_459.class_462 entry = (class_459.class_462)c.newInstance(listWidget, keyBinding, class_2561.method_43471((String)keyBinding.method_1431()));
                        children.add(entry);
                        this.entries.add(entry);
                        ++this.lastEntryCount;
                    }
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    Amecs.LOGGER.error("An unexpected exception occured during recompilation of controls list!", (Throwable)e);
                }
            }
            children.clear();
            children.add(this);
            String keyFilter = null;
            int keyDelimiterPos = searchText.indexOf(61);
            if (keyDelimiterPos == 0) {
                keyFilter = searchText.substring(1).trim();
                searchText = null;
            } else if (keyDelimiterPos > 0) {
                keyFilter = searchText.substring(keyDelimiterPos + 1).trim();
                searchText = searchText.substring(0, keyDelimiterPos).trim();
            }
            boolean nmuk = FabricLoader.getInstance().isModLoaded("nmuk");
            String lastCat = null;
            boolean lastMatched = false;
            boolean includeCat = false;
            this.lastEntryCount = 1;
            for (class_459.class_462 entry : this.entries) {
                class_304 binding = ((IKeyBindingEntry)entry).amecs$getKeyBinding();
                String cat = binding.method_1423();
                if (!cat.equals(lastCat)) {
                    includeCat = StringUtils.containsIgnoreCase((CharSequence)class_1074.method_4662((String)cat, (Object[])new Object[0]), (CharSequence)searchText);
                }
                if ((includeCat || searchText == null || StringUtils.containsIgnoreCase((CharSequence)class_1074.method_4662((String)((IKeyBindingEntry)entry).amecs$getKeyBinding().method_1431(), (Object[])new Object[0]), (CharSequence)searchText)) && Amecs.entryKeyMatches(entry, keyFilter)) {
                    if (!cat.equals(lastCat)) {
                        class_459 class_4593 = listWidget;
                        Objects.requireNonNull(class_4593);
                        children.add(new class_459.class_460(class_4593, (class_2561)class_2561.method_43471((String)cat)));
                        lastCat = cat;
                        ++this.lastEntryCount;
                    }
                    children.add(entry);
                    ++this.lastEntryCount;
                    lastMatched = true;
                    continue;
                }
                lastMatched = false;
            }
            if (this.lastEntryCount <= 1) {
                class_5250 noResultsText = class_2561.method_43471((String)"amecs.search.no_results");
                noResultsText.method_10862(noResultsText.method_10866().method_10977(class_124.field_1080));
                class_459 class_4594 = listWidget;
                Objects.requireNonNull(class_4594);
                children.add(new class_459.class_460(class_4594, (class_2561)noResultsText));
            }
        });
    }

    public List<? extends class_364> method_25396() {
        return Collections.singletonList(this.textFieldWidget);
    }

    public boolean method_25402(double double_1, double double_2, int int_1) {
        return this.textFieldWidget.method_25402(double_1, double_2, int_1);
    }

    public boolean method_25406(double double_1, double double_2, int int_1) {
        return this.textFieldWidget.method_25406(double_1, double_2, int_1);
    }

    public boolean method_25404(int int_1, int int_2, int int_3) {
        return this.textFieldWidget.method_25404(int_1, int_2, int_3);
    }

    public boolean method_25400(char char_1, int int_1) {
        return this.textFieldWidget.method_25400(char_1, int_1);
    }

    public void method_25365(boolean boolean_1) {
        this.textFieldWidget.method_25365(boolean_1);
    }

    public void method_25343(class_332 drawContext, int var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9) {
        this.textFieldWidget.method_46419(var2);
        this.textFieldWidget.method_25394(drawContext, var6, var7, var9);
    }

    public List<? extends class_6379> method_37025() {
        return Collections.singletonList(this.textFieldWidget);
    }

    protected void method_48269() {
    }
}

