/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.amecs.impl;

import de.siphalor.amecs.Amecs;
import de.siphalor.amecs.api.KeyBindingUtils;
import de.siphalor.amecs.api.KeyModifiers;
import de.siphalor.amecs.impl.duck.IKeyBinding;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_304;
import net.minecraft.class_310;
import org.jetbrains.annotations.ApiStatus;

@Environment(value=EnvType.CLIENT)
@ApiStatus.Internal
public class KeyModifierOptions {
    private static final String KEY_MODIFIERS_PREFIX = "key_modifiers_";
    private static final File optionsFile = new File(class_310.method_1551().field_1697, "options.amecsapi.txt");

    private KeyModifierOptions() {
    }

    public static void write(class_304[] allKeyBindings) {
        ArrayList<class_304> bindingsWithChangedModifiers = new ArrayList<class_304>(allKeyBindings.length);
        for (class_304 keyBinding : allKeyBindings) {
            if (KeyBindingUtils.getDefaultModifiers(keyBinding).equals(KeyBindingUtils.getBoundModifiers(keyBinding))) continue;
            bindingsWithChangedModifiers.add(keyBinding);
        }
        if (bindingsWithChangedModifiers.isEmpty()) {
            if (optionsFile.exists()) {
                try {
                    Files.delete(optionsFile.toPath());
                }
                catch (IOException e) {
                    Amecs.LOGGER.error("Failed to cleanup Amecs modifier file - weird.", (Throwable)e);
                }
            }
            return;
        }
        try (PrintWriter writer = new PrintWriter(new FileOutputStream(optionsFile));){
            for (class_304 binding : bindingsWithChangedModifiers) {
                KeyModifiers modifiers = KeyBindingUtils.getBoundModifiers(binding);
                writer.println(KEY_MODIFIERS_PREFIX + binding.method_1431() + ":" + modifiers.serializeValue());
            }
        }
        catch (FileNotFoundException e) {
            Amecs.LOGGER.error("Failed to save Amecs modifiers to options file", (Throwable)e);
        }
    }

    public static void read() {
        if (!optionsFile.exists()) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(optionsFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                KeyModifierOptions.readLine(line);
            }
        }
        catch (IOException e) {
            Amecs.LOGGER.error("Failed to load Amecs modifier options file", (Throwable)e);
        }
    }

    private static void readLine(String line) {
        try {
            int colon = line.indexOf(58);
            if (colon <= 0) {
                Amecs.LOGGER.warn("Invalid line in Amecs modifier options file: {}", (Object)line);
                return;
            }
            String id = line.substring(0, colon);
            if (!id.startsWith(KEY_MODIFIERS_PREFIX)) {
                Amecs.LOGGER.warn("Invalid entry in Amecs modifier options file: {}", (Object)id);
                return;
            }
            id = id.substring(KEY_MODIFIERS_PREFIX.length());
            class_304 keyBinding = KeyBindingUtils.getIdToKeyBindingMap().get(id);
            if (keyBinding == null) {
                Amecs.LOGGER.warn("Unknown keybinding identifier in Amecs modifier options file: {}", (Object)id);
                return;
            }
            KeyModifiers modifiers = new KeyModifiers(KeyModifiers.deserializeValue(line.substring(colon + 1)));
            if (keyBinding.method_1415()) {
                if (!modifiers.isUnset()) {
                    Amecs.LOGGER.warn("Found modifiers for unbound keybinding in Amecs modifier options file. Ignoring them: {}", (Object)id);
                }
                return;
            }
            ((IKeyBinding)keyBinding).amecs$getKeyModifiers().copyModifiers(modifiers);
        }
        catch (Throwable e) {
            Amecs.LOGGER.error("Invalid line in Amecs modifier options file: {}", (Object)line, (Object)e);
        }
    }
}

