/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.amecs.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.siphalor.amecs.Amecs;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class MetaOptions {
    private static final Path OPTIONS_PATH = FabricLoader.getInstance().getConfigDir().resolve("amecs-meta.json");
    private static final File OPTIONS_FILE = OPTIONS_PATH.toFile();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static OptionsSerializable instance;

    public static void load(boolean attempt2) {
        block8: {
            if (!OPTIONS_FILE.exists()) {
                MetaOptions.save();
                if (!attempt2) {
                    MetaOptions.load(true);
                }
            }
            try {
                String content = Files.readString(OPTIONS_PATH);
                OptionsSerializable options = (OptionsSerializable)GSON.fromJson(content, OptionsSerializable.class);
                if (options == null) {
                    Amecs.LOGGER.error("Failed to load meta config, using default and trying to save it");
                    instance = new OptionsSerializable();
                    MetaOptions.save();
                } else {
                    instance = options;
                }
            }
            catch (Exception e) {
                Amecs.LOGGER.error("Failed to load meta config", (Throwable)e);
                instance = new OptionsSerializable();
                if (attempt2) break block8;
                try {
                    Files.delete(OPTIONS_PATH);
                }
                catch (IOException ioException) {
                    Amecs.LOGGER.error("Failed to delete corrupted meta config", (Throwable)ioException);
                }
                MetaOptions.load(true);
            }
        }
    }

    public static void save() {
        OptionsSerializable toSave = MetaOptions.get();
        try {
            if (!OPTIONS_FILE.exists()) {
                OPTIONS_FILE.createNewFile();
            }
            String toWrite = toSave.toString();
            FileWriter writer = new FileWriter(OPTIONS_FILE);
            writer.write(toWrite);
            writer.close();
        }
        catch (Exception e) {
            Amecs.LOGGER.error("Failed to save meta config", (Throwable)e);
        }
    }

    public static OptionsSerializable get() {
        return instance == null ? (instance = new OptionsSerializable()) : instance;
    }

    public static void registerCommand() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, access) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"amecs").executes(context -> {
            ((FabricClientCommandSource)context.getSource()).getClient().method_63588(() -> ((FabricClientCommandSource)context.getSource()).getClient().method_1507((class_437)new MetaOptionsScreen(null)));
            return 1;
        })));
    }

    public static class OptionsSerializable {
        @Expose
        public boolean searchBar = true;
        @Expose
        public boolean skinKeybinds = true;
        @Expose
        public boolean autoJumpKeybind = true;
        @Expose
        public boolean escapeKeybind = true;

        public String toString() {
            return GSON.toJson((Object)this);
        }
    }

    public static class MetaOptionsScreen
    extends class_437 {
        private static final class_2561 COLON_SPACE = class_2561.method_43470((String)": ");
        private static final class_2561 ON = class_5244.field_24332.method_27661().method_27692(class_124.field_1060);
        private static final class_2561 OFF = class_5244.field_24333.method_27661().method_27692(class_124.field_1061);
        private static final class_2561 HEADER = class_2561.method_43471((String)"amecs.meta.options.header").method_27694(it -> it.method_10982(Boolean.valueOf(true)).method_10977(class_124.field_1065));
        private static final class_2561 RESET_NOTICE = class_2561.method_43471((String)"amecs.meta.options.resetNotice").method_27694(it -> it.method_10977(class_124.field_1061));
        private final class_437 parent;
        private static final int BUTTON_WIDTH = 200;
        private static final int BUTTON_HEIGHT = 20;

        public MetaOptionsScreen(class_437 parent) {
            super((class_2561)class_2561.method_43471((String)"amecs.meta.options.title"));
            this.parent = parent;
        }

        private static class_2561 buttonTextFor(String key) {
            class_5250 base = class_2561.method_43471((String)("amecs.meta.options." + key));
            return class_2561.method_43473().method_10852((class_2561)base).method_10852(COLON_SPACE).method_10852((switch (key) {
                case "searchBar" -> MetaOptions.get().searchBar;
                case "skinKeybinds" -> MetaOptions.get().skinKeybinds;
                case "autoJumpKeybind" -> MetaOptions.get().autoJumpKeybind;
                case "escapeKeybind" -> MetaOptions.get().escapeKeybind;
                default -> throw new IllegalArgumentException("Unknown key: " + key);
            }) ? ON : OFF);
        }

        public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
            super.method_25394(context, mouseX, mouseY, delta);
            context.method_27534(this.field_22793, HEADER, this.field_22789 / 2, 10, 0);
            context.method_27534(this.field_22793, RESET_NOTICE, this.field_22789 / 2, 60, 0);
        }

        protected void method_25426() {
            super.method_25426();
            int buttonX = this.field_22789 / 2 - 100;
            this.method_37063((class_364)class_4185.method_46430((class_2561)MetaOptionsScreen.buttonTextFor("searchBar"), button -> {
                OptionsSerializable opts = MetaOptions.get();
                opts.searchBar = !opts.searchBar;
                button.method_25355(MetaOptionsScreen.buttonTextFor("searchBar"));
            }).method_46434(buttonX, 30, 200, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)MetaOptionsScreen.buttonTextFor("skinKeybinds"), button -> {
                OptionsSerializable opts = MetaOptions.get();
                opts.skinKeybinds = !opts.skinKeybinds;
                button.method_25355(MetaOptionsScreen.buttonTextFor("skinKeybinds"));
            }).method_46434(buttonX, 80, 200, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)MetaOptionsScreen.buttonTextFor("autoJumpKeybind"), button -> {
                OptionsSerializable opts = MetaOptions.get();
                opts.autoJumpKeybind = !opts.autoJumpKeybind;
                button.method_25355(MetaOptionsScreen.buttonTextFor("autoJumpKeybind"));
            }).method_46434(buttonX, 110, 200, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)MetaOptionsScreen.buttonTextFor("escapeKeybind"), button -> {
                OptionsSerializable opts = MetaOptions.get();
                opts.escapeKeybind = !opts.escapeKeybind;
                button.method_25355(MetaOptionsScreen.buttonTextFor("escapeKeybind"));
            }).method_46434(buttonX, 140, 200, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46434(buttonX, this.field_22790 - 30, 200, 20).method_46431());
        }

        public void method_25419() {
            MetaOptions.save();
            class_310.method_1551().method_1507(this.parent);
        }
    }
}

