/*
 * Decompiled with CFR 0.152.
 */
package org.little100.super_Farming.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.little100.super_Farming.data.FarmData;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class DatabaseManager {
    private final String url;

    public DatabaseManager(File dataFolder) {
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        File dbFile = new File(dataFolder, "farms.db");
        this.url = "jdbc:sqlite:" + dbFile.getAbsolutePath();
        this.load();
    }

    private Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.url);
    }

    private void load() {
        String sql = "CREATE TABLE IF NOT EXISTS active_farms (location TEXT PRIMARY KEY,owner_uuid TEXT NOT NULL,hoe_data TEXT NOT NULL,armor_stand_uuid TEXT NOT NULL);";
        try (Connection conn = this.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void addFarm(String location, String ownerUuid, String hoeData, String armorStandUuid) {
        String sql = "INSERT INTO active_farms(location, owner_uuid, hoe_data, armor_stand_uuid) VALUES(?,?,?,?)";
        try (Connection conn = this.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, location);
            pstmt.setString(2, ownerUuid);
            pstmt.setString(3, hoeData);
            pstmt.setString(4, armorStandUuid);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    public boolean farmExists(String location) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void removeFarm(String location) {
        String sql = "DELETE FROM active_farms WHERE location = ?";
        try (Connection conn = this.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, location);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FarmData getFarm(String location) {
        String sql = "SELECT owner_uuid, hoe_data, armor_stand_uuid FROM active_farms WHERE location = ?";
        try (Connection conn = this.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, location);
            try (ResultSet rs = pstmt.executeQuery();){
                if (!rs.next()) return null;
                String ownerUuid = rs.getString("owner_uuid");
                String hoeData = rs.getString("hoe_data");
                String armorStandUuid = rs.getString("armor_stand_uuid");
                FarmData farmData = new FarmData(location, ownerUuid, hoeData, armorStandUuid);
                return farmData;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public List<FarmData> getAllFarms() {
        ArrayList<FarmData> farms = new ArrayList<FarmData>();
        String sql = "SELECT location, owner_uuid, hoe_data, armor_stand_uuid FROM active_farms";
        try (Connection conn = this.getConnection();
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                farms.add(new FarmData(rs.getString("location"), rs.getString("owner_uuid"), rs.getString("hoe_data"), rs.getString("armor_stand_uuid")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return farms;
    }

    public void saveFarm(FarmData farm) {
        if (farm == null) {
            return;
        }
        String sql = "INSERT OR REPLACE INTO active_farms (location, owner_uuid, hoe_data, armor_stand_uuid) VALUES (?, ?, ?, ?)";
        try (Connection conn = this.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, farm.getLocation());
            pstmt.setString(2, farm.getOwnerUuid());
            pstmt.setString(3, farm.getHoeData());
            pstmt.setString(4, farm.getArmorStandUuid());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteFarm(String location) {
        String sql = "DELETE FROM active_farms WHERE location = ?";
        try (Connection conn = this.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, location);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static String itemStackToBase64(ItemStack item) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);
            dataOutput.writeObject((Object)item);
            dataOutput.close();
            return Base64Coder.encodeLines((byte[])outputStream.toByteArray());
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to save item stacks.", e);
        }
    }

    public static ItemStack itemStackFromBase64(String data) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)data));
            BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);
            ItemStack item = (ItemStack)dataInput.readObject();
            dataInput.close();
            return item;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to decode class type.", e);
        }
    }
}

