/*
 * Decompiled with CFR 0.152.
 */
package org.little100.super_Farming.farm;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Container;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Farmland;
import org.bukkit.entity.Item;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.little100.super_Farming.Super_Farming;
import org.little100.super_Farming.data.DatabaseManager;
import org.little100.super_Farming.data.FarmData;
import org.little100.super_Farming.item.ItemManager;

public class FarmManager {
    private final Super_Farming plugin;
    private final DatabaseManager dbManager;
    private final Map<String, FarmData> activeFarms = new ConcurrentHashMap<String, FarmData>();
    private Object farmTask;
    private final boolean isFoliaServer;
    private final int yAxisUpperLimit;
    private final int yAxisLowerLimit;
    private final int maxBoneMealUse;
    private final long taskInterval;

    public FarmManager(Super_Farming plugin, DatabaseManager dbManager) {
        this.plugin = plugin;
        this.dbManager = dbManager;
        this.isFoliaServer = this.isFoliaServer();
        this.yAxisUpperLimit = plugin.getConfig().getInt("farm.tilling.y-axis.upper-limit", -1);
        this.yAxisLowerLimit = plugin.getConfig().getInt("farm.tilling.y-axis.lower-limit", -1);
        this.maxBoneMealUse = plugin.getConfig().getInt("farm.fertilizing.max-bone-meal", 10);
        this.taskInterval = plugin.getConfig().getLong("farm.scheduler.interval", 200L);
        plugin.getLogger().info("Y\u8f74\u641c\u7d22\u8303\u56f4: \u4e0a\u9650=" + String.valueOf(this.yAxisUpperLimit == -1 ? "\u65e0\u9650" : Integer.valueOf(this.yAxisUpperLimit)) + ", \u4e0b\u9650=" + String.valueOf(this.yAxisLowerLimit == -1 ? "\u65e0\u9650" : Integer.valueOf(this.yAxisLowerLimit)));
    }

    private boolean isFoliaServer() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void loadFarms() {
        List<FarmData> farms = this.dbManager.getAllFarms();
        this.plugin.getLogger().info("Loading farms from database, found: " + farms.size());
        for (FarmData farm : farms) {
            this.activeFarms.put(farm.getLocation(), farm);
        }
        this.plugin.getLogger().info("Loaded " + this.activeFarms.size() + " farms into memory.");
        this.startFarmTask();
    }

    public void unloadFarms() {
        this.cancelFarmTask();
        this.activeFarms.clear();
        this.plugin.getLogger().info("Unloaded all farms.");
    }

    private void cancelFarmTask() {
        if (this.farmTask == null) {
            return;
        }
        try {
            if (this.isFoliaServer) {
                this.farmTask.getClass().getMethod("cancel", new Class[0]).invoke(this.farmTask, new Object[0]);
            } else if (this.farmTask instanceof BukkitTask) {
                ((BukkitTask)this.farmTask).cancel();
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error cancelling farm task: " + e.getMessage());
        }
        this.farmTask = null;
    }

    private void startFarmTask() {
        this.cancelFarmTask();
        if (this.isFoliaServer) {
            try {
                Object globalRegionScheduler = this.plugin.getServer().getClass().getMethod("getGlobalRegionScheduler", new Class[0]).invoke((Object)this.plugin.getServer(), new Object[0]);
                this.farmTask = globalRegionScheduler.getClass().getMethod("runAtFixedRate", Plugin.class, Consumer.class, Long.TYPE, Long.TYPE).invoke(globalRegionScheduler, new Object[]{this.plugin, task -> this.processAllFarms(), 20L, this.taskInterval});
                this.plugin.getLogger().info("Started farm task in Folia mode (" + this.taskInterval + " tick interval).");
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("CRITICAL: Failed to start Folia farm task. Auto-farming will be disabled. Error: " + e.getMessage());
                e.printStackTrace();
            }
        } else {
            this.startBukkitFarmTask();
        }
    }

    private void startBukkitFarmTask() {
        this.farmTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, this::processAllFarms, 100L, this.taskInterval);
        this.plugin.getLogger().info("Started farm task in Bukkit mode (" + this.taskInterval + " tick interval).");
    }

    private void processAllFarms() {
        if (this.activeFarms.isEmpty()) {
            return;
        }
        for (final FarmData farm : this.activeFarms.values()) {
            try {
                final Location center = this.stringToLocation(farm.getLocation());
                if (center == null || center.getWorld() == null) {
                    this.plugin.getLogger().warning("Invalid farm location or world not loaded: " + farm.getLocation());
                    continue;
                }
                if (!center.getWorld().isChunkLoaded(center.getBlockX() >> 4, center.getBlockZ() >> 4)) continue;
                ItemStack hoe = DatabaseManager.itemStackFromBase64(farm.getHoeData());
                if (hoe == null) {
                    this.plugin.getLogger().warning("Invalid hoe data for farm at: " + farm.getLocation());
                    continue;
                }
                final int range = this.getHoeRange(hoe);
                if (this.isFoliaServer) {
                    try {
                        Object regionScheduler = this.plugin.getServer().getClass().getMethod("getRegionScheduler", new Class[0]).invoke((Object)this.plugin.getServer(), new Object[0]);
                        Method executeMethod = regionScheduler.getClass().getMethod("execute", Plugin.class, Location.class, Runnable.class);
                        Runnable task = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    if (!FarmManager.this.activeFarms.containsKey(farm.getLocation())) {
                                        return;
                                    }
                                    FarmManager.this.tillSoil(center, range);
                                    FarmManager.this.wetFarmland(center, range);
                                    FarmManager.this.plantSeeds(center, range);
                                    FarmManager.this.fertilizeCrops(center, range);
                                    FarmManager.this.harvestAndCollect(center, range);
                                }
                                catch (Exception e) {
                                    FarmManager.this.plugin.getLogger().severe("Error in region thread farm operations: " + e.getMessage());
                                    e.printStackTrace();
                                }
                            }
                        };
                        executeMethod.invoke(regionScheduler, new Object[]{this.plugin, center, task});
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().severe("Failed to schedule farm on region thread: " + e.getMessage());
                        e.printStackTrace();
                    }
                    continue;
                }
                this.tillSoil(center, range);
                this.wetFarmland(center, range);
                this.plantSeeds(center, range);
                this.fertilizeCrops(center, range);
                this.harvestAndCollect(center, range);
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error preparing farm at " + farm.getLocation() + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private Location stringToLocation(String locString) {
        if (locString == null || locString.isEmpty()) {
            return null;
        }
        try {
            String[] parts = locString.split(",");
            if (parts.length < 4) {
                return null;
            }
            World world = Bukkit.getWorld((String)parts[0]);
            if (world == null) {
                return null;
            }
            double x = Double.parseDouble(parts[1]);
            double y = Double.parseDouble(parts[2]);
            double z = Double.parseDouble(parts[3]);
            return new Location(world, x, y, z);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to parse location string: " + locString);
            return null;
        }
    }

    private int getHoeRange(ItemStack hoe) {
        if (hoe == null || !hoe.hasItemMeta()) {
            return 1;
        }
        ItemMeta meta = hoe.getItemMeta();
        if (meta == null) {
            return 1;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        Integer range = (Integer)container.get(ItemManager.HOERANGE_KEY, PersistentDataType.INTEGER);
        return range != null ? range : 1;
    }

    private void wetFarmland(Location center, int range) {
        World world = center.getWorld();
        if (world == null) {
            this.plugin.getLogger().warning("wetFarmland: world is null");
            return;
        }
        int farmlandCount = 0;
        int moistenedCount = 0;
        try {
            for (int x = -range; x <= range; ++x) {
                for (int z = -range; z <= range; ++z) {
                    for (int y = -1; y <= 1; ++y) {
                        try {
                            int blockX = center.getBlockX() + x;
                            int blockY = center.getBlockY() + y;
                            int blockZ = center.getBlockZ() + z;
                            Block block = null;
                            try {
                                block = world.getBlockAt(blockX, blockY, blockZ);
                            }
                            catch (Exception e) {
                                this.plugin.getLogger().warning("wetFarmland: Error getting block at [" + blockX + "," + blockY + "," + blockZ + "]: " + e.getMessage());
                                continue;
                            }
                            if (block == null) continue;
                            Material type = null;
                            try {
                                type = block.getType();
                            }
                            catch (Exception e) {
                                this.plugin.getLogger().warning("wetFarmland: Error getting block type: " + e.getMessage());
                                continue;
                            }
                            if (type != Material.FARMLAND) continue;
                            ++farmlandCount;
                            try {
                                Farmland farmland;
                                if (!(block.getBlockData() instanceof Farmland) || (farmland = (Farmland)block.getBlockData()).getMoisture() >= farmland.getMaximumMoisture()) continue;
                                farmland.setMoisture(farmland.getMaximumMoisture());
                                block.setBlockData((BlockData)farmland);
                                ++moistenedCount;
                            }
                            catch (Exception e) {
                                this.plugin.getLogger().warning("wetFarmland: Error moistening farmland: " + e.getMessage());
                                e.printStackTrace();
                            }
                            continue;
                        }
                        catch (Exception e) {
                            this.plugin.getLogger().warning("wetFarmland: Error processing block: " + e.getMessage());
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error in wetFarmland: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void plantSeeds(Location center, int range) {
        World world = center.getWorld();
        if (world == null) {
            return;
        }
        try {
            ArrayList<Block> farmlandList = new ArrayList<Block>();
            ArrayList<Inventory> containerInventories = new ArrayList<Inventory>();
            for (int x = -range; x <= range; ++x) {
                for (int z = -range; z <= range; ++z) {
                    int minY = this.yAxisLowerLimit == -1 ? -256 : -this.yAxisLowerLimit;
                    int maxY = this.yAxisUpperLimit == -1 ? 256 : this.yAxisUpperLimit;
                    for (int y = minY; y <= maxY; ++y) {
                        try {
                            int blockX = center.getBlockX() + x;
                            int blockY = center.getBlockY() + y;
                            int blockZ = center.getBlockZ() + z;
                            Block block = null;
                            try {
                                block = world.getBlockAt(blockX, blockY, blockZ);
                            }
                            catch (Exception e) {
                                continue;
                            }
                            if (block == null) continue;
                            try {
                                if (block.getState() instanceof Container) {
                                    containerInventories.add(((Container)block.getState()).getInventory());
                                    continue;
                                }
                                Material type = block.getType();
                                if (type != Material.FARMLAND) continue;
                                Block aboveBlock = null;
                                try {
                                    aboveBlock = block.getRelative(BlockFace.UP);
                                    if (aboveBlock == null || aboveBlock.getType() != Material.AIR) continue;
                                    farmlandList.add(block);
                                }
                                catch (Exception exception) {
                                }
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            if (farmlandList.isEmpty() || containerInventories.isEmpty()) {
                return;
            }
            Map<Material, Material> seedToCrop = this.getSeedCropMap();
            for (Block farmland : farmlandList) {
                try {
                    Block aboveBlock = farmland.getRelative(BlockFace.UP);
                    if (aboveBlock == null || aboveBlock.getType() != Material.AIR) continue;
                    boolean planted = false;
                    for (Inventory inv : containerInventories) {
                        if (inv == null) continue;
                        for (Material seed : seedToCrop.keySet()) {
                            try {
                                if (!inv.contains(seed)) continue;
                                inv.removeItem(new ItemStack[]{new ItemStack(seed, 1)});
                                aboveBlock.setType(seedToCrop.get(seed));
                                planted = true;
                                break;
                            }
                            catch (Exception exception) {
                            }
                        }
                        if (!planted) continue;
                    }
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error in plantSeeds: " + e.getMessage());
        }
    }

    private Map<Material, Material> getSeedCropMap() {
        EnumMap<Material, Material> map = new EnumMap<Material, Material>(Material.class);
        map.put(Material.WHEAT_SEEDS, Material.WHEAT);
        map.put(Material.POTATO, Material.POTATOES);
        map.put(Material.CARROT, Material.CARROTS);
        map.put(Material.BEETROOT_SEEDS, Material.BEETROOTS);
        map.put(Material.PUMPKIN_SEEDS, Material.PUMPKIN_STEM);
        map.put(Material.MELON_SEEDS, Material.MELON_STEM);
        return map;
    }

    private void fertilizeCrops(Location center, int range) {
        block26: {
            World world = center.getWorld();
            if (world == null) {
                return;
            }
            try {
                ArrayList<Block> immatureCrops = new ArrayList<Block>();
                ArrayList<Inventory> inventories = new ArrayList<Inventory>();
                for (int x = -range; x <= range; ++x) {
                    for (int z = -range; z <= range; ++z) {
                        int minY = this.yAxisLowerLimit == -1 ? -256 : -this.yAxisLowerLimit;
                        int maxY = this.yAxisUpperLimit == -1 ? 256 : this.yAxisUpperLimit;
                        for (int y = minY; y <= maxY; ++y) {
                            try {
                                Block block = null;
                                try {
                                    block = world.getBlockAt(center.getBlockX() + x, center.getBlockY() + y, center.getBlockZ() + z);
                                }
                                catch (Exception e) {
                                    continue;
                                }
                                if (block == null) continue;
                                try {
                                    Ageable ageable;
                                    if (block.getBlockData() instanceof Ageable && (ageable = (Ageable)block.getBlockData()).getAge() < ageable.getMaximumAge()) {
                                        immatureCrops.add(block);
                                    }
                                    if (!(block.getState() instanceof Container)) continue;
                                    inventories.add(((Container)block.getState()).getInventory());
                                }
                                catch (Exception ageable) {}
                                continue;
                            }
                            catch (Exception block) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (immatureCrops.isEmpty() || inventories.isEmpty()) {
                    return;
                }
                int maxBoneMealToUse = Math.min(this.maxBoneMealUse, immatureCrops.size());
                int boneMealCount = 0;
                ArrayList<ItemStack> boneMealItems = new ArrayList<ItemStack>();
                for (Inventory inv : inventories) {
                    try {
                        if (inv == null) continue;
                        for (Block item : inv.getContents()) {
                            if (item == null || item.getType() != Material.BONE_MEAL) continue;
                            int amount = Math.min(item.getAmount(), maxBoneMealToUse - boneMealCount);
                            boneMealItems.add(new ItemStack(Material.BONE_MEAL, amount));
                            if ((boneMealCount += amount) >= maxBoneMealToUse) break;
                        }
                        if (boneMealCount < maxBoneMealToUse) continue;
                        break;
                    }
                    catch (Exception block) {
                    }
                }
                if (boneMealCount <= 0 || immatureCrops.isEmpty()) break block26;
                Collections.shuffle(immatureCrops);
                int fertilizedCount = 0;
                for (int i = 0; i < Math.min(boneMealCount, immatureCrops.size()); ++i) {
                    try {
                        Block crop = (Block)immatureCrops.get(i);
                        if (crop == null || !(crop.getBlockData() instanceof Ageable) || !crop.applyBoneMeal(BlockFace.UP)) continue;
                        ++fertilizedCount;
                        try {
                            world.spawnParticle(Particle.HAPPY_VILLAGER, crop.getLocation().add(0.5, 0.5, 0.5), 5, 0.5, 0.5, 0.5, 0.0);
                        }
                        catch (Exception ageable) {}
                        continue;
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warning("Error fertilizing crop: " + e.getMessage());
                    }
                }
                if (fertilizedCount <= 0) break block26;
                int remainingToRemove = fertilizedCount;
                for (Inventory inv : inventories) {
                    try {
                        HashMap notRemoved;
                        if (inv == null || remainingToRemove <= 0 || !inv.contains(Material.BONE_MEAL) || (remainingToRemove = (notRemoved = inv.removeItem(new ItemStack[]{new ItemStack(Material.BONE_MEAL, remainingToRemove)})).isEmpty() ? 0 : ((ItemStack)notRemoved.values().iterator().next()).getAmount()) > 0) continue;
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error in fertilizeCrops: " + e.getMessage());
            }
        }
    }

    private void harvestAndCollect(Location center, int range) {
        World world = center.getWorld();
        if (world == null) {
            return;
        }
        try {
            ArrayList<Inventory> inventories = new ArrayList<Inventory>();
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            for (int x = -range; x <= range; ++x) {
                for (int z = -range; z <= range; ++z) {
                    int minY = this.yAxisLowerLimit == -1 ? -256 : -this.yAxisLowerLimit;
                    int maxY = this.yAxisUpperLimit == -1 ? 256 : this.yAxisUpperLimit;
                    for (int y = minY; y <= maxY; ++y) {
                        try {
                            Block block = null;
                            try {
                                block = world.getBlockAt(center.getBlockX() + x, center.getBlockY() + y, center.getBlockZ() + z);
                            }
                            catch (Exception e) {
                                continue;
                            }
                            if (block == null) continue;
                            try {
                                if (block.getState() instanceof Container) {
                                    inventories.add(((Container)block.getState()).getInventory());
                                    continue;
                                }
                                Material type = null;
                                try {
                                    type = block.getType();
                                }
                                catch (Exception e) {
                                    continue;
                                }
                                if (type == Material.PUMPKIN || type == Material.MELON) {
                                    try {
                                        drops.addAll(block.getDrops());
                                        block.setType(Material.AIR);
                                    }
                                    catch (Exception e) {}
                                    continue;
                                }
                                if (!(block.getBlockData() instanceof Ageable)) continue;
                                try {
                                    Ageable ageable = (Ageable)block.getBlockData();
                                    if (ageable.getAge() != ageable.getMaximumAge()) continue;
                                    drops.addAll(block.getDrops());
                                    block.setType(Material.AIR);
                                }
                                catch (Exception exception) {
                                }
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            try {
                Collection items = world.getEntitiesByClass(Item.class);
                for (Item item : items) {
                    try {
                        if (item == null || !(item.getLocation().distance(center) <= (double)range)) continue;
                        drops.add(item.getItemStack());
                        item.remove();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (ItemStack drop : drops) {
                if (drop == null) continue;
                try {
                    HashMap leftover = new HashMap();
                    for (Inventory inv : inventories) {
                        if (inv == null) continue;
                        try {
                            leftover = inv.addItem(new ItemStack[]{drop});
                            if (leftover.isEmpty()) break;
                            drop = (ItemStack)leftover.get(0);
                        }
                        catch (Exception exception) {}
                    }
                    if (leftover.isEmpty() || leftover.get(0) == null) continue;
                    try {
                        world.dropItemNaturally(center, (ItemStack)leftover.get(0));
                    }
                    catch (Exception exception) {
                    }
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error in harvestAndCollect: " + e.getMessage());
        }
    }

    private void tillSoil(Location center, int range) {
        World world = center.getWorld();
        if (world == null) {
            this.plugin.getLogger().warning("tillSoil: world is null");
            return;
        }
        int tilledCount = 0;
        try {
            for (int x = -range; x <= range; ++x) {
                for (int z = -range; z <= range; ++z) {
                    int minY = this.yAxisLowerLimit == -1 ? -256 : -this.yAxisLowerLimit;
                    int maxY = this.yAxisUpperLimit == -1 ? 256 : this.yAxisUpperLimit;
                    for (int y = minY; y <= maxY; ++y) {
                        try {
                            int blockX = center.getBlockX() + x;
                            int blockY = center.getBlockY() + y;
                            int blockZ = center.getBlockZ() + z;
                            Block block = null;
                            try {
                                block = world.getBlockAt(blockX, blockY, blockZ);
                            }
                            catch (Exception e) {
                                continue;
                            }
                            if (block == null) continue;
                            Material type = null;
                            try {
                                type = block.getType();
                            }
                            catch (Exception e) {
                                continue;
                            }
                            Block aboveBlock = null;
                            try {
                                aboveBlock = block.getRelative(BlockFace.UP);
                            }
                            catch (Exception e) {
                                continue;
                            }
                            if (aboveBlock == null) continue;
                            Material aboveType = null;
                            try {
                                aboveType = aboveBlock.getType();
                            }
                            catch (Exception e) {
                                continue;
                            }
                            if (aboveType != Material.AIR || type != Material.GRASS_BLOCK && type != Material.DIRT && type != Material.COARSE_DIRT) continue;
                            try {
                                block.setType(Material.FARMLAND);
                                ++tilledCount;
                            }
                            catch (Exception e) {
                                this.plugin.getLogger().warning("Error tilling soil: " + e.getMessage());
                            }
                            continue;
                        }
                        catch (Exception e) {
                            this.plugin.getLogger().warning("Error processing block for tilling: " + e.getMessage());
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error in tillSoil: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void addFarm(FarmData farm) {
        if (farm != null) {
            this.activeFarms.put(farm.getLocation(), farm);
            this.dbManager.saveFarm(farm);
        }
    }

    public void removeFarm(String location) {
        if (location != null) {
            this.activeFarms.remove(location);
            this.dbManager.deleteFarm(location);
        }
    }
}

