/*
 * Decompiled with CFR 0.152.
 */
package org.little100.super_Farming.gui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.little100.super_Farming.Super_Farming;
import org.little100.super_Farming.language.LanguageManager;

public class GuiManager {
    private final Super_Farming plugin;
    private final LanguageManager languageManager;
    public static final String EDITOR_TITLE = "Super Hoe GUI Editor";
    private final NamespacedKey hoeTypeKey;
    private final NamespacedKey hoeModeKey;
    private final NamespacedKey hoeRangeKey;
    private final NamespacedKey hoePlantModeKey;

    public GuiManager(Super_Farming plugin, LanguageManager languageManager) {
        this.plugin = plugin;
        this.languageManager = languageManager;
        this.hoeTypeKey = new NamespacedKey((Plugin)plugin, "superhoe");
        this.hoeModeKey = new NamespacedKey((Plugin)plugin, "hoemode");
        this.hoeRangeKey = new NamespacedKey((Plugin)plugin, "hoerange");
        this.hoePlantModeKey = new NamespacedKey((Plugin)plugin, "hoeplantmode");
    }

    public void openGui(Player player) {
        ItemStack hoeItem = player.getInventory().getItemInMainHand();
        if (hoeItem.getType().isAir() || !hoeItem.hasItemMeta()) {
            return;
        }
        ItemMeta meta = hoeItem.getItemMeta();
        if (meta == null || !meta.getPersistentDataContainer().has(this.hoeTypeKey, PersistentDataType.STRING)) {
            return;
        }
        boolean isFarmingMode = (Byte)meta.getPersistentDataContainer().getOrDefault(this.hoeModeKey, PersistentDataType.BYTE, (Object)1) == 1;
        int currentRange = (Integer)meta.getPersistentDataContainer().getOrDefault(this.hoeRangeKey, PersistentDataType.INTEGER, (Object)1);
        String hoeType = (String)meta.getPersistentDataContainer().get(this.hoeTypeKey, PersistentDataType.STRING);
        String plantMode = (String)meta.getPersistentDataContainer().getOrDefault(this.hoePlantModeKey, PersistentDataType.STRING, (Object)"LILY_PAD");
        int hoeLevel = this.getHoeLevel(hoeType);
        int maxRange = this.getMaxRangeForLevel(hoeLevel);
        String title = this.languageManager.getString("gui.title");
        Inventory gui = this.loadGuiFromFile(title);
        if (gui == null) {
            gui = Bukkit.createInventory(null, (int)54, (String)title);
            this.fillBorder(gui);
        }
        this.updateModeButtons(gui, isFarmingMode);
        this.updateRangeButtons(gui, currentRange, maxRange);
        this.updateInfoPaper(gui, currentRange);
        this.updatePlantingButtons(gui, plantMode);
        player.openInventory(gui);
    }

    public void toggleHoeMode(Player player, ItemStack hoeItem) {
        if (hoeItem == null || !hoeItem.hasItemMeta()) {
            return;
        }
        ItemMeta meta = hoeItem.getItemMeta();
        boolean currentModeIsFarming = (Byte)meta.getPersistentDataContainer().getOrDefault(this.hoeModeKey, PersistentDataType.BYTE, (Object)1) == 1;
        boolean newModeIsFarming = !currentModeIsFarming;
        meta.getPersistentDataContainer().set(this.hoeModeKey, PersistentDataType.BYTE, (Object)((byte)(newModeIsFarming ? 1 : 0)));
        meta.removeEnchant(Enchantment.POWER);
        meta.removeEnchant(Enchantment.EFFICIENCY);
        if (newModeIsFarming) {
            meta.addEnchant(Enchantment.EFFICIENCY, 5, true);
        } else {
            meta.addEnchant(Enchantment.POWER, 1, true);
        }
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        meta = this.updateHoeLore(meta);
        hoeItem.setItemMeta(meta);
        this.openGui(player);
    }

    public void setHoeRange(Player player, ItemStack hoeItem, int newRange) {
        if (hoeItem == null || !hoeItem.hasItemMeta()) {
            return;
        }
        ItemMeta meta = hoeItem.getItemMeta();
        String hoeType = (String)meta.getPersistentDataContainer().get(this.hoeTypeKey, PersistentDataType.STRING);
        int maxRange = this.getMaxRangeForLevel(this.getHoeLevel(hoeType));
        if (newRange > maxRange) {
            newRange = maxRange;
        }
        if (newRange < 1) {
            newRange = 1;
        }
        meta.getPersistentDataContainer().set(this.hoeRangeKey, PersistentDataType.INTEGER, (Object)newRange);
        meta = this.updateHoeLore(meta);
        hoeItem.setItemMeta(meta);
        this.openGui(player);
    }

    public void setHoePlantMode(Player player, ItemStack hoeItem, String newMode) {
        if (hoeItem == null || !hoeItem.hasItemMeta()) {
            return;
        }
        ItemMeta meta = hoeItem.getItemMeta();
        if (meta == null) {
            return;
        }
        meta.getPersistentDataContainer().set(this.hoePlantModeKey, PersistentDataType.STRING, (Object)newMode);
        meta = this.updateHoeLore(meta);
        hoeItem.setItemMeta(meta);
        this.openGui(player);
    }

    private void fillBorder(Inventory gui) {
        ItemStack borderItem = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
        ItemMeta borderMeta = borderItem.getItemMeta();
        borderMeta.setDisplayName(" ");
        borderItem.setItemMeta(borderMeta);
        for (int i = 0; i < gui.getSize(); ++i) {
            if (i >= 9 && i <= 44 && i % 9 != 0 && i % 9 != 8) continue;
            gui.setItem(i, borderItem);
        }
    }

    private void updateModeButtons(Inventory gui, boolean isFarmingMode) {
        ItemMeta bonemealMeta;
        ItemStack bonemealItem;
        ItemMeta farmingMeta;
        ItemStack farmingItem = gui.getItem(3);
        if (farmingItem == null) {
            farmingItem = new ItemStack(Material.FARMLAND);
        }
        if ((farmingMeta = farmingItem.getItemMeta()) != null) {
            farmingMeta.setDisplayName(this.languageManager.getString("gui.mode.farming"));
            String status = isFarmingMode ? this.languageManager.getString("gui.selected") : this.languageManager.getString("gui.not_selected");
            this.updateLoreWithStatus(farmingMeta, status);
            farmingItem.setItemMeta(farmingMeta);
        }
        if ((bonemealItem = gui.getItem(5)) == null) {
            bonemealItem = new ItemStack(Material.BONE_MEAL);
        }
        if ((bonemealMeta = bonemealItem.getItemMeta()) != null) {
            bonemealMeta.setDisplayName(this.languageManager.getString("gui.mode.bonemeal"));
            String status = !isFarmingMode ? this.languageManager.getString("gui.selected") : this.languageManager.getString("gui.not_selected");
            this.updateLoreWithStatus(bonemealMeta, status);
            bonemealItem.setItemMeta(bonemealMeta);
        }
    }

    private void updateRangeButtons(Inventory gui, int currentRange, int maxRange) {
        for (int i = 1; i <= 5; ++i) {
            ItemMeta displayMeta;
            ItemStack displayItem;
            ItemMeta templateMeta;
            int slot = 11 + (i - 1);
            ItemStack templateItem = gui.getItem(slot);
            ItemMeta itemMeta = templateMeta = templateItem != null && templateItem.hasItemMeta() ? templateItem.getItemMeta() : null;
            if (i > maxRange) {
                displayItem = new ItemStack(Material.BARRIER);
                displayMeta = displayItem.getItemMeta();
                if (displayMeta != null) {
                    displayMeta.setDisplayName(String.valueOf(ChatColor.RED) + this.languageManager.getString("gui.range.unavailable"));
                    displayMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + this.languageManager.getString("gui.range.upgrade_needed")));
                }
            } else if (i == currentRange) {
                displayItem = new ItemStack(Material.EMERALD_BLOCK);
                displayMeta = displayItem.getItemMeta();
                if (displayMeta != null) {
                    displayMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + this.getRangeDescription(i));
                    if (templateMeta != null && templateMeta.hasLore()) {
                        displayMeta.setLore(templateMeta.getLore());
                    }
                    this.updateLoreWithStatus(displayMeta, this.languageManager.getString("gui.selected"));
                }
            } else {
                displayItem = new ItemStack(Material.REDSTONE_BLOCK);
                displayMeta = displayItem.getItemMeta();
                if (displayMeta != null) {
                    displayMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + this.getRangeDescription(i));
                    if (templateMeta != null && templateMeta.hasLore()) {
                        displayMeta.setLore(templateMeta.getLore());
                    }
                    this.updateLoreWithStatus(displayMeta, this.languageManager.getString("gui.range.click_to_select"));
                }
            }
            if (displayItem == null) continue;
            displayItem.setItemMeta(displayMeta);
            gui.setItem(slot, displayItem);
        }
    }

    private void updateInfoPaper(Inventory gui, int currentRange) {
        ItemMeta infoMeta;
        ItemStack infoItem = gui.getItem(49);
        if (infoItem == null) {
            infoItem = new ItemStack(Material.PAPER);
        }
        if ((infoMeta = infoItem.getItemMeta()) != null) {
            infoMeta.setDisplayName(String.valueOf(ChatColor.GOLD) + this.languageManager.getString("gui.range.current"));
            String rangeLine = String.valueOf(ChatColor.GRAY) + this.languageManager.getString("gui.range.label") + " " + String.valueOf(ChatColor.GREEN) + this.getRangeDescription(currentRange);
            this.updateLoreWithStatus(infoMeta, rangeLine);
            infoItem.setItemMeta(infoMeta);
        }
    }

    private void updatePlantingButtons(Inventory gui, String currentPlantMode) {
        for (int i = 28; i <= 34; ++i) {
            ItemMeta meta;
            ItemStack item = gui.getItem(i);
            if (item == null || item.getType() == Material.AIR || (meta = item.getItemMeta()) == null) continue;
            if (item.getType() == Material.GLOW_BERRIES) {
                ItemStack barrier = new ItemStack(Material.BARRIER);
                ItemMeta barrierMeta = barrier.getItemMeta();
                barrierMeta.setDisplayName(String.valueOf(ChatColor.RED) + this.languageManager.getString("gui.plant.glow_berries"));
                barrierMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + this.languageManager.getString("gui.range.unavailable")));
                barrier.setItemMeta(barrierMeta);
                gui.setItem(i, barrier);
                continue;
            }
            String materialName = item.getType().toString().toLowerCase();
            String langKey = "gui.plant." + materialName;
            String translatedName = this.languageManager.getString(langKey, materialName);
            meta.setDisplayName(String.valueOf(ChatColor.AQUA) + translatedName);
            if (item.getType().toString().equals(currentPlantMode)) {
                meta.addEnchant(Enchantment.LURE, 1, true);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                this.updateLoreWithStatus(meta, this.languageManager.getString("gui.selected"));
            } else {
                for (Enchantment enchantment : meta.getEnchants().keySet()) {
                    meta.removeEnchant(enchantment);
                }
                this.updateLoreWithStatus(meta, this.languageManager.getString("gui.not_selected"));
            }
            item.setItemMeta(meta);
        }
    }

    private void updateLoreWithStatus(ItemMeta meta, String statusLine) {
        ArrayList<String> lore = meta.hasLore() ? new ArrayList<String>(meta.getLore()) : new ArrayList();
        List<String> statusLinesToRemove = Arrays.asList(this.languageManager.getString("gui.selected"), this.languageManager.getString("gui.not_selected"), this.languageManager.getString("gui.range.click_to_select"), String.valueOf(ChatColor.GRAY) + this.languageManager.getString("gui.range.label") + " " + String.valueOf(ChatColor.GREEN) + "1x1", String.valueOf(ChatColor.GRAY) + this.languageManager.getString("gui.range.label") + " " + String.valueOf(ChatColor.GREEN) + "3x3", String.valueOf(ChatColor.GRAY) + this.languageManager.getString("gui.range.label") + " " + String.valueOf(ChatColor.GREEN) + "5x5", String.valueOf(ChatColor.GRAY) + this.languageManager.getString("gui.range.label") + " " + String.valueOf(ChatColor.GREEN) + "7x7", String.valueOf(ChatColor.GRAY) + this.languageManager.getString("gui.range.label") + " " + String.valueOf(ChatColor.GREEN) + "9x9");
        lore.removeIf(line -> {
            String cleanLine = ChatColor.stripColor((String)line);
            for (String toRemove : statusLinesToRemove) {
                if (!cleanLine.equals(ChatColor.stripColor((String)toRemove))) continue;
                return true;
            }
            String rangeLabel = this.languageManager.getString("gui.range.label");
            return cleanLine.startsWith(ChatColor.stripColor((String)rangeLabel));
        });
        lore.add(statusLine);
        meta.setLore(lore);
    }

    private int getHoeLevel(String hoeType) {
        if (hoeType == null) {
            return 0;
        }
        if (hoeType.startsWith("WOODEN")) {
            return 1;
        }
        if (hoeType.startsWith("STONE")) {
            return 2;
        }
        if (hoeType.startsWith("IRON")) {
            return 3;
        }
        if (hoeType.startsWith("GOLDEN")) {
            return 4;
        }
        if (hoeType.startsWith("DIAMOND")) {
            return 5;
        }
        return 0;
    }

    private int getMaxRangeForLevel(int level) {
        return level;
    }

    private String getRangeDescription(int range) {
        switch (range) {
            case 1: {
                return "1x1";
            }
            case 2: {
                return "3x3";
            }
            case 3: {
                return "5x5";
            }
            case 4: {
                return "7x7";
            }
            case 5: {
                return "9x9";
            }
        }
        return "Unknown";
    }

    public void openEditor(Player player) {
        Inventory editorGui = this.loadGuiFromFile(EDITOR_TITLE);
        if (editorGui == null) {
            editorGui = Bukkit.createInventory(null, (int)54, (String)EDITOR_TITLE);
            this.fillWithDefaultItems(editorGui);
        }
        player.openInventory(editorGui);
    }

    private void fillWithDefaultItems(Inventory inventory) {
        ItemStack borderItem = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
        ItemMeta borderMeta = borderItem.getItemMeta();
        borderMeta.setDisplayName(" ");
        borderItem.setItemMeta(borderMeta);
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (i >= 9 && i <= 44 && i % 9 != 0 && i % 9 != 8) continue;
            inventory.setItem(i, borderItem);
        }
    }

    private Inventory loadGuiFromFile(String title) {
        File guiFile = new File(this.plugin.getDataFolder(), "gui.yml");
        if (!guiFile.exists()) {
            return null;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)guiFile);
        int size = config.getInt("size", 54);
        Inventory gui = Bukkit.createInventory(null, (int)size, (String)title);
        ConfigurationSection itemsSection = config.getConfigurationSection("items");
        if (itemsSection != null) {
            for (String slotStr : itemsSection.getKeys(false)) {
                try {
                    int slot = Integer.parseInt(slotStr);
                    ConfigurationSection itemSection = itemsSection.getConfigurationSection(slotStr);
                    if (itemSection == null) continue;
                    Material material = Material.valueOf((String)itemSection.getString("material", "AIR"));
                    ItemStack item = new ItemStack(material);
                    if (itemSection.contains("name") || itemSection.contains("lore")) {
                        ItemMeta meta = item.getItemMeta();
                        if (itemSection.contains("name")) {
                            String name = itemSection.getString("name");
                            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
                        }
                        if (itemSection.contains("lore")) {
                            List lore = itemSection.getStringList("lore");
                            ArrayList<String> coloredLore = new ArrayList<String>();
                            for (String line : lore) {
                                coloredLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
                            }
                            meta.setLore(coloredLore);
                        }
                        item.setItemMeta(meta);
                    }
                    gui.setItem(slot, item);
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("Invalid slot or material in gui.yml: " + slotStr);
                }
            }
        }
        return gui;
    }

    public void saveGuiToFile(Inventory inventory) {
        YamlConfiguration config = new YamlConfiguration();
        config.set("title", (Object)inventory.getType().getDefaultTitle());
        config.set("size", (Object)inventory.getSize());
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (item == null || item.getType() == Material.AIR) continue;
            String path = "items." + i;
            config.set(path + ".material", (Object)item.getType().toString());
            if (!item.hasItemMeta()) continue;
            ItemMeta meta = item.getItemMeta();
            if (meta.hasDisplayName()) {
                config.set(path + ".name", (Object)meta.getDisplayName().replace('\u00a7', '&'));
            }
            if (!meta.hasLore()) continue;
            List lore = meta.getLore();
            ArrayList<String> uncoloredLore = new ArrayList<String>();
            for (String line : lore) {
                uncoloredLore.add(line.replace('\u00a7', '&'));
            }
            config.set(path + ".lore", uncoloredLore);
        }
        try {
            config.save(new File(this.plugin.getDataFolder(), "gui.yml"));
            this.plugin.getLogger().info("GUI saved to gui.yml");
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save GUI to file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public ItemMeta updateHoeLore(ItemMeta meta) {
        if (meta == null) {
            return null;
        }
        ArrayList<Object> newLore = new ArrayList<Object>();
        String hoeType = (String)meta.getPersistentDataContainer().get(this.hoeTypeKey, PersistentDataType.STRING);
        if (hoeType != null) {
            List<String> baseLore = this.languageManager.getStringList("item.superhoe_lore");
            newLore.addAll(baseLore);
        }
        newLore.add(" ");
        boolean isFarmingMode = (Byte)meta.getPersistentDataContainer().getOrDefault(this.hoeModeKey, PersistentDataType.BYTE, (Object)1) == 1;
        String modeKey = isFarmingMode ? "gui.mode.farming" : "gui.mode.bonemeal";
        newLore.add(String.valueOf(ChatColor.GRAY) + this.languageManager.getOrDefault("gui.mode.label", "Mode:") + " " + String.valueOf(ChatColor.YELLOW) + this.languageManager.getString(modeKey));
        int currentRange = (Integer)meta.getPersistentDataContainer().getOrDefault(this.hoeRangeKey, PersistentDataType.INTEGER, (Object)1);
        newLore.add(String.valueOf(ChatColor.GRAY) + this.languageManager.getOrDefault("gui.range.label", "Range:") + " " + String.valueOf(ChatColor.GREEN) + this.getRangeDescription(currentRange));
        if (isFarmingMode) {
            String plantMode = (String)meta.getPersistentDataContainer().getOrDefault(this.hoePlantModeKey, PersistentDataType.STRING, (Object)"LILY_PAD");
            String plantModeKey = "gui.plant." + plantMode.toLowerCase();
            String plantModeName = this.languageManager.getString(plantModeKey, plantMode);
            newLore.add(String.valueOf(ChatColor.GRAY) + this.languageManager.getOrDefault("gui.plant.label", "Planting:") + " " + String.valueOf(ChatColor.AQUA) + plantModeName);
        }
        meta.setLore(newLore);
        return meta;
    }
}

