/*
 * Decompiled with CFR 0.152.
 */
package org.little100.super_Farming.language;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.little100.super_Farming.Super_Farming;

public class LanguageManager {
    private final Super_Farming plugin;
    private final Map<String, FileConfiguration> languageFiles = new HashMap<String, FileConfiguration>();
    private String defaultLanguage = "zh_cn";

    public LanguageManager(Super_Farming plugin) {
        this.plugin = plugin;
        this.createDefaultLanguageFiles();
        this.loadLanguages();
    }

    public void reloadLanguages() {
        this.languageFiles.clear();
        this.loadLanguages();
    }

    private void loadLanguages() {
        File[] langFiles;
        File langDir = new File(this.plugin.getDataFolder(), "lang");
        if (!langDir.exists()) {
            langDir.mkdirs();
        }
        if ((langFiles = langDir.listFiles((dir, name) -> name.endsWith(".yml"))) != null) {
            for (File file : langFiles) {
                String langCode = file.getName().replace(".yml", "");
                this.languageFiles.put(langCode, (FileConfiguration)YamlConfiguration.loadConfiguration((File)file));
            }
        }
    }

    private void createDefaultLanguageFiles() {
        this.createLanguageFileIfNotExists("zh_cn");
        this.createLanguageFileIfNotExists("en_us");
        this.createLanguageFileIfNotExists("lzh");
    }

    private void createLanguageFileIfNotExists(String langCode) {
        File langFile;
        File langFolder = new File(this.plugin.getDataFolder(), "lang");
        if (!langFolder.exists()) {
            langFolder.mkdirs();
        }
        if (!(langFile = new File(langFolder, langCode + ".yml")).exists()) {
            this.plugin.saveResource("lang/" + langCode + ".yml", false);
        }
    }

    public String getString(String key) {
        return this.getString(key, this.defaultLanguage);
    }

    public String getString(String key, String lang) {
        FileConfiguration config = this.languageFiles.get(lang);
        if (config != null && config.contains(key)) {
            String message = config.getString(key);
            return message != null ? ChatColor.translateAlternateColorCodes((char)'&', (String)message) : key;
        }
        if (!lang.equals(this.defaultLanguage) && (config = this.languageFiles.get(this.defaultLanguage)) != null && config.contains(key)) {
            String message = config.getString(key);
            return message != null ? ChatColor.translateAlternateColorCodes((char)'&', (String)message) : key;
        }
        return key;
    }

    public String getOrDefault(String key, String defaultValue) {
        String value = this.getString(key);
        return value.equals(key) ? defaultValue : value;
    }

    public List<String> getStringList(String key) {
        return this.getStringList(key, this.defaultLanguage);
    }

    public List<String> getStringList(String key, String lang) {
        FileConfiguration config = this.languageFiles.get(lang);
        ArrayList<String> result = new ArrayList<String>();
        if (config != null && config.isList(key)) {
            for (String line : config.getStringList(key)) {
                result.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
            }
            return result;
        }
        if (!lang.equals(this.defaultLanguage) && (config = this.languageFiles.get(this.defaultLanguage)) != null && config.isList(key)) {
            for (String line : config.getStringList(key)) {
                result.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
            }
            return result;
        }
        return result;
    }

    public void setDefaultLanguage(String langCode) {
        if (this.languageFiles.containsKey(langCode)) {
            this.defaultLanguage = langCode;
        }
    }
}

