/*
 * Decompiled with CFR 0.152.
 */
package org.little100.super_Farming.listener;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.little100.super_Farming.Super_Farming;
import org.little100.super_Farming.data.DatabaseManager;
import org.little100.super_Farming.data.FarmData;
import org.little100.super_Farming.farm.FarmManager;
import org.little100.super_Farming.item.ItemManager;

public class FarmListener
implements Listener {
    private final Super_Farming plugin;
    private final FarmManager farmManager;
    private final Map<UUID, Long> playerCooldowns = new ConcurrentHashMap<UUID, Long>();
    private static final long COOLDOWN_TIME_MS = 1000L;

    public FarmListener(Super_Farming plugin, FarmManager farmManager) {
        this.plugin = plugin;
        this.farmManager = farmManager;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        Block clickedBlock = event.getClickedBlock();
        if (!player.isSneaking() || event.getAction() != Action.RIGHT_CLICK_BLOCK || clickedBlock == null) {
            return;
        }
        if (clickedBlock.getType() == Material.COMPOSTER) {
            String locationString;
            ItemStack itemInHand = player.getInventory().getItemInMainHand();
            DatabaseManager dbManager = this.plugin.getDatabaseManager();
            if (dbManager.farmExists(locationString = this.locationToString(clickedBlock.getLocation()))) {
                event.setCancelled(true);
                this.handleFarmRetrieval(player, dbManager, locationString);
                return;
            }
            if (this.isTier2SuperHoe(itemInHand)) {
                event.setCancelled(true);
                this.handleFarmCreation(player, itemInHand, dbManager, locationString, clickedBlock.getLocation());
            }
        }
    }

    private void handleFarmCreation(Player player, ItemStack itemInHand, DatabaseManager dbManager, String locationString, Location blockLocation) {
        Location armorStandLocation = blockLocation.clone().add(0.5, 1.0, 0.5);
        ArmorStand armorStand = (ArmorStand)player.getWorld().spawnEntity(armorStandLocation, EntityType.ARMOR_STAND);
        armorStand.setVisible(false);
        armorStand.setGravity(false);
        armorStand.setInvulnerable(true);
        armorStand.setSilent(true);
        armorStand.addScoreboardTag("super_farm_armor_stand");
        armorStand.getEquipment().setItemInMainHand(itemInHand.clone());
        String hoeData = DatabaseManager.itemStackToBase64(itemInHand);
        dbManager.addFarm(locationString, player.getUniqueId().toString(), hoeData, armorStand.getUniqueId().toString());
        this.farmManager.addFarm(new FarmData(locationString, player.getUniqueId().toString(), hoeData, armorStand.getUniqueId().toString()));
        itemInHand.setAmount(itemInHand.getAmount() - 1);
        player.sendMessage(this.plugin.getLanguageManager().getString("farm.activated"));
    }

    private void handleFarmRetrieval(Player player, DatabaseManager dbManager, String locationString) {
        long lastAction;
        long now = System.currentTimeMillis();
        if (now - (lastAction = this.playerCooldowns.getOrDefault(player.getUniqueId(), 0L).longValue()) < 1000L) {
            return;
        }
        this.playerCooldowns.put(player.getUniqueId(), now);
        FarmData farmData = dbManager.getFarm(locationString);
        if (farmData == null) {
            return;
        }
        if (!farmData.getOwnerUuid().equals(player.getUniqueId().toString()) && !player.hasPermission("super_farming.admin.bypass")) {
            player.sendMessage(this.plugin.getLanguageManager().getString("farm.not_yours"));
            return;
        }
        this.farmManager.removeFarm(locationString);
        dbManager.removeFarm(locationString);
        Runnable removeTask = () -> {
            Entity armorStandEntity = Bukkit.getServer().getEntity(UUID.fromString(farmData.getArmorStandUuid()));
            if (armorStandEntity != null) {
                ArmorStand armorStand;
                if (armorStandEntity instanceof ArmorStand && (armorStand = (ArmorStand)armorStandEntity).getEquipment() != null) {
                    armorStand.getEquipment().setItemInMainHand(null);
                }
                armorStandEntity.remove();
            }
        };
        if (Super_Farming.isFolia()) {
            try {
                Method getSchedulerMethod = player.getClass().getMethod("getScheduler", new Class[0]);
                Object playerScheduler = getSchedulerMethod.invoke((Object)player, new Object[0]);
                Method runDelayedMethod = playerScheduler.getClass().getMethod("runDelayed", Plugin.class, Consumer.class, Runnable.class, Long.TYPE);
                Consumer<Object> task = scheduledTask -> removeTask.run();
                runDelayedMethod.invoke(playerScheduler, new Object[]{this.plugin, task, null, 1L});
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Folia reflection for Player.getScheduler() failed! This may cause a crash. Error: " + e.getMessage());
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, removeTask, 1L);
            }
        } else {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, removeTask, 1L);
        }
        ItemStack hoe = DatabaseManager.itemStackFromBase64(farmData.getHoeData());
        if (player.getInventory().firstEmpty() == -1) {
            player.getWorld().dropItemNaturally(player.getLocation(), hoe);
            player.sendMessage(this.plugin.getLanguageManager().getString("farm.inventory_full"));
        } else {
            player.getInventory().addItem(new ItemStack[]{hoe});
        }
        player.sendMessage(this.plugin.getLanguageManager().getString("farm.deactivated"));
    }

    private String locationToString(Location location) {
        return location.getWorld().getName() + "," + location.getBlockX() + "," + location.getBlockY() + "," + location.getBlockZ();
    }

    @EventHandler
    public void onArmorStandManipulate(PlayerArmorStandManipulateEvent event) {
        ArmorStand armorStand = event.getRightClicked();
        if (!armorStand.getScoreboardTags().contains("super_farm_armor_stand")) {
            return;
        }
        Player player = event.getPlayer();
        String locationString = this.locationToString(armorStand.getLocation().subtract(0.5, 1.0, 0.5));
        FarmData farmData = this.plugin.getDatabaseManager().getFarm(locationString);
        if (farmData == null) {
            if (player.isOp()) {
                armorStand.remove();
            }
            event.setCancelled(true);
            return;
        }
        if (!farmData.getOwnerUuid().equals(player.getUniqueId().toString()) && !player.hasPermission("super_farming.admin.bypass")) {
            event.setCancelled(true);
            player.sendMessage(this.plugin.getLanguageManager().getString("farm.not_yours"));
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (block.getType() != Material.COMPOSTER) {
            return;
        }
        String locationString = this.locationToString(block.getLocation());
        DatabaseManager dbManager = this.plugin.getDatabaseManager();
        if (dbManager.farmExists(locationString)) {
            Player player = event.getPlayer();
            FarmData farmData = dbManager.getFarm(locationString);
            if (farmData == null) {
                return;
            }
            if (farmData.getOwnerUuid().equals(player.getUniqueId().toString())) {
                this.handleFarmRetrieval(player, dbManager, locationString);
            } else {
                event.setCancelled(true);
                player.sendMessage(this.plugin.getLanguageManager().getString("farm.cannot_break"));
            }
        }
    }

    @EventHandler
    public void onPlayerInteractAtEntity(PlayerInteractAtEntityEvent event) {
        ArmorStand armorStand;
        if (event.getRightClicked() instanceof ArmorStand && (armorStand = (ArmorStand)event.getRightClicked()).getScoreboardTags().contains("super_farm_armor_stand")) {
            event.setCancelled(true);
        }
    }

    private boolean isTier2SuperHoe(ItemStack item) {
        if (item == null || !item.getType().toString().endsWith("_HOE")) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer data = meta.getPersistentDataContainer();
        if (!data.has(ItemManager.SUPERHOE_KEY, PersistentDataType.STRING)) {
            return false;
        }
        String key = (String)data.get(ItemManager.SUPERHOE_KEY, PersistentDataType.STRING);
        return key != null && key.endsWith("_TIER2");
    }
}

