/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimatorapi.API;

import com.zigythebird.multiloaderutils.utils.NetworkManager;
import com.zigythebird.playeranimatorapi.data.PlayerAnimationData;
import com.zigythebird.playeranimatorapi.data.PlayerParts;
import com.zigythebird.playeranimatorapi.example.FirstPersonExample;
import com.zigythebird.playeranimatorapi.misc.PlayerInterface;
import com.zigythebird.playeranimatorapi.modifier.CommonModifier;
import com.zigythebird.playeranimatorapi.utils.CommonPlayerLookup;
import dev.kosmx.playerAnim.core.util.Pair;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public class PlayerAnimAPI {
    public static final class_2960 playerAnimPacket = class_2960.method_60655((String)"playeranimatorapi", (String)"player_anim");
    public static final class_2960 playerAnimStopPacket = class_2960.method_60655((String)"playeranimatorapi", (String)"player_anim_stop");

    public static void playPlayerAnim(class_3218 level, class_1657 player, class_2960 animationID) {
        PlayerAnimAPI.playPlayerAnim(level, player, animationID, PlayerParts.allEnabled, null, -1, -1, 1000, 0);
    }

    public static void playPlayerAnim(class_3218 level, class_1657 player, class_2960 animationID, PlayerParts parts, List<CommonModifier> modifiers, int priority) {
        PlayerAnimAPI.playPlayerAnim(level, player, animationID, parts, modifiers, -1, -1, priority, 0);
    }

    public static void playPlayerAnim(class_3218 level, class_1657 player, class_2960 animationID, PlayerParts parts, List<CommonModifier> modifiers, int fadeLength, int easeID, int priority, boolean firstPersonEnabled) {
        if (firstPersonEnabled) {
            modifiers.add(FirstPersonExample.FIRST_PERSON_MODIFIER);
        }
        PlayerAnimAPI.playPlayerAnim(level, player, animationID, parts, modifiers, fadeLength, easeID, priority, 0);
    }

    public static void playPlayerAnim(class_3218 level, class_1657 player, class_2960 animationID, PlayerParts parts, List<CommonModifier> modifiers, int fadeLength, int easeID, int priority, int startTick) {
        PlayerAnimationData data = new PlayerAnimationData(player.method_5667(), animationID, parts, modifiers, fadeLength, easeID, priority, startTick);
        PlayerAnimAPI.playPlayerAnim(level, player, data);
    }

    public static void playPlayerAnim(class_3218 level, class_1657 player, PlayerAnimationData data) {
        Pair<Integer, PlayerAnimationData> oldData;
        if (data.animationID() == null) {
            return;
        }
        class_2540 buf = new class_2540(Unpooled.buffer());
        PlayerAnimationData.STREAM_CODEC.encode((Object)buf, (Object)data);
        NetworkManager.sendToPlayers(CommonPlayerLookup.tracking(level, player.method_31476()), (class_2960)playerAnimPacket, (class_2540)buf);
        if (data.startTick() < 0 && (oldData = ((PlayerInterface)player).paapi$getLastAnim()) != null) {
            int ticksPassed = player.field_6012 - (Integer)oldData.getLeft();
            ((PlayerInterface)player).setLastAnim(data.getDataWithStartTick(ticksPassed));
            return;
        }
        ((PlayerInterface)player).setLastAnim(data);
    }

    public static void stopPlayerAnim(class_3218 level, class_1657 player, class_2960 animationID) {
        if (animationID == null) {
            return;
        }
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10797(player.method_5667());
        buf.method_10812(animationID);
        NetworkManager.sendToPlayers(CommonPlayerLookup.tracking(level, player.method_31476()), (class_2960)playerAnimStopPacket, (class_2540)buf);
        Pair<Integer, PlayerAnimationData> data = ((PlayerInterface)player).paapi$getLastAnim();
        if (data != null && ((PlayerAnimationData)data.getRight()).animationID().equals((Object)animationID)) {
            ((PlayerInterface)player).setLastAnim(null);
        }
    }
}

