/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimatorapi.API;

import com.zigythebird.multiloaderutils.misc.ModLoader;
import com.zigythebird.multiloaderutils.utils.Platform;
import com.zigythebird.playeranimatorapi.compatibility.FlashbackCompat;
import com.zigythebird.playeranimatorapi.compatibility.ReplayModCompat;
import com.zigythebird.playeranimatorapi.data.PlayerAnimationData;
import com.zigythebird.playeranimatorapi.data.PlayerParts;
import com.zigythebird.playeranimatorapi.example.FirstPersonExample;
import com.zigythebird.playeranimatorapi.modifier.CommonModifier;
import com.zigythebird.playeranimatorapi.playeranims.PlayerAnimations;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_742;

@Environment(value=EnvType.CLIENT)
public class PlayerAnimAPIClient {
    public static void playPlayerAnim(class_742 player, class_2960 animationID) {
        PlayerAnimAPIClient.playPlayerAnim(player, animationID, PlayerParts.allEnabled, null, 1000);
    }

    public static void playPlayerAnim(class_742 player, class_2960 animationID, PlayerParts parts, List<CommonModifier> modifiers, int priority) {
        PlayerAnimAPIClient.playPlayerAnim(player, animationID, parts, modifiers, -1, -1, priority, 0);
    }

    public static void playPlayerAnim(class_742 player, PlayerAnimationData data) {
        boolean isFabric = Platform.getLoader().equals((Object)ModLoader.Fabric);
        if (isFabric && Platform.isModLoaded((String)"replaymod") || Platform.isModLoaded((String)"reforgedplaymod")) {
            ReplayModCompat.playPlayerAnim(player, data.animationID(), data.parts(), data.modifiers(), data.fadeLength(), data.easeID(), data.priority(), data.startTick());
        }
        if (isFabric && Platform.isModLoaded((String)"flashback")) {
            FlashbackCompat.playPlayerAnim(player, data.animationID(), data.parts(), data.modifiers(), data.fadeLength(), data.easeID(), data.priority(), data.startTick());
        }
        PlayerAnimations.playAnimation((class_1657)player, data);
    }

    public static void playPlayerAnim(class_742 player, class_2960 animationID, PlayerParts parts, List<CommonModifier> modifiers, int fadeLength, int easeID, int priority, boolean firstPersonEnabled, boolean replaceTick) {
        if (firstPersonEnabled) {
            modifiers.add(FirstPersonExample.FIRST_PERSON_MODIFIER);
        }
        int startTick = replaceTick ? 0 : -1;
        PlayerAnimAPIClient.playPlayerAnim(player, animationID, parts, modifiers, fadeLength, easeID, priority, startTick);
    }

    public static void playPlayerAnim(class_742 player, class_2960 animationID, PlayerParts parts, List<CommonModifier> modifiers, int fadeLength, int easeID, int priority, int startTick) {
        boolean isFabric = Platform.getLoader().equals((Object)ModLoader.Fabric);
        if (isFabric && Platform.isModLoaded((String)"replaymod") || Platform.isModLoaded((String)"reforgedplaymod")) {
            ReplayModCompat.playPlayerAnim(player, animationID, parts, modifiers, fadeLength, easeID, priority, startTick);
        }
        if (isFabric && Platform.isModLoaded((String)"flashback")) {
            FlashbackCompat.playPlayerAnim(player, animationID, parts, modifiers, fadeLength, easeID, priority, startTick);
        }
        PlayerAnimations.playAnimation((class_1657)player, new PlayerAnimationData(player.method_5667(), animationID, parts, modifiers, fadeLength, easeID, priority, 0));
    }

    public static void stopPlayerAnim(class_742 player, class_2960 animationID) {
        if (Platform.isModLoaded((String)"replaymod") && Platform.getLoader().equals((Object)ModLoader.Fabric)) {
            ReplayModCompat.stopPlayerAnim(player, animationID);
        }
        PlayerAnimations.stopAnimation(player, animationID);
    }
}

