/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimatorapi.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.zigythebird.playeranimatorapi.API.PlayerAnimAPI;
import com.zigythebird.playeranimatorapi.commands.CommandState;
import com.zigythebird.playeranimatorapi.data.PlayerParts;
import com.zigythebird.playeranimatorapi.modifier.CommonModifier;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class PlayPlayerAnimationCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"playPlayerAnimation").requires(commandSourceStack -> commandSourceStack.method_9259(2))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"animationID", (ArgumentType)class_2232.method_9441()).executes(context -> PlayPlayerAnimationCommand.execute((CommandContext<class_2168>)context, CommandState.Minimal))).then(class_2170.method_9244((String)"fadeLength", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"priority", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"easeID", (ArgumentType)IntegerArgumentType.integer()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"firstPersonEnabled", (ArgumentType)BoolArgumentType.bool()).executes(context -> PlayPlayerAnimationCommand.execute((CommandContext<class_2168>)context, CommandState.Advanced))).then(class_2170.method_9244((String)"playerParts", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"modifiers", (ArgumentType)StringArgumentType.string()).executes(context -> PlayPlayerAnimationCommand.execute((CommandContext<class_2168>)context, CommandState.Complete)))))))))));
    }

    private static int execute(CommandContext<class_2168> command, CommandState state) {
        block10: {
            try {
                switch (state) {
                    case Minimal: {
                        for (class_3222 player : class_2186.method_9312(command, (String)"player")) {
                            PlayerAnimAPI.playPlayerAnim((class_3218)player.method_37908(), (class_1657)player, class_2232.method_9443(command, (String)"animationID"));
                        }
                        break;
                    }
                    case Advanced: {
                        for (class_3222 player : class_2186.method_9312(command, (String)"player")) {
                            PlayerAnimAPI.playPlayerAnim(((class_2168)command.getSource()).method_9225(), (class_1657)player, class_2232.method_9443(command, (String)"animationID"), null, null, IntegerArgumentType.getInteger(command, (String)"fadeLength"), IntegerArgumentType.getInteger(command, (String)"easeID"), IntegerArgumentType.getInteger(command, (String)"priority"), BoolArgumentType.getBool(command, (String)"firstPersonEnabled"));
                        }
                        break;
                    }
                    case Complete: {
                        for (class_3222 player : class_2186.method_9312(command, (String)"player")) {
                            PlayerAnimAPI.playPlayerAnim(((class_2168)command.getSource()).method_9225(), (class_1657)player, class_2232.method_9443(command, (String)"animationID"), PlayerParts.fromBigInteger(PlayPlayerAnimationCommand.playerPartsIntFromString(StringArgumentType.getString(command, (String)"playerParts"))), PlayPlayerAnimationCommand.modifierList(StringArgumentType.getString(command, (String)"modifiers")), IntegerArgumentType.getInteger(command, (String)"fadeLength"), IntegerArgumentType.getInteger(command, (String)"easeID"), IntegerArgumentType.getInteger(command, (String)"priority"), BoolArgumentType.getBool(command, (String)"firstPersonEnabled"));
                        }
                        break;
                    }
                }
            }
            catch (CommandSyntaxException e) {
                class_3222 player = ((class_2168)command.getSource()).method_44023();
                if (player == null) break block10;
                player.method_43496((class_2561)class_2561.method_43470((String)e.getMessage()).method_27692(class_124.field_1061));
            }
        }
        return 1;
    }

    public static List<CommonModifier> modifierList(String input) {
        ArrayList<CommonModifier> list = new ArrayList<CommonModifier>();
        for (String str : input.split(";")) {
            list.add(new CommonModifier(class_2960.method_60654((String)str), null));
        }
        return list;
    }

    public static BigInteger playerPartsIntFromString(String string) {
        try {
            return new BigInteger(string, 36);
        }
        catch (NumberFormatException e) {
            return new BigInteger("axq5j8k4e1uiyz27", 36);
        }
    }
}

