/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimatorapi.mixin.gecko;

import com.zigythebird.playeranimatorapi.gecko.AnimatablePlayerLayer;
import com.zigythebird.playeranimatorapi.mixin.gecko.AnimatableManagerAccessor_geckoOnly;
import com.zigythebird.playeranimatorapi.mixin.gecko.AnimationControllerAccessor_geckoOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.class_3532;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationProcessor;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.EasingType;
import software.bernie.geckolib.animation.keyframe.AnimationPoint;
import software.bernie.geckolib.animation.keyframe.BoneAnimationQueue;
import software.bernie.geckolib.animation.state.BoneSnapshot;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;

@Mixin(value={AnimationProcessor.class})
public abstract class AnimationProcessorMixin_geckoOnly<T extends GeoAnimatable> {
    @Shadow(remap=false)
    public boolean reloadAnimations;
    @Shadow(remap=false)
    @Final
    private Map<String, GeoBone> bones;

    @Shadow(remap=false)
    protected abstract Map<String, BoneSnapshot> updateBoneSnapshots(Map<String, BoneSnapshot> var1);

    @Shadow(remap=false)
    protected abstract void resetBoneTransformationMarkers();

    @Shadow(remap=false)
    public abstract Collection<GeoBone> getRegisteredBones();

    @Inject(method={"tickAnimation"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void inject(T animatable, GeoModel<T> model, AnimatableManager<T> animatableManager, double animTime, AnimationState<T> state, boolean crashWhenCantFindBone, CallbackInfo ci) {
        if (animatable instanceof AnimatablePlayerLayer) {
            ArrayList<GeoBone> disabledBones = new ArrayList<GeoBone>();
            AnimationProcessorMixin_geckoOnly.addDisabled(disabledBones, "body", model);
            AnimationProcessorMixin_geckoOnly.addDisabled(disabledBones, "head", model);
            AnimationProcessorMixin_geckoOnly.addDisabled(disabledBones, "torso", model);
            AnimationProcessorMixin_geckoOnly.addDisabled(disabledBones, "right_arm", model);
            AnimationProcessorMixin_geckoOnly.addDisabled(disabledBones, "left_arm", model);
            AnimationProcessorMixin_geckoOnly.addDisabled(disabledBones, "right_leg", model);
            AnimationProcessorMixin_geckoOnly.addDisabled(disabledBones, "left_leg", model);
            Map<String, BoneSnapshot> boneSnapshots = this.updateBoneSnapshots(animatableManager.getBoneSnapshotCollection());
            for (AnimationController controller : animatableManager.getAnimationControllers().values()) {
                if (this.reloadAnimations) {
                    controller.forceAnimationReset();
                    controller.getBoneAnimationQueues().clear();
                }
                ((AnimationControllerAccessor_geckoOnly)controller).setIsJustStarting(animatableManager.isFirstTick());
                state.withController(controller);
                controller.process(model, state, this.bones, boneSnapshots, animTime, crashWhenCantFindBone);
                for (BoneAnimationQueue boneAnimation : controller.getBoneAnimationQueues().values()) {
                    GeoBone bone = boneAnimation.bone();
                    if (disabledBones.contains(bone)) continue;
                    BoneSnapshot snapshot = boneSnapshots.get(bone.getName());
                    BoneSnapshot initialSnapshot = bone.getInitialSnapshot();
                    AnimationPoint rotXPoint = (AnimationPoint)boneAnimation.rotationXQueue().poll();
                    AnimationPoint rotYPoint = (AnimationPoint)boneAnimation.rotationYQueue().poll();
                    AnimationPoint rotZPoint = (AnimationPoint)boneAnimation.rotationZQueue().poll();
                    AnimationPoint posXPoint = (AnimationPoint)boneAnimation.positionXQueue().poll();
                    AnimationPoint posYPoint = (AnimationPoint)boneAnimation.positionYQueue().poll();
                    AnimationPoint posZPoint = (AnimationPoint)boneAnimation.positionZQueue().poll();
                    AnimationPoint scaleXPoint = (AnimationPoint)boneAnimation.scaleXQueue().poll();
                    AnimationPoint scaleYPoint = (AnimationPoint)boneAnimation.scaleYQueue().poll();
                    AnimationPoint scaleZPoint = (AnimationPoint)boneAnimation.scaleZQueue().poll();
                    EasingType easingType = ((AnimationControllerAccessor_geckoOnly)controller).getOverrideEasingTypeFunction().apply(animatable);
                    if (rotXPoint != null && rotYPoint != null && rotZPoint != null) {
                        bone.setRotX((float)EasingType.lerpWithOverride((AnimationPoint)rotXPoint, (EasingType)easingType) + initialSnapshot.getRotX());
                        bone.setRotY((float)EasingType.lerpWithOverride((AnimationPoint)rotYPoint, (EasingType)easingType) + initialSnapshot.getRotY());
                        bone.setRotZ((float)EasingType.lerpWithOverride((AnimationPoint)rotZPoint, (EasingType)easingType) + initialSnapshot.getRotZ());
                        snapshot.updateRotation(bone.getRotX(), bone.getRotY(), bone.getRotZ());
                        snapshot.startRotAnim();
                        bone.markRotationAsChanged();
                    }
                    if (posXPoint != null && posYPoint != null && posZPoint != null) {
                        bone.setPosX((float)EasingType.lerpWithOverride((AnimationPoint)posXPoint, (EasingType)easingType));
                        bone.setPosY((float)EasingType.lerpWithOverride((AnimationPoint)posYPoint, (EasingType)easingType));
                        bone.setPosZ((float)EasingType.lerpWithOverride((AnimationPoint)posZPoint, (EasingType)easingType));
                        snapshot.updateOffset(bone.getPosX(), bone.getPosY(), bone.getPosZ());
                        snapshot.startPosAnim();
                        bone.markPositionAsChanged();
                    }
                    if (scaleXPoint == null || scaleYPoint == null || scaleZPoint == null) continue;
                    bone.setScaleX((float)EasingType.lerpWithOverride((AnimationPoint)scaleXPoint, (EasingType)easingType));
                    bone.setScaleY((float)EasingType.lerpWithOverride((AnimationPoint)scaleYPoint, (EasingType)easingType));
                    bone.setScaleZ((float)EasingType.lerpWithOverride((AnimationPoint)scaleZPoint, (EasingType)easingType));
                    snapshot.updateScale(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
                    snapshot.startScaleAnim();
                    bone.markScaleAsChanged();
                }
            }
            this.reloadAnimations = false;
            double resetTickLength = animatable.getBoneResetTime();
            for (GeoBone bone : this.getRegisteredBones()) {
                double percentageReset;
                BoneSnapshot saveSnapshot;
                BoneSnapshot initialSnapshot;
                if (!bone.hasRotationChanged()) {
                    initialSnapshot = bone.getInitialSnapshot();
                    saveSnapshot = boneSnapshots.get(bone.getName());
                    if (saveSnapshot.isRotAnimInProgress()) {
                        saveSnapshot.stopRotAnim(animTime);
                    }
                    percentageReset = Math.min((animTime - saveSnapshot.getLastResetRotationTick()) / resetTickLength, 1.0);
                    bone.setRotX((float)class_3532.method_16436((double)percentageReset, (double)saveSnapshot.getRotX(), (double)initialSnapshot.getRotX()));
                    bone.setRotY((float)class_3532.method_16436((double)percentageReset, (double)saveSnapshot.getRotY(), (double)initialSnapshot.getRotY()));
                    bone.setRotZ((float)class_3532.method_16436((double)percentageReset, (double)saveSnapshot.getRotZ(), (double)initialSnapshot.getRotZ()));
                    if (percentageReset >= 1.0) {
                        saveSnapshot.updateRotation(bone.getRotX(), bone.getRotY(), bone.getRotZ());
                    }
                }
                if (!bone.hasPositionChanged()) {
                    initialSnapshot = bone.getInitialSnapshot();
                    saveSnapshot = boneSnapshots.get(bone.getName());
                    if (saveSnapshot.isPosAnimInProgress()) {
                        saveSnapshot.stopPosAnim(animTime);
                    }
                    percentageReset = Math.min((animTime - saveSnapshot.getLastResetPositionTick()) / resetTickLength, 1.0);
                    bone.setPosX((float)class_3532.method_16436((double)percentageReset, (double)saveSnapshot.getOffsetX(), (double)initialSnapshot.getOffsetX()));
                    bone.setPosY((float)class_3532.method_16436((double)percentageReset, (double)saveSnapshot.getOffsetY(), (double)initialSnapshot.getOffsetY()));
                    bone.setPosZ((float)class_3532.method_16436((double)percentageReset, (double)saveSnapshot.getOffsetZ(), (double)initialSnapshot.getOffsetZ()));
                    if (percentageReset >= 1.0) {
                        saveSnapshot.updateOffset(bone.getPosX(), bone.getPosY(), bone.getPosZ());
                    }
                }
                if (bone.hasScaleChanged()) continue;
                initialSnapshot = bone.getInitialSnapshot();
                saveSnapshot = boneSnapshots.get(bone.getName());
                if (saveSnapshot.isScaleAnimInProgress()) {
                    saveSnapshot.stopScaleAnim(animTime);
                }
                percentageReset = Math.min((animTime - saveSnapshot.getLastResetScaleTick()) / resetTickLength, 1.0);
                bone.setScaleX((float)class_3532.method_16436((double)percentageReset, (double)saveSnapshot.getScaleX(), (double)initialSnapshot.getScaleX()));
                bone.setScaleY((float)class_3532.method_16436((double)percentageReset, (double)saveSnapshot.getScaleY(), (double)initialSnapshot.getScaleY()));
                bone.setScaleZ((float)class_3532.method_16436((double)percentageReset, (double)saveSnapshot.getScaleZ(), (double)initialSnapshot.getScaleZ()));
                if (!(percentageReset >= 1.0)) continue;
                saveSnapshot.updateScale(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
            }
            this.resetBoneTransformationMarkers();
            ((AnimatableManagerAccessor_geckoOnly)animatableManager).callFinishFirstTick();
            ci.cancel();
        }
    }

    @Unique
    private static void addDisabled(List<GeoBone> list, String bone, GeoModel model) {
        if (model.getBone(bone).isPresent()) {
            list.add((GeoBone)model.getBone(bone).get());
        }
    }
}

