/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimatorapi.playeranims;

import com.zigythebird.multiloaderutils.utils.NetworkManager;
import com.zigythebird.multiloaderutils.utils.Platform;
import com.zigythebird.playeranimatorapi.ModInit;
import com.zigythebird.playeranimatorapi.data.PlayerAnimationData;
import com.zigythebird.playeranimatorapi.data.PlayerParts;
import com.zigythebird.playeranimatorapi.gecko.ModGeckoUtilsClient;
import com.zigythebird.playeranimatorapi.mixin.AnimationStackAccessor;
import com.zigythebird.playeranimatorapi.modifier.CommonModifier;
import com.zigythebird.playeranimatorapi.playeranims.ConditionalAnimations;
import com.zigythebird.playeranimatorapi.playeranims.CustomModifierLayer;
import com.zigythebird.playeranimatorapi.registry.AnimModifierRegistry;
import dev.kosmx.playerAnim.api.IPlayable;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.core.util.Pair;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationFactory;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_742;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public class PlayerAnimations {
    private static final Logger logger = LogManager.getLogger(ModInit.class);
    public static Map<class_2960, Float> animLengthsMap;
    public static Map<class_2960, class_2960> geckoMap;
    public static final class_2960 playerAnimPacket;
    public static final class_2960 playerAnimStopPacket;
    public static final class_2960 animationLayerId;

    public static void init() {
        PlayerAnimationFactory.ANIMATION_DATA_FACTORY.registerFactory(animationLayerId, 1000, player -> new CustomModifierLayer(player, animationLayerId));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)playerAnimPacket, (buf, context) -> PlayerAnimations.playAnimation((PlayerAnimationData)PlayerAnimationData.STREAM_CODEC.decode((Object)buf)));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)playerAnimStopPacket, (buf, context) -> PlayerAnimations.stopAnimation(buf.method_10790(), buf.method_10810()));
    }

    public static void stopAnimation(UUID playerUUID, class_2960 animationID) {
        PlayerAnimations.stopAnimation((class_742)class_310.method_1551().field_1687.method_18470(playerUUID), animationID);
    }

    public static void stopAnimation(class_742 player, class_2960 animationID) {
        CustomModifierLayer animationContainer = PlayerAnimations.getModifierLayer(player);
        if (animationContainer != null && animationContainer.isActive() && animationContainer.data.animationID().equals((Object)animationID)) {
            animationContainer.animPlayer.stop();
            if (Platform.isModLoaded((String)"geckolib")) {
                ModGeckoUtilsClient.stopGeckoAnimation(player);
            }
        }
    }

    public static void playAnimation(PlayerAnimationData data) {
        PlayerAnimations.playAnimation((class_742)class_310.method_1551().field_1687.method_18470(data.playerUUID()), data, data.parts(), data.modifiers(), data.fadeLength(), data.easeID(), data.startTick());
    }

    public static void playAnimation(class_1657 player, PlayerAnimationData data) {
        PlayerAnimations.playAnimation(player, data, data.startTick());
    }

    public static void playAnimation(class_1657 player, PlayerAnimationData data, int startTick) {
        PlayerAnimations.playAnimation((class_742)player, data, data.parts(), data.modifiers(), data.fadeLength(), data.easeID(), startTick);
    }

    public static void playAnimation(class_742 player, PlayerAnimationData data, PlayerParts parts, List<CommonModifier> modifiers, int fadeLength, int easeID, int startTick) {
        try {
            KeyframeAnimation anim;
            CustomModifierLayer animationContainer = PlayerAnimations.getModifierLayer(player);
            class_2960 baseAnimationID = data.animationID();
            if (baseAnimationID == null || baseAnimationID.toString().equals("null:null")) {
                return;
            }
            if (animationContainer.data != null && animationContainer.isActive() && animationContainer.data.priority() > animationContainer.data.priority()) {
                return;
            }
            class_2960 animationID = ConditionalAnimations.getAnimationForCurrentConditions(data);
            IPlayable playable = PlayerAnimationRegistry.getAnimation((class_2960)animationID);
            KeyframeAnimation keyframeAnimation = anim = playable instanceof KeyframeAnimation ? (KeyframeAnimation)playable : null;
            if (anim == null) {
                ModInit.LOGGER.error("Could not play animation with an id of " + String.valueOf(animationID) + ". It's either non-existent or not an instance of KeyframeAnimation.");
            }
            PlayerAnimations.setLayerPriorityForPlayer(data.priority(), (class_1657)player);
            animationContainer.setAnimationData(data);
            animationContainer.setCurrentAnimationLocation(animationID);
            animationContainer.removeAllModifiers();
            if (modifiers != null) {
                for (CommonModifier commonModifier : modifiers) {
                    if (commonModifier.modifier != null) {
                        animationContainer.addModifier((AbstractModifier)commonModifier.modifier);
                        continue;
                    }
                    if (!AnimModifierRegistry.getModifiers().containsKey(commonModifier.ID)) continue;
                    try {
                        animationContainer.addModifier(AnimModifierRegistry.getModifiers().get(commonModifier.ID).apply(animationContainer, commonModifier.data));
                    }
                    catch (NullPointerException | UnsupportedOperationException e) {
                        ModInit.LOGGER.error("Failed to apply modifier: " + String.valueOf(commonModifier.ID) + " :" + String.valueOf(e));
                    }
                }
            }
            if (parts != null) {
                KeyframeAnimation.AnimationBuilder builder = anim.mutableCopy();
                KeyframeAnimation.StateCollection body = builder.getPart("body");
                body.x.setEnabled(parts.body.x);
                body.y.setEnabled(parts.body.y);
                body.z.setEnabled(parts.body.z);
                body.pitch.setEnabled(parts.body.pitch);
                body.yaw.setEnabled(parts.body.yaw);
                body.roll.setEnabled(parts.body.roll);
                KeyframeAnimation.StateCollection head = builder.getPart("head");
                head.x.setEnabled(parts.head.x);
                head.y.setEnabled(parts.head.y);
                head.z.setEnabled(parts.head.z);
                head.pitch.setEnabled(parts.head.pitch);
                head.yaw.setEnabled(parts.head.yaw);
                head.roll.setEnabled(parts.head.roll);
                KeyframeAnimation.StateCollection torso = builder.getPart("torso");
                torso.x.setEnabled(parts.torso.x);
                torso.y.setEnabled(parts.torso.y);
                torso.z.setEnabled(parts.torso.z);
                torso.pitch.setEnabled(parts.torso.pitch);
                torso.yaw.setEnabled(parts.torso.yaw);
                torso.roll.setEnabled(parts.torso.roll);
                KeyframeAnimation.StateCollection rightArm = builder.getPart("rightArm");
                rightArm.x.setEnabled(parts.rightArm.x);
                rightArm.y.setEnabled(parts.rightArm.y);
                rightArm.z.setEnabled(parts.rightArm.z);
                rightArm.pitch.setEnabled(parts.rightArm.pitch);
                rightArm.yaw.setEnabled(parts.rightArm.yaw);
                rightArm.roll.setEnabled(parts.rightArm.roll);
                rightArm.bend.setEnabled(parts.rightArm.bend);
                rightArm.bendDirection.setEnabled(parts.rightArm.bendDirection);
                KeyframeAnimation.StateCollection leftArm = builder.getPart("leftArm");
                leftArm.x.setEnabled(parts.leftArm.x);
                leftArm.y.setEnabled(parts.leftArm.y);
                leftArm.z.setEnabled(parts.leftArm.z);
                leftArm.pitch.setEnabled(parts.leftArm.pitch);
                leftArm.yaw.setEnabled(parts.leftArm.yaw);
                leftArm.roll.setEnabled(parts.leftArm.roll);
                leftArm.bend.setEnabled(parts.leftArm.bend);
                leftArm.bendDirection.setEnabled(parts.leftArm.bendDirection);
                KeyframeAnimation.StateCollection rightLeg = builder.getPart("rightLeg");
                rightLeg.x.setEnabled(parts.rightLeg.x);
                rightLeg.y.setEnabled(parts.rightLeg.y);
                rightLeg.z.setEnabled(parts.rightLeg.z);
                rightLeg.pitch.setEnabled(parts.rightLeg.pitch);
                rightLeg.yaw.setEnabled(parts.rightLeg.yaw);
                rightLeg.roll.setEnabled(parts.rightLeg.roll);
                rightLeg.bend.setEnabled(parts.rightLeg.bend);
                rightLeg.bendDirection.setEnabled(parts.rightLeg.bendDirection);
                KeyframeAnimation.StateCollection leftLeg = builder.getPart("leftLeg");
                leftLeg.x.setEnabled(parts.leftLeg.x);
                leftLeg.y.setEnabled(parts.leftLeg.y);
                leftLeg.z.setEnabled(parts.leftLeg.z);
                leftLeg.pitch.setEnabled(parts.leftLeg.pitch);
                leftLeg.yaw.setEnabled(parts.leftLeg.yaw);
                leftLeg.roll.setEnabled(parts.leftLeg.roll);
                leftLeg.bend.setEnabled(parts.leftLeg.bend);
                leftLeg.bendDirection.setEnabled(parts.leftLeg.bendDirection);
                KeyframeAnimation.StateCollection rightItem = builder.getPart("rightItem");
                rightItem.x.setEnabled(parts.rightItem.x);
                rightItem.y.setEnabled(parts.rightItem.y);
                rightItem.z.setEnabled(parts.rightItem.z);
                rightItem.pitch.setEnabled(parts.rightItem.pitch);
                rightItem.yaw.setEnabled(parts.rightItem.yaw);
                rightItem.roll.setEnabled(parts.rightItem.roll);
                KeyframeAnimation.StateCollection leftItem = builder.getPart("leftItem");
                leftItem.x.setEnabled(parts.leftItem.x);
                leftItem.y.setEnabled(parts.leftItem.y);
                leftItem.z.setEnabled(parts.leftItem.z);
                leftItem.pitch.setEnabled(parts.leftItem.pitch);
                leftItem.yaw.setEnabled(parts.leftItem.yaw);
                leftItem.roll.setEnabled(parts.leftItem.roll);
                anim = builder.build();
            }
            if (startTick < 0 && animationContainer.isActive()) {
                startTick = animationContainer.animPlayer.getCurrentTick();
            }
            KeyframeAnimationPlayer animPlayer = new KeyframeAnimationPlayer(anim, startTick);
            if (fadeLength < 0) {
                fadeLength = Math.min(animPlayer.getStopTick() / 4, 20);
            }
            if (fadeLength > 0 && 0 <= easeID) {
                animationContainer.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)fadeLength, (Ease)PlayerAnimations.getEase(easeID)), animPlayer);
            } else {
                animationContainer.replaceAnimation(animPlayer);
            }
            if (Platform.isModLoaded((String)"geckolib")) {
                ModGeckoUtilsClient.playGeckoAnimation(player, data, animationContainer.getSpeed());
            }
        }
        catch (NullPointerException e) {
            logger.warn("Player Animator API failed to play player animation: " + String.valueOf(e));
        }
    }

    private static void setLayerPriorityForPlayer(int priority, class_1657 player) {
        AnimationStack animationStack = ((IAnimatedPlayer)player).getAnimationStack();
        IAnimation layer = null;
        if (priority == -1) {
            priority = 1000;
        }
        for (Pair<Integer, IAnimation> pair : ((AnimationStackAccessor)animationStack).getLayers()) {
            if (!(pair.getRight() instanceof CustomModifierLayer) || ((CustomModifierLayer)((Object)pair.getRight())).ID != animationLayerId) continue;
            layer = (IAnimation)pair.getRight();
            break;
        }
        if (layer != null) {
            animationStack.removeLayer(layer);
            animationStack.addAnimLayer(priority, layer);
        }
    }

    public static Ease getEase(int ID) {
        return Ease.getEase((byte)((byte)ID));
    }

    public static CustomModifierLayer getModifierLayer(class_742 player) {
        return (CustomModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((class_742)player).get(animationLayerId);
    }

    static {
        playerAnimPacket = class_2960.method_60655((String)"playeranimatorapi", (String)"player_anim");
        playerAnimStopPacket = class_2960.method_60655((String)"playeranimatorapi", (String)"player_anim_stop");
        animationLayerId = class_2960.method_60655((String)"playeranimatorapi", (String)"factory");
    }
}

