/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimatorapi.registry;

import com.google.gson.JsonObject;
import com.zigythebird.playeranimatorapi.modifier.CustomFirstPersonModifier;
import com.zigythebird.playeranimatorapi.modifier.HeadPosBoundCamera;
import com.zigythebird.playeranimatorapi.modifier.HeadRotBoundCamera;
import com.zigythebird.playeranimatorapi.modifier.LengthModifier;
import com.zigythebird.playeranimatorapi.modifier.MirrorOnAltHandModifier;
import com.zigythebird.playeranimatorapi.playeranims.CustomModifierLayer;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.api.layered.modifier.MirrorModifier;
import dev.kosmx.playerAnim.api.layered.modifier.SpeedModifier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class AnimModifierRegistry {
    private static final Map<class_2960, BiFunction<CustomModifierLayer, JsonObject, AbstractModifier>> modifiers = new HashMap<class_2960, BiFunction<CustomModifierLayer, JsonObject, AbstractModifier>>();

    public static void registerModifier(class_2960 ID, BiFunction<CustomModifierLayer, JsonObject, AbstractModifier> function) {
        modifiers.put(ID, function);
    }

    public static Map<class_2960, BiFunction<CustomModifierLayer, JsonObject, AbstractModifier>> getModifiers() {
        return modifiers;
    }

    public static void register() {
        AnimModifierRegistry.registerModifier(class_2960.method_60655((String)"player-animator", (String)"mirror"), (layer, json) -> new MirrorModifier());
        AnimModifierRegistry.registerModifier(class_2960.method_60655((String)"player-animator", (String)"speed"), (layer, json) -> {
            try {
                return new SpeedModifier(json.get("speed").getAsFloat());
            }
            catch (IllegalArgumentException | NullPointerException | UnsupportedOperationException e) {
                return new SpeedModifier(1.0f);
            }
        });
        AnimModifierRegistry.registerModifier(class_2960.method_60655((String)"playeranimatorapi", (String)"length"), (layer, json) -> {
            try {
                return new LengthModifier((CustomModifierLayer)((Object)layer), json.get("desiredLength").getAsFloat());
            }
            catch (IllegalArgumentException | NullPointerException | UnsupportedOperationException e) {
                return new LengthModifier((CustomModifierLayer)((Object)layer), -1.0f);
            }
        });
        AnimModifierRegistry.registerModifier(class_2960.method_60655((String)"playeranimatorapi", (String)"mirroronalthand"), (layer, json) -> new MirrorOnAltHandModifier((CustomModifierLayer)((Object)layer)));
        AnimModifierRegistry.registerModifier(class_2960.method_60655((String)"playeranimatorapi", (String)"headposboundcamera"), (layer, json) -> new HeadPosBoundCamera((CustomModifierLayer)((Object)layer)));
        AnimModifierRegistry.registerModifier(class_2960.method_60655((String)"playeranimatorapi", (String)"headrotboundcamera"), (layer, json) -> new HeadRotBoundCamera((CustomModifierLayer)((Object)layer)));
        AnimModifierRegistry.registerModifier(class_2960.method_60655((String)"playeranimatorapi", (String)"firstperson"), (layer, json) -> {
            FirstPersonMode firstPersonMode = FirstPersonMode.NONE;
            try {
                firstPersonMode = FirstPersonMode.valueOf((String)json.get("firstPersonMode").getAsString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            boolean showRightArm = false;
            boolean showLeftArm = false;
            boolean showRightItem = true;
            boolean showLeftItem = true;
            if (json.has("showRightArm")) {
                showRightArm = json.get("showRightArm").getAsBoolean();
            }
            if (json.has("showLeftArm")) {
                showLeftArm = json.get("showLeftArm").getAsBoolean();
            }
            if (json.has("showRightItem")) {
                showRightItem = json.get("showRightItem").getAsBoolean();
            }
            if (json.has("showLeftItem")) {
                showLeftItem = json.get("showLeftItem").getAsBoolean();
            }
            return new CustomFirstPersonModifier(firstPersonMode, new FirstPersonConfiguration(showRightArm, showLeftArm, showRightItem, showLeftItem));
        });
    }
}

