/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimatorapi.azure;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zigythebird.multiloaderutils.utils.Platform;
import com.zigythebird.playeranimatorapi.azure.AnimatablePlayerLayer;
import com.zigythebird.playeranimatorapi.azure.PlayerAnimationModel;
import com.zigythebird.playeranimatorapi.compatibility.PehkuiCompat;
import com.zigythebird.playeranimatorapi.misc.GetModelRendererInterface;
import com.zigythebird.playeranimatorapi.misc.PlayerModelInterface;
import mod.azure.azurelib.common.api.client.model.GeoModel;
import mod.azure.azurelib.common.api.client.renderer.GeoObjectRenderer;
import mod.azure.azurelib.common.internal.common.cache.object.BakedGeoModel;
import mod.azure.azurelib.common.internal.common.cache.object.GeoBone;
import mod.azure.azurelib.common.internal.common.constant.DataTickets;
import mod.azure.azurelib.common.internal.common.core.animatable.GeoAnimatable;
import mod.azure.azurelib.common.internal.common.core.animation.AnimationState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class PlayerAnimationRenderer<T extends AnimatablePlayerLayer>
extends GeoObjectRenderer<T>
implements PlayerModelInterface {
    public PlayerModel playerModel;

    public PlayerAnimationRenderer() {
        super(new PlayerAnimationModel());
    }

    public PlayerAnimationRenderer(GeoModel<T> model) {
        super(model);
    }

    public void preRender(PoseStack poseStack, T animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.objectRenderTranslations = new Matrix4f((Matrix4fc)poseStack.last().pose());
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
        poseStack.pushPose();
        if (Platform.isModLoaded((String)"pehkui")) {
            Vec2 scale = PehkuiCompat.getScale(((AnimatablePlayerLayer)animatable).getPlayer(), partialTick);
            poseStack.scale(scale.x, scale.y, scale.x);
        }
        this.setupAnim(this.getGeoModel().getBakedModel(this.getGeoModel().getModelResource(animatable)));
        poseStack.popPose();
    }

    public void render(PoseStack poseStack, T animatable, @Nullable MultiBufferSource bufferSource, @Nullable RenderType renderType, @Nullable VertexConsumer buffer, int packedLight) {
        if (this.playerModel != null) {
            ((GetModelRendererInterface)this.playerModel).playeranimatorapi$setRenderer(this);
        }
        if (renderType == null) {
            renderType = RenderType.entityTranslucent((ResourceLocation)this.model.getTextureResource(animatable));
        }
        super.render(poseStack, animatable, bufferSource, renderType, buffer, packedLight);
    }

    public void actuallyRender(PoseStack poseStack, T animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        Direction bedDirection;
        Object object;
        float lerpHeadRot;
        poseStack.pushPose();
        AbstractClientPlayer livingEntity = ((AnimatablePlayerLayer)animatable).getPlayer();
        boolean shouldSit = ((AnimatablePlayerLayer)animatable).getPlayer().isPassenger() && ((AnimatablePlayerLayer)animatable).getPlayer().getVehicle() != null;
        float lerpBodyRot = livingEntity == null ? 0.0f : Mth.rotLerp((float)partialTick, (float)livingEntity.yBodyRotO, (float)livingEntity.yBodyRot);
        float f = lerpHeadRot = livingEntity == null ? 0.0f : Mth.rotLerp((float)partialTick, (float)livingEntity.yHeadRotO, (float)livingEntity.yHeadRot);
        if (shouldSit && (object = ((AnimatablePlayerLayer)animatable).getPlayer().getVehicle()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)object;
            lerpBodyRot = Mth.rotLerp((float)partialTick, (float)livingentity.yBodyRotO, (float)livingentity.yBodyRot);
            float netHeadYaw = lerpHeadRot - lerpBodyRot;
            float clampedHeadYaw = Mth.clamp((float)Mth.wrapDegrees((float)netHeadYaw), (float)-85.0f, (float)85.0f);
            lerpBodyRot = lerpHeadRot - clampedHeadYaw;
            if (clampedHeadYaw * clampedHeadYaw > 2500.0f) {
                lerpBodyRot += clampedHeadYaw * 0.2f;
            }
        }
        if (((AnimatablePlayerLayer)animatable).getPlayer().getPose() == Pose.SLEEPING && livingEntity != null && (bedDirection = livingEntity.getBedOrientation()) != null) {
            float eyePosOffset = livingEntity.getEyeHeight(Pose.STANDING) - 0.1f;
            poseStack.translate((float)(-bedDirection.getStepX()) * eyePosOffset, 0.0f, (float)(-bedDirection.getStepZ()) * eyePosOffset);
        }
        float ageInTicks = (float)((AnimatablePlayerLayer)animatable).getPlayer().tickCount + partialTick;
        this.applyRotations((AnimatablePlayerLayer)animatable, poseStack, ageInTicks, lerpBodyRot, partialTick);
        if (!isReRender) {
            AnimationState animationState = new AnimationState(animatable, 0.0f, 0.0f, partialTick, false);
            long instanceId = this.getInstanceId((AnimatablePlayerLayer)animatable);
            animationState.setData(DataTickets.TICK, (Object)((AnimatablePlayerLayer)animatable).getTick(animatable));
            this.model.addAdditionalStateData(animatable, instanceId, (arg_0, arg_1) -> ((AnimationState)animationState).setData(arg_0, arg_1));
            this.model.handleAnimations(animatable, instanceId, animationState);
        }
        poseStack.translate(0.0f, 0.01f, 0.0f);
        this.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.last().pose());
        if (!((AnimatablePlayerLayer)animatable).getPlayer().isInvisibleTo((Player)Minecraft.getInstance().player)) {
            this.updateAnimatedTextureFrame((GeoAnimatable)animatable);
            for (GeoBone group : model.topLevelBones()) {
                this.renderRecursively(poseStack, (GeoAnimatable)animatable, group, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
            }
        }
        poseStack.popPose();
    }

    protected void applyRotations(AnimatablePlayerLayer animatable, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick) {
    }

    public boolean isShaking(AbstractClientPlayer entity) {
        return entity.isFullyFrozen();
    }

    protected float getDeathMaxRotation(AbstractClientPlayer animatable) {
        return 90.0f;
    }

    @Override
    public void setPlayerModel(PlayerModel model) {
        this.playerModel = model;
    }

    public void setupAnim(BakedGeoModel model) {
        this.matchPlayerModel(model, this.playerModel.head, "head");
        this.matchPlayerModel(model, this.playerModel.body, "torso");
        this.matchPlayerModel(model, this.playerModel.rightArm, "right_arm");
        this.matchPlayerModel(model, this.playerModel.leftArm, "left_arm");
        this.matchPlayerModel(model, this.playerModel.rightLeg, "right_leg");
        this.matchPlayerModel(model, this.playerModel.leftLeg, "left_leg");
    }

    public void matchPlayerModel(BakedGeoModel model, ModelPart part, String name) {
        if (model.getBone(name).isPresent()) {
            GeoBone bone = (GeoBone)model.getBone(name).get();
            bone.setPosX(-part.x);
            bone.setPosY(-part.y);
            bone.setPosZ(part.z);
            bone.setRotX(-part.xRot);
            bone.setRotY(-part.yRot);
            bone.setRotZ(part.zRot);
        }
    }

    public long getInstanceId(AnimatablePlayerLayer animatable) {
        return animatable.getPlayer().getId();
    }
}

